/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.useless.dragonfly.DisplayPos;

public class ItemModelStandard
extends ItemModel {
    protected static final Random random = new Random();
    public static final IconCoordinate ITEM_TEXTURE_MISSING = TextureRegistry.getTexture("minecraft:item/texture_missing");
    public static final IconCoordinate ITEM_TEXTURE_UNASSIGNED = TextureRegistry.getTexture("minecraft:item/texture_unassigned");
    public IconCoordinate icon = ITEM_TEXTURE_UNASSIGNED;
    @NotNull
    protected @NotNull Map<@NotNull String, @NotNull DisplayPos> displayPosMap = new HashMap<String, DisplayPos>();
    public static final DisplayPos DEFAULT_ITEM_GROUND = new DisplayPos(0.0f, 0.125f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
    public static final DisplayPos DEFAULT_ITEM_HEAD = new DisplayPos(0.0f, 0.875f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    public static final DisplayPos DEFAULT_ITEM_THIRD_PERSON_RIGHT_HAND = new DisplayPos(0.0f, 0.1875f, 0.0625f, 0.0f, 0.0f, 0.0f, 0.55f, 0.55f, 0.55f);
    public static final DisplayPos DEFAULT_ITEM_THIRD_PERSON_LEFT_HAND = new DisplayPos(0.0f, 0.1875f, 0.0625f, 0.0f, 0.0f, 0.0f, 0.55f, 0.55f, 0.55f);
    public static final DisplayPos DEFAULT_ITEM_FIRST_PERSON_RIGHT_HAND = new DisplayPos(0.070625f, 0.2f, 0.070625f, 0.0f, -90.0f, 25.0f, 0.68f, 0.68f, 0.68f);
    public static final DisplayPos DEFAULT_ITEM_FIRST_PERSON_LEFT_HAND = new DisplayPos(-0.070625f, 0.2f, 0.070625f, 0.0f, -90.0f, 25.0f, 0.68f, 0.68f, 0.68f);
    public static final DisplayPos DEFAULT_ITEM_FIXED = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    protected boolean itemfullBright = false;

    public ItemModelStandard(Item item, String namespace) {
        super(item);
        this.displayPosMap.put("ground", DEFAULT_ITEM_GROUND);
        this.displayPosMap.put("head", DEFAULT_ITEM_HEAD);
        this.displayPosMap.put("thirdperson_righthand", DEFAULT_ITEM_THIRD_PERSON_RIGHT_HAND);
        this.displayPosMap.put("thirdperson_lefthand", DEFAULT_ITEM_THIRD_PERSON_LEFT_HAND);
        this.displayPosMap.put("firstperson_righthand", DEFAULT_ITEM_FIRST_PERSON_RIGHT_HAND);
        this.displayPosMap.put("firstperson_lefthand", DEFAULT_ITEM_FIRST_PERSON_LEFT_HAND);
        this.displayPosMap.put("fixed", DEFAULT_ITEM_FIXED);
        if (namespace != null) {
            this.icon = TextureRegistry.getTexture(namespace + ":item/" + item.getKey().substring("item.".length()).replace(".", "_"));
        }
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, @NotNull String displayPosId, boolean items3d, int clusterSize, int lightmapCoord, float partialTick, boolean mirrorX) {
        random.setSeed(187L);
        DisplayPos displayPos = this.getDisplayPos(displayPosId);
        GLRenderer.modelM4f().translate(displayPos.tx, displayPos.ty, displayPos.tz);
        GLRenderer.modelM4f().rotateX(Math.toRadians(displayPos.rx));
        GLRenderer.modelM4f().rotateY(Math.toRadians(displayPos.ry));
        GLRenderer.modelM4f().rotateZ(Math.toRadians(displayPos.rz));
        GLRenderer.modelM4f().scale(displayPos.sx, displayPos.sy, displayPos.sz);
        if (items3d) {
            for (int i = 0; i < clusterSize; ++i) {
                float offX = 0.0f;
                float offY = 0.0f;
                float offZ = 0.1f * (float)i;
                GLRenderer.modelM4f().translate(0.0f, 0.0f, offZ);
                this.renderSingle(tessellator, holder, itemStack, true, lightmapCoord, this.getColor(itemStack), partialTick, mirrorX);
                GLRenderer.modelM4f().translate(-0.0f, -0.0f, -offZ);
            }
        } else {
            for (int i = 0; i < clusterSize; ++i) {
                float rOffX = 0.0f;
                float rOffY = 0.0f;
                float rOffZ = 0.0f;
                if (i > 0) {
                    rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sx;
                    rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sy;
                    rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sz;
                }
                GLRenderer.modelM4f().translate(rOffX, rOffY, rOffZ);
                this.renderSingle(tessellator, holder, itemStack, false, lightmapCoord, this.getColor(itemStack), partialTick, mirrorX);
                GLRenderer.modelM4f().translate(-rOffX, -rOffY, -rOffZ);
            }
        }
    }

    protected void renderSingle(@NotNull TessellatorGeneral tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, boolean items3d, int lightmapCoord, int color, float partialTick, boolean mirrorX) {
        this.renderCoordinate(tessellator, this.getIcon(holder, itemStack), this.itemfullBright ? LightmapHelper.getLightmapCoord(15, 15) : lightmapCoord, color, items3d, mirrorX);
    }

    protected void renderCoordinate(@NotNull TessellatorGeneral tessellator, @NotNull IconCoordinate coordinate, int lightmap, int color, boolean items3d, boolean mirrorX) {
        double cUMin = mirrorX ? coordinate.getIconUMax() : coordinate.getIconUMin();
        double cUMax = mirrorX ? coordinate.getIconUMin() : coordinate.getIconUMax();
        double cVMin = coordinate.getIconVMin();
        double cVMax = coordinate.getIconVMax();
        coordinate.parentAtlas.bind();
        if (items3d) {
            float halfThickness = 0.03125f;
            int pxH = coordinate.height;
            int pxW = coordinate.width;
            tessellator.startDrawingQuads();
            tessellator.setLightmapCoord1i(lightmap);
            tessellator.setColor1i(color);
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            tessellator.addVertexWithUV(-0.5, 0.5, -0.03125, cUMin, cVMin);
            tessellator.addVertexWithUV(0.5, 0.5, -0.03125, cUMax, cVMin);
            tessellator.addVertexWithUV(0.5, -0.5, -0.03125, cUMax, cVMax);
            tessellator.addVertexWithUV(-0.5, -0.5, -0.03125, cUMin, cVMax);
            for (int h = 0; h < pxH; ++h) {
                double y1 = (double)h / (double)pxH;
                double y2 = (double)(h + 1) / (double)pxH;
                double vMin = coordinate.getSubIconV(y1);
                double vMax = coordinate.getSubIconV(y2);
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                tessellator.addVertexWithUV(-0.5, 0.5 - y1, -0.03125, cUMin, vMin);
                tessellator.addVertexWithUV(-0.5, 0.5 - y1, 0.03125, cUMin, vMax);
                tessellator.addVertexWithUV(0.5, 0.5 - y1, 0.03125, cUMax, vMax);
                tessellator.addVertexWithUV(0.5, 0.5 - y1, -0.03125, cUMax, vMin);
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                tessellator.addVertexWithUV(-0.5, 0.5 - y2, -0.03125, cUMin, vMin);
                tessellator.addVertexWithUV(0.5, 0.5 - y2, -0.03125, cUMax, vMin);
                tessellator.addVertexWithUV(0.5, 0.5 - y2, 0.03125, cUMax, vMax);
                tessellator.addVertexWithUV(-0.5, 0.5 - y2, 0.03125, cUMin, vMax);
            }
            for (int w = 0; w < pxW; ++w) {
                double x1 = (double)w / (double)pxW;
                double x2 = (double)(w + 1) / (double)pxW;
                double uMin = coordinate.getSubIconU(mirrorX ? 1.0 - x1 : x1);
                double uMax = coordinate.getSubIconU(mirrorX ? 1.0 - x2 : x2);
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                tessellator.addVertexWithUV(x1 - 0.5, 0.5, -0.03125, uMin, cVMin);
                tessellator.addVertexWithUV(x1 - 0.5, -0.5, -0.03125, uMax, cVMax);
                tessellator.addVertexWithUV(x1 - 0.5, -0.5, 0.03125, uMax, cVMax);
                tessellator.addVertexWithUV(x1 - 0.5, 0.5, 0.03125, uMin, cVMin);
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                tessellator.addVertexWithUV(x2 - 0.5, 0.5, -0.03125, uMin, cVMin);
                tessellator.addVertexWithUV(x2 - 0.5, 0.5, 0.03125, uMin, cVMin);
                tessellator.addVertexWithUV(x2 - 0.5, -0.5, 0.03125, uMax, cVMax);
                tessellator.addVertexWithUV(x2 - 0.5, -0.5, -0.03125, uMax, cVMax);
            }
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            tessellator.addVertexWithUV(-0.5, 0.5, 0.03125, cUMin, cVMin);
            tessellator.addVertexWithUV(-0.5, -0.5, 0.03125, cUMin, cVMax);
            tessellator.addVertexWithUV(0.5, -0.5, 0.03125, cUMax, cVMax);
            tessellator.addVertexWithUV(0.5, 0.5, 0.03125, cUMax, cVMin);
            tessellator.draw();
        } else {
            tessellator.startDrawingQuads();
            tessellator.setLightmapCoord1i(lightmap);
            tessellator.setColor1i(color);
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            tessellator.addVertexWithUV(-0.5, 0.5, 0.0, cUMin, cVMin);
            tessellator.addVertexWithUV(-0.5, -0.5, 0.0, cUMin, cVMax);
            tessellator.addVertexWithUV(0.5, -0.5, 0.0, cUMax, cVMax);
            tessellator.addVertexWithUV(0.5, 0.5, 0.0, cUMax, cVMin);
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            tessellator.addVertexWithUV(-0.5, 0.5, 0.0, cUMin, cVMin);
            tessellator.addVertexWithUV(0.5, 0.5, 0.0, cUMax, cVMin);
            tessellator.addVertexWithUV(0.5, -0.5, 0.0, cUMax, cVMax);
            tessellator.addVertexWithUV(-0.5, -0.5, 0.0, cUMin, cVMax);
            tessellator.draw();
        }
    }

    @NotNull
    public DisplayPos getDisplayPos(@NotNull String id) {
        return this.displayPosMap.getOrDefault(id, DisplayPos.DEFAULT_DISPLAY_POS);
    }

    @NotNull
    public ItemModelStandard setDisplayPos(@NotNull String id, @NotNull DisplayPos displayPos) {
        this.displayPosMap.put(id, Objects.requireNonNull(displayPos, "Display pos cannot be null!"));
        return this;
    }

    @Override
    public void renderItemOverlayIntoGUI(@NotNull TessellatorGeneral tessellator, @NotNull FontRenderer fontRenderer, @NotNull TextureManager textureManager, @NotNull ItemStack itemstack, int x, int y, @Nullable String override, float alpha) {
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        int a = (int)(alpha * 255.0f);
        if (itemstack.stackSize != 1 || override != null) {
            String s = override != null ? override : "" + itemstack.stackSize;
            GLRenderer.disableState(State.DEPTH_TEST);
            fontRenderer.render(s, x + 19 - 2 - fontRenderer.stringWidth(s), y + 6 + 3).setShadow().setColor(0xFFFFFF | a << 24).call();
            GLRenderer.enableState(State.DEPTH_TEST);
        }
        if (itemstack.isItemDamaged() || itemstack.getItem().showFullDurability()) {
            int barWidth = (int)java.lang.Math.round(13.0 - (double)itemstack.getItemDamageForDisplay() * 13.0 / (double)itemstack.getMaxDamage());
            int progress = (int)java.lang.Math.round(255.0 - (double)itemstack.getItemDamageForDisplay() * 255.0 / (double)itemstack.getMaxDamage());
            GLRenderer.pushFrame();
            GLRenderer.disableState(State.DEPTH_TEST);
            GLRenderer.setShader(Shaders.COLOR);
            int colorFG = Color.HSBtoRGB((float)progress / 255.0f / 3.0f, 1.0f, 1.0f);
            int colorBG = (255 - progress) / 4 << 16 | 0x3F00;
            tessellator.startDrawingQuads();
            this.renderColoredQuad(tessellator, x + 2, y + 13, 13, 2, 0, a);
            this.renderColoredQuad(tessellator, x + 2, y + 13, 12, 1, colorBG, a);
            this.renderColoredQuad(tessellator, x + 2, y + 13, barWidth, 1, colorFG, a);
            tessellator.draw();
            GLRenderer.popFrame();
        }
        GLRenderer.popFrame();
    }

    protected void renderColoredQuad(TessellatorGeneral tessellator, int x, int y, int width, int height, int colorRGB, int alpha) {
        float z = 0.0f;
        tessellator.setColor2i(colorRGB, alpha);
        tessellator.addVertex(x, y, 0.0);
        tessellator.addVertex(x, y + height, 0.0);
        tessellator.addVertex(x + width, y + height, 0.0);
        tessellator.addVertex(x + width, y, 0.0);
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        return this.icon;
    }

    public int getColor(ItemStack stack) {
        return this.getColorFromMeta(stack.getMetadata());
    }

    public int getColorFromMeta(int meta) {
        return -1;
    }

    public ItemModelStandard setFullBright() {
        this.itemfullBright = true;
        return this;
    }
}

