/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.stitcher;

import com.mojang.logging.LogUtils;
import java.io.InputStream;
import net.minecraft.client.render.texture.meta.TextureMetaHandler;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class IconCoordinate {
    private static final Logger LOGGER = LogUtils.getLogger();
    public int iconX;
    public int iconY;
    public int width;
    public int height;
    private double uMin;
    private double uMax;
    private double vMin;
    private double vMax;
    private double uSize;
    private double vSize;
    @NotNull
    protected final TextureMetaHandler metaHandler = new TextureMetaHandler();
    @NotNull
    public final NamespaceID namespaceId;
    @NotNull
    public final AtlasStitcher parentAtlas;

    public IconCoordinate(@NotNull AtlasStitcher stitcher, @NotNull NamespaceID namespaceId) {
        this.parentAtlas = stitcher;
        this.namespaceId = namespaceId;
    }

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    protected void setPosition(int x, int y) {
        this.iconX = x;
        this.iconY = y;
    }

    protected void cacheUVs() {
        this.uMin = (double)this.iconX * this.parentAtlas.getInverseWidth();
        this.uMax = ((double)this.iconX + (double)this.width) * this.parentAtlas.getInverseWidth();
        this.vMin = (double)this.iconY * this.parentAtlas.getInverseHeight();
        this.vMax = ((double)this.iconY + (double)this.height) * this.parentAtlas.getInverseHeight();
        this.uSize = (double)this.width * this.parentAtlas.getInverseWidth();
        this.vSize = (double)this.height * this.parentAtlas.getInverseHeight();
    }

    public int getArea() {
        return this.width * this.height;
    }

    public double getIconUMin() {
        return this.uMin;
    }

    public double getIconUMax() {
        return this.uMax;
    }

    public double getIconVMin() {
        return this.vMin;
    }

    public double getIconVMax() {
        return this.vMax;
    }

    public double getSubIconU(double offset) {
        return this.uMin + this.uSize * offset;
    }

    public double getSubIconV(double offset) {
        return this.vMin + this.vSize * offset;
    }

    public double getIconUSize() {
        return this.uSize;
    }

    public double getIconVSize() {
        return this.vSize;
    }

    @NotNull
    public String toString() {
        return String.format("W:%d, H:%d, X:%d, Y:%d | ID:%s", this.width, this.height, this.iconX, this.iconY, this.namespaceId);
    }

    protected void resetMetadata() {
        this.metaHandler.reset();
    }

    protected void initMetadata(InputStream stream) {
        try {
            this.metaHandler.loadFromStream(stream);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load metadata for '{}'!", (Object)this.namespaceId, (Object)e);
        }
    }

    public boolean hasMeta(@NotNull String key) {
        return this.metaHandler.has(key);
    }

    @Nullable
    public <T> T getMeta(@NotNull String key, @NotNull Class<T> aClass) {
        return this.metaHandler.get(key, aClass);
    }

    public <T> T getOrDefaultMeta(@NotNull String key, @NotNull T metaDefault, @NotNull Class<T> aClass) {
        return this.metaHandler.getOrDefault(key, metaDefault, aClass);
    }
}

