/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk.reader;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import net.minecraft.core.NextTickListEntry;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.reader.ChunkReader;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkReaderVersion3
extends ChunkReader {
    @NotNull
    private final ListTag sectionsTag;

    public ChunkReaderVersion3(@Nullable World world, @NotNull CompoundTag chunkTag) {
        super(world, chunkTag);
        this.sectionsTag = chunkTag.getList("Sections");
    }

    @Nullable
    private CompoundTag findSection(int y) {
        for (Tag<?> tag : this.sectionsTag) {
            CompoundTag cTag;
            int tagY;
            if (!(tag instanceof CompoundTag) || (tagY = (cTag = (CompoundTag)tag).getInteger("yPos")) != y) continue;
            return cTag;
        }
        return null;
    }

    @Override
    public int getX() {
        return this.tag.getInteger("xPos");
    }

    @Override
    public int getZ() {
        return this.tag.getInteger("zPos");
    }

    @Override
    public long getTicksOnUnload() {
        return this.tag.getLong("TicksOnUnload");
    }

    @Override
    public short @Nullable [] getBlocks(int ySection) {
        short @Nullable [] blocks = null;
        @Nullable CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            blocks = sectionTag.getShortArrayOrDefault("Blocks", null);
        }
        return blocks;
    }

    @Override
    @Nullable
    public ChunkUnsignedByteArray getData(int ySection) {
        byte[] data = null;
        @Nullable CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            data = sectionTag.getByteArrayOrDefault("Data", null);
        }
        if (data == null) {
            return null;
        }
        return new ChunkUnsignedByteArray(16, 16, 16, data);
    }

    @Override
    @Nullable
    public ChunkNibbleArray getSkyLight(int ySection) {
        byte @Nullable [] skylight = null;
        CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            skylight = sectionTag.getByteArrayOrDefault("SkyLight", null);
        }
        if (skylight == null) {
            return null;
        }
        return new ChunkNibbleArray(16, 16, 16, skylight);
    }

    @Override
    @Nullable
    public ChunkNibbleArray getBlockLight(int ySection) {
        byte @Nullable [] blocklight = null;
        CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            blocklight = sectionTag.getByteArrayOrDefault("BlockLight", null);
        }
        if (blocklight == null) {
            return null;
        }
        return new ChunkNibbleArray(16, 16, 16, blocklight);
    }

    @Override
    public short @Nullable [] getHeightMap() {
        return this.tag.getShortArrayOrDefault("HeightMap", null);
    }

    @Override
    public int getAverageBlockHeight() {
        return this.tag.getInteger("AverageBlockHeight");
    }

    @Override
    public boolean getIsTerrainPopulated() {
        return this.tag.getBoolean("TerrainPopulated");
    }

    @Override
    public double @Nullable [] getTemperatureMap() {
        return this.tag.getDoubleArray("TemperatureMap");
    }

    @Override
    public double @Nullable [] getHumidityMap() {
        return this.tag.getDoubleArray("HumidityMap");
    }

    @Override
    public byte @Nullable [] getBiomeMap(int ySection, @NotNull Int2ObjectMap<String> biomeRegistry) {
        byte[] biomeMap = null;
        CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            biomeMap = sectionTag.getByteArrayOrDefault("BiomeMap", null);
        }
        if (biomeMap == null) {
            biomeMap = new byte[512];
            Arrays.fill(biomeMap, (byte)-1);
        } else {
            for (int i = 0; i < biomeMap.length; ++i) {
                byte oldBiomeId = biomeMap[i];
                if (oldBiomeId < 0) continue;
                try {
                    biomeMap[i] = (byte)Registries.BIOMES.getNumericIdOfItem(Registries.BIOMES.getItem((String)biomeRegistry.get(oldBiomeId)));
                    continue;
                }
                catch (NullPointerException n) {
                    biomeMap[i] = -1;
                }
            }
        }
        return biomeMap;
    }

    @Override
    @Nullable
    public Int2ObjectMap<String> getBiomeRegistry() {
        @Nullable CompoundTag registriesTag = this.tag.getCompoundOrDefault("Registries", null);
        CompoundTag biomesTag = null;
        if (registriesTag != null) {
            biomesTag = registriesTag.getCompoundOrDefault("Biomes", null);
        }
        if (registriesTag == null || biomesTag == null) {
            return null;
        }
        return Registry.readIdMapFromTag(biomesTag);
    }

    @Override
    @Nullable
    public Int2ObjectMap<NextTickListEntry> getTickList() {
        @Nullable ListTag ticksTag = this.tag.getListOrDefault("TicksList", null);
        if (ticksTag == null) {
            return null;
        }
        @NotNull Int2ObjectArrayMap<NextTickListEntry> entries = new Int2ObjectArrayMap<NextTickListEntry>();
        return entries;
    }
}

