/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiVector2D")
public class AIVector2D
extends Struct<AIVector2D>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected AIVector2D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIVector2D create(long address, @Nullable ByteBuffer container) {
        return new AIVector2D(address, container);
    }

    public AIVector2D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIVector2D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return AIVector2D.nx(this.address());
    }

    public float y() {
        return AIVector2D.ny(this.address());
    }

    public static AIVector2D malloc() {
        return new AIVector2D(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIVector2D calloc() {
        return new AIVector2D(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIVector2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIVector2D(MemoryUtil.memAddress(container), container);
    }

    public static AIVector2D create(long address) {
        return new AIVector2D(address, null);
    }

    @Nullable
    public static AIVector2D createSafe(long address) {
        return address == 0L ? null : new AIVector2D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIVector2D.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIVector2D.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIVector2D mallocStack() {
        return AIVector2D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIVector2D callocStack() {
        return AIVector2D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIVector2D mallocStack(MemoryStack stack) {
        return AIVector2D.malloc(stack);
    }

    @Deprecated
    public static AIVector2D callocStack(MemoryStack stack) {
        return AIVector2D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIVector2D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIVector2D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVector2D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVector2D.calloc(capacity, stack);
    }

    public static AIVector2D malloc(MemoryStack stack) {
        return new AIVector2D(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIVector2D calloc(MemoryStack stack) {
        return new AIVector2D(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    static {
        Struct.Layout layout = AIVector2D.__struct(AIVector2D.__member(4), AIVector2D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIVector2D, Buffer>
    implements NativeResource {
        private static final AIVector2D ELEMENT_FACTORY = AIVector2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIVector2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return AIVector2D.nx(this.address());
        }

        public float y() {
            return AIVector2D.ny(this.address());
        }
    }
}

