/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ClickableLabelElement;
import net.minecraft.client.gui.DrawableSurfaceElement;
import net.minecraft.client.gui.TexturedButtonElement;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.gui.drawing.DrawableEditor;
import net.minecraft.client.gui.drawing.IDrawableSurface;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.PacketCustomPayload;
import net.minecraft.core.player.inventory.menu.MenuFlag;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

public class ScreenFlagEditor
extends ScreenContainerAbstract
implements IDrawableSurface<Byte> {
    private final TileEntityFlag flagEntity;
    private final int CANVAS_SCALE = 4;
    private final int CANVAS_WIDTH = 24;
    private final int CANVAS_HEIGHT = 16;
    private int xLast = 0;
    private int yLast = 0;
    private int mouseButton;
    private int tickCount = 0;
    private boolean isDrawing = false;
    private int canvasX = 0;
    private int canvasY = 0;
    private int selectedColor = 0;
    private ClickableLabelElement[] colorLabels;
    private final DrawableEditor<Byte> flagSurfaceEditor;
    private final DrawableEditor<Byte> drawOverlaySurfaceEditor;
    private TexturedButtonElement[] toolBtns;
    private int activeTool = 0;
    DrawableSurfaceElement flagSurface;
    DrawableSurfaceElement drawOverlaySurface;
    private static final ByteBuffer flagBuffer = ByteBuffer.allocate(385).order(ByteOrder.LITTLE_ENDIAN);

    public ScreenFlagEditor(Player player, TileEntityFlag flagTileEntity) {
        super(new MenuFlag(player.inventory, flagTileEntity));
        this.flagEntity = flagTileEntity;
        this.xSize = 176;
        this.ySize = 195;
        flagTileEntity.owner = player.uuid;
        this.flagSurface = new DrawableSurfaceElement(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, this.CANVAS_SCALE, flagTileEntity.flagColors);
        this.flagSurfaceEditor = new DrawableEditor<Byte>(this.flagSurface);
        this.drawOverlaySurface = new DrawableSurfaceElement(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, this.CANVAS_SCALE);
        this.drawOverlaySurfaceEditor = new DrawableEditor<Byte>(this.drawOverlaySurface);
    }

    @Override
    public void init() {
        int i;
        super.init();
        this.buttons.clear();
        this.canvasX = (this.width - this.xSize) / 2 + 27;
        this.canvasY = (this.height - this.ySize) / 2 + 8;
        this.toolBtns = new TexturedButtonElement[7];
        for (i = 0; i < 7; ++i) {
            this.toolBtns[i] = new TexturedButtonElement(i, "/assets/minecraft/textures/gui/container/flag_editor.png", (this.width - this.xSize) / 2 + 12 + 22 * i, (this.height - this.ySize) / 2 + 76, 20 * i, 195, 20, 20);
            if (i == this.activeTool) {
                this.toolBtns[i].enabled = false;
            }
            this.buttons.add(this.toolBtns[i]);
        }
        this.colorLabels = new ClickableLabelElement[3];
        for (i = 0; i < 3; ++i) {
            this.colorLabels[i] = new ClickableLabelElement(100 + i, (this.width - this.xSize) / 2 + 150, (this.height - this.ySize) / 2 + 12 + i * 22, String.valueOf(i + 1), -1, 0);
            if (i != this.selectedColor) {
                this.colorLabels[i].setTextColor(-12632257);
                this.colorLabels[i].setShadow(false);
            }
            this.buttons.add(this.colorLabels[i]);
        }
        this.buttons.add(new ButtonElement(50, (this.width - this.xSize) / 2 + 12, (this.height - this.ySize) / 2 + 61, 12, 12, "").setTextures("minecraft:gui/misc/button_flag_flip", "minecraft:gui/misc/button_flag_flip_highlighted", "minecraft:gui/misc/button_flag_flip_disabled.png"));
    }

    private void renderCanvas() {
        this.canvasX = (this.width - this.xSize) / 2 + 27;
        this.canvasY = (this.height - this.ySize) / 2 + 8;
        int[] colors = new int[5];
        for (int i = 1; i < 4; ++i) {
            ItemStack stack = this.flagEntity.getItem(35 + i);
            if (stack == null || stack.getItem() != Items.DYE) continue;
            colors[i] = Colors.allFlagColors[TextFormatting.get((int)(15 - stack.getMetadata())).id].getARGB();
        }
        colors[4] = -1;
        this.flagSurface.colors = colors;
        this.drawOverlaySurface.colors = colors;
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.ONE_MINUS_SRC_ALPHA, BlendFactor.SRC_COLOR);
        this.flagSurface.render(this.canvasX, this.canvasY);
        GLRenderer.disableState(State.BLEND);
        this.drawOverlaySurface.render(this.canvasX, this.canvasY);
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        if (this.flagEntity.getItem(36 + this.selectedColor) == null) {
            return;
        }
        if (this.activeTool >= 0 && this.activeTool < 3) {
            if (!this.isDrawing) {
                int xInCanvas = (mx - this.canvasX) / this.CANVAS_SCALE;
                int yInCanvas = (my - this.canvasY) / this.CANVAS_SCALE;
                if (xInCanvas >= 0 && xInCanvas < this.CANVAS_WIDTH && yInCanvas >= 0 && yInCanvas < this.CANVAS_HEIGHT) {
                    this.isDrawing = true;
                    this.xLast = xInCanvas;
                    this.yLast = yInCanvas;
                    this.mouseButton = buttonNum;
                    byte color = 0;
                    if (this.mouseButton == 0) {
                        color = (byte)(this.selectedColor + 1);
                    }
                    this.flagSurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
                    this.flagEntity.isDirty = true;
                }
            }
        } else if (this.activeTool == 3) {
            if (!this.isDrawing) {
                int xInCanvas = (mx - this.canvasX) / this.CANVAS_SCALE;
                int yInCanvas = (my - this.canvasY) / this.CANVAS_SCALE;
                if (xInCanvas >= 0 && xInCanvas < this.CANVAS_WIDTH && yInCanvas >= 0 && yInCanvas < this.CANVAS_HEIGHT) {
                    this.isDrawing = true;
                    this.mouseButton = buttonNum;
                    byte color = 0;
                    if (this.mouseButton == 0) {
                        color = (byte)(this.selectedColor + 1);
                    }
                    this.flagSurfaceEditor.floodFill(xInCanvas, yInCanvas, color);
                    this.flagEntity.isDirty = true;
                }
            }
        } else if (!(this.activeTool != 4 && this.activeTool != 5 && this.activeTool != 6 || this.isDrawing)) {
            int xInCanvas = (mx - this.canvasX) / this.CANVAS_SCALE;
            int yInCanvas = (my - this.canvasY) / this.CANVAS_SCALE;
            if (xInCanvas >= 0 && xInCanvas < this.CANVAS_WIDTH && yInCanvas >= 0 && yInCanvas < this.CANVAS_HEIGHT) {
                this.isDrawing = true;
                this.mouseButton = buttonNum;
                this.xLast = xInCanvas;
                this.yLast = yInCanvas;
            }
        }
    }

    @Override
    public void tick() {
        ++this.tickCount;
        if (this.mc.currentWorld.isClientSide && this.tickCount % 40 == 0) {
            this.sendUpdatePacket();
        }
    }

    @Override
    public void removed() {
        super.removed();
        if (this.mc.currentWorld != null && this.mc.currentWorld.isClientSide) {
            this.sendUpdatePacket();
        }
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        super.buttonClicked(button);
        if (button.id >= 0 && button.id < 7) {
            this.toolBtns[this.activeTool].enabled = true;
            this.activeTool = button.id;
            button.enabled = false;
        }
        if (button.id == 50) {
            this.flagEntity.setFlipped(!this.flagEntity.getFlipped());
            if (this.mc.currentWorld.isClientSide) {
                this.sendUpdatePacket();
            }
        }
        if (button.id >= 100 && button.id < 103) {
            this.colorLabels[this.selectedColor].setTextColor(-12566464);
            this.colorLabels[this.selectedColor].setShadow(false);
            this.selectedColor = button.id - 100;
            this.colorLabels[this.selectedColor].setTextColor(0xFFFFFFF);
            this.colorLabels[this.selectedColor].setShadow(true);
        }
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        if (this.activeTool >= 0 && this.activeTool < 3) {
            if (this.isDrawing && buttonNum != -1) {
                this.isDrawing = false;
                this.mouseButton = -1;
            } else if (this.isDrawing) {
                int xInCanvas = (mx - this.canvasX) / this.CANVAS_SCALE;
                int yInCanvas = (my - this.canvasY) / this.CANVAS_SCALE;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                if (MathHelper.abs(this.xLast - xInCanvas) <= 1.0f && MathHelper.abs(this.yLast - yInCanvas) <= 1.0f) {
                    this.flagSurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
                    this.flagEntity.isDirty = true;
                } else {
                    this.flagSurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, this.activeTool + 1);
                    this.flagEntity.isDirty = true;
                }
                this.xLast = xInCanvas;
                this.yLast = yInCanvas;
            }
        } else if (this.activeTool == 3) {
            if (this.isDrawing && buttonNum != -1) {
                this.isDrawing = false;
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 4) {
            if (this.isDrawing && buttonNum != -1) {
                this.isDrawing = false;
                int xInCanvas = (mx - this.canvasX) / this.CANVAS_SCALE;
                int yInCanvas = (my - this.canvasY) / this.CANVAS_SCALE;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                this.flagSurfaceEditor.drawRectangle(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
                this.flagEntity.isDirty = true;
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 5) {
            if (this.isDrawing && buttonNum != -1) {
                this.isDrawing = false;
                int xInCanvas = (mx - this.canvasX) / this.CANVAS_SCALE;
                int yInCanvas = (my - this.canvasY) / this.CANVAS_SCALE;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                this.flagSurfaceEditor.drawEllipse(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
                this.flagEntity.isDirty = true;
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 6 && this.isDrawing && buttonNum != -1) {
            this.isDrawing = false;
            int xInCanvas = (mx - this.canvasX) / this.CANVAS_SCALE;
            int yInCanvas = (my - this.canvasY) / this.CANVAS_SCALE;
            byte color = 0;
            if (this.mouseButton == 0) {
                color = (byte)(this.selectedColor + 1);
            }
            this.flagSurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, 1);
            this.flagEntity.isDirty = true;
            this.mouseButton = -1;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTick) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/flag_editor.png").bind();
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
        this.drawTexturedModalRect(j + 127, k + 8 + this.selectedColor * 22, 176, 0, 20, 20);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        super.render(mx, my, partialTick);
        this.drawOverlaySurface.clear();
        int xInCanvas = (mx - this.canvasX) / this.CANVAS_SCALE;
        int yInCanvas = (my - this.canvasY) / this.CANVAS_SCALE;
        byte color = (byte)(this.selectedColor + 1);
        if (this.mouseButton == 1) {
            color = 4;
        }
        if (this.activeTool >= 0 && this.activeTool < 3) {
            this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
        } else if (this.activeTool == 3) {
            this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
        } else if (this.activeTool == 4) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawRectangle(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        } else if (this.activeTool == 5) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawEllipse(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        } else if (this.activeTool == 6) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, 1);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        }
        this.renderCanvas();
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.drawStringNoShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.edit_flag.label.inventory"), 8, this.ySize - 96 + 2, -12566464);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE || this.mc.gameSettings.keyInventory.isKeyboardKey(eventKey) || eventKey == Keyboard.KEY_BACK) {
            this.mc.thePlayer.closeScreen();
        }
        if (eventKey == Keyboard.KEY_1 || eventKey == Keyboard.KEY_2 || eventKey == Keyboard.KEY_3) {
            this.colorLabels[this.selectedColor].setTextColor(-12566464);
            this.colorLabels[this.selectedColor].setShadow(false);
            this.selectedColor = eventKey - Keyboard.KEY_1;
            this.colorLabels[this.selectedColor].setTextColor(-1);
            this.colorLabels[this.selectedColor].setShadow(true);
        }
        super.keyPressed(eventCharacter, eventKey, mx, my);
    }

    @Override
    public int getWidth() {
        return this.CANVAS_WIDTH;
    }

    @Override
    public int getHeight() {
        return this.CANVAS_HEIGHT;
    }

    @Override
    public Byte getPixelValue(int x, int y) {
        if (x < 0 || x >= this.CANVAS_WIDTH) {
            return (byte)0;
        }
        if (y < 0 || y >= this.CANVAS_HEIGHT) {
            return (byte)0;
        }
        return this.flagEntity.flagColors[x + 24 * y];
    }

    @Override
    public boolean setPixelValue(int x, int y, Byte value) {
        if (x < 0 || x >= this.CANVAS_WIDTH) {
            return false;
        }
        if (y < 0 || y >= this.CANVAS_HEIGHT) {
            return false;
        }
        this.flagEntity.flagColors[x + 24 * y] = value;
        this.flagEntity.isDirty = true;
        return true;
    }

    public void sendUpdatePacket() {
        flagBuffer.clear();
        byte header = 0;
        if (this.flagEntity.flipped) {
            header = (byte)(header | 1);
        }
        flagBuffer.put(header);
        flagBuffer.put(this.flagEntity.flagColors);
        this.mc.getSendQueue().addToSendQueue(new PacketCustomPayload("BTA:Flag", flagBuffer.flip()));
    }
}

