/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.GuiElement;
import net.minecraft.client.gui.ListLayout;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.gui.options.OverlayButtonElement;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.OptionBoolean;
import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.DamageType;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class ScreenInventory
extends ScreenContainerAbstract {
    private ButtonElement armorButton;
    protected int armourValuesFloat = 130;
    protected int armourButtonFloatX = 20;
    protected float xSize_lo;
    protected float ySize_lo;
    protected ListLayout overlayButtonsLayout = new ListLayout(this).setAlign(0.5, 0.5).setVertical(false).setElementSize(11, 11).setOffset(-(this.xSize / 2), -(this.ySize / 2) - 10).setMargin(1);
    private final IntList uvs = new IntArrayList();
    private DamageType hoveredDamageType;
    protected Color protectionOverlayBgColor = new Color().setRGBA(0, 0, 0, 127);

    public ScreenInventory(Player player) {
        super(player.inventoryMenu);
        this.passEvents = true;
        player.addStat(Achievements.OPEN_INVENTORY, 1);
    }

    @Override
    public void init() {
        this.buttons.clear();
        this.armorButton = new ButtonElement(100, this.width / 2 - this.armourButtonFloatX, this.height / 2 - 74, 9, 9, "");
        this.armorButton.visible = false;
        this.checkForArmor();
        this.buttons.add(this.armorButton);
        this.updateOverlayButtons();
    }

    @Override
    public void tick() {
        this.checkForArmor();
    }

    protected void checkForArmor() {
        boolean enableArmorButton = false;
        for (int i = 0; i < this.mc.thePlayer.inventory.armorInventory.length; ++i) {
            ItemStack itemStack = this.mc.thePlayer.getItemInArmorSlot(HumanArmorShape.values()[i]);
            if (itemStack == null) continue;
            enableArmorButton = true;
            break;
        }
        this.armorButton.enabled = enableArmorButton;
    }

    public void updateOverlayButtons() {
        GameSettings settings = this.mc.gameSettings;
        boolean clock = false;
        boolean compass = false;
        boolean rotaryCalendar = false;
        if (this.mc.thePlayer.getGamemode() == Gamemodes.CREATIVE) {
            clock = true;
            compass = true;
            rotaryCalendar = true;
        } else {
            for (int iinv = 0; iinv < this.mc.thePlayer.inventory.getContainerSize(); ++iinv) {
                ItemStack item = this.mc.thePlayer.inventory.getItem(iinv);
                if (item == null) continue;
                if (item.itemID == Items.TOOL_CLOCK.id) {
                    clock = true;
                }
                if (item.itemID == Items.TOOL_COMPASS.id) {
                    compass = true;
                }
                if (item.itemID != Items.TOOL_CALENDAR.id) continue;
                rotaryCalendar = true;
            }
        }
        this.overlayButtonsLayout.elements.clear();
        if (compass) {
            this.overlayButtonsLayout.addElement(new OverlayButtonElement<OptionBoolean>(settings, settings.overlayShowCoords));
            this.uvs.add(0);
            this.overlayButtonsLayout.addElement(new OverlayButtonElement<OptionBoolean>(settings, settings.overlayShowDirection));
            this.uvs.add(1);
        }
        if (clock) {
            this.overlayButtonsLayout.addElement(new OverlayButtonElement<OptionBoolean>(settings, settings.overlayShowTime));
            this.uvs.add(2);
        }
        if (rotaryCalendar) {
            this.overlayButtonsLayout.addElement(new OverlayButtonElement<OptionBoolean>(settings, settings.overlayShowSeason));
            this.uvs.add(3);
            this.overlayButtonsLayout.addElement(new OverlayButtonElement<OptionBoolean>(settings, settings.overlayShowWeather));
            this.uvs.add(4);
            this.overlayButtonsLayout.addElement(new OverlayButtonElement<OptionBoolean>(settings, settings.overlayShowBiome));
            this.uvs.add(5);
        }
        this.overlayButtonsLayout.updateElementPositions();
        for (GuiElement element : this.overlayButtonsLayout.elements) {
            ButtonElement button = (ButtonElement)element;
            button.visible = false;
            this.buttons.add(button);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.drawStringNoShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.inventory.label.crafting"), 86, 16, 0x404040);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        OverlayButtonElement button;
        int i;
        super.render(mx, my, partialTick);
        this.xSize_lo = mx;
        this.ySize_lo = my;
        if (((Boolean)this.mc.gameSettings.armorProtectionOverlay.value).booleanValue() && this.armorButton.enabled) {
            this.drawProtectionOverlay(mx, my);
        }
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/inventory.png").bind();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.BLEND);
        if (this.armorButton.enabled) {
            if (this.armorButton.isHovered(mx, my)) {
                this.drawTexturedModalRect(this.armorButton.xPosition, this.armorButton.yPosition, 185, 0, this.armorButton.width, this.armorButton.height);
            } else {
                this.drawTexturedModalRect(this.armorButton.xPosition, this.armorButton.yPosition, 176, 0, this.armorButton.width, this.armorButton.height);
            }
        }
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        for (i = 0; i < this.overlayButtonsLayout.elements.size(); ++i) {
            button = (OverlayButtonElement)this.overlayButtonsLayout.elements.get(i);
            this.addTexturedModalRect(t, button.xPosition + 1, button.yPosition + 1, 176, 9 + 9 * this.uvs.getInt(i), 9, 9);
            boolean val = true;
            if (button.option instanceof OptionBoolean) {
                val = (Boolean)((Option)button.option).value;
            }
            if (val) continue;
            this.addTexturedModalRect(t, button.xPosition + 1, button.yPosition + 1, 194, 0, 9, 9);
        }
        t.draw();
        for (i = 0; i < this.overlayButtonsLayout.elements.size(); ++i) {
            button = (OverlayButtonElement)this.overlayButtonsLayout.elements.get(i);
            if (!button.isHovered(mx, my)) continue;
            this.tooltipElement.render(((Option)button.option).getDisplayStringName() + ": " + button.displayString, mx, my, 8, -8);
        }
    }

    public void drawProtectionOverlay(int mouseX, int mouseY) {
        this.hoveredDamageType = null;
        int x = this.width / 2 - this.armourValuesFloat - 4;
        int y = this.height / 2 - 79;
        int w = 44;
        int h = 44;
        this.drawGradientRect(x, y, x + w, y + h, this.protectionOverlayBgColor.getARGB(), this.protectionOverlayBgColor.getARGB());
        GLRenderer.disableState(State.BLEND);
        GLRenderer.disableState(State.CULL_FACE);
        int w2 = 26;
        int x2 = x;
        int h2 = 4;
        int i = 0;
        for (DamageType damageType : DamageType.values()) {
            if (damageType.shouldDisplay()) {
                int y2 = y + i * 10;
                float protection = this.mc.thePlayer.getTotalProtectionAmount(damageType);
                if (protection > 1.0f) {
                    protection = 1.0f;
                }
                int l = (int)(protection * 255.0f);
                int color = 255 - l << 16 | l << 8 | 0xFF000000;
                GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this.drawGuiIcon(x2 + 2, y2 + 2, 9, 9, TextureRegistry.getTexture(damageType.getIcon()));
                this.drawRectWidthHeight(x2 + 14, y2 + 4, w2 + 2, h2 + 1, -16777216);
                this.drawRectWidthHeight(x2 + 15, y2 + 4, (int)(protection * (float)w2), h2, color);
                if (mouseX >= x2 && mouseY >= y2 + 2 && mouseX <= x2 + w && mouseY <= y2 + 12) {
                    this.hoveredDamageType = damageType;
                }
            }
            ++i;
        }
        if (this.hoveredDamageType != null) {
            int protection = java.lang.Math.round(this.mc.thePlayer.getTotalProtectionAmount(this.hoveredDamageType) * 100.0f);
            if (protection < 0) {
                protection = 0;
            }
            if (protection > 100) {
                protection = 100;
            }
            String str = I18n.getInstance().translateKey(this.hoveredDamageType.getLanguageKey()) + ":\n" + protection + " / 100";
            this.tooltipElement.render(str, mouseX, mouseY, 8, -8);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTick) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/inventory.png").bind();
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.WORLD);
        GLRenderer.getFogState().disable();
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.modelM4f().translate(x + 51, y + 75, 50.0f);
        float f1 = 30.0f;
        GLRenderer.modelM4f().scale(-f1, f1, f1);
        GLRenderer.modelM4f().rotateZ(Math.toRadians(180.0f));
        float yBodyRot = this.mc.thePlayer.yBodyRot;
        float yBodyRotO = this.mc.thePlayer.yBodyRotO;
        float yRot = this.mc.thePlayer.yRot;
        float yRotO = this.mc.thePlayer.yRotO;
        float xRot = this.mc.thePlayer.xRot;
        float xRotO = this.mc.thePlayer.xRotO;
        float eyesX = (float)(x + 51) - this.xSize_lo;
        float eyesY = (float)(y + 75 - 50) - this.ySize_lo;
        GLRenderer.modelM4f().rotateY(Math.toRadians(135.0f));
        Lighting.enableLight();
        GLRenderer.modelM4f().rotateY(Math.toRadians(-135.0f));
        GLRenderer.modelM4f().rotateX(Math.toRadians(-((float)java.lang.Math.atan(eyesY / 40.0f)) * 20.0f));
        this.mc.thePlayer.yBodyRotO = this.mc.thePlayer.yBodyRot = (float)java.lang.Math.atan(eyesX / 40.0f) * 20.0f;
        this.mc.thePlayer.yRotO = this.mc.thePlayer.yRot = (float)java.lang.Math.atan(eyesX / 40.0f) * 40.0f;
        this.mc.thePlayer.xRotO = this.mc.thePlayer.xRot = -((float)java.lang.Math.atan(eyesY / 40.0f)) * 20.0f;
        GLRenderer.modelM4f().translate(0.0f, this.mc.thePlayer.heightOffset, 0.0f);
        EntityRendererDispatcher.instance.viewLerpYaw = 180.0f;
        EntityRenderer.renderShadows = false;
        GLRenderer.globalGetNormalTransformMatrix().scale(1.0f, -1.0f, 1.0f);
        GLRenderer.setLightmapCoord2i(15, 15);
        EntityRendererDispatcher.instance.renderEntityPreviewWithPosYaw(GLRenderer.getTessellator(), this.mc.thePlayer, 0.0, 0.0, 0.0, 0.0f, partialTick);
        EntityRenderer.renderShadows = true;
        this.mc.thePlayer.yBodyRot = yBodyRot;
        this.mc.thePlayer.yBodyRotO = yBodyRotO;
        this.mc.thePlayer.yRot = yRot;
        this.mc.thePlayer.yRotO = yRotO;
        this.mc.thePlayer.xRot = xRot;
        this.mc.thePlayer.xRotO = xRotO;
        GLRenderer.popFrame();
        Lighting.disable();
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (button == this.armorButton) {
            this.mc.gameSettings.armorProtectionOverlay.toggle();
        }
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        super.guiSpecificControllerInput(controller);
        controller.inventoryHandler.handleInventory(this);
    }
}

