/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer;

import com.b100.utils.ImageUtils;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.modelviewer.categories.ModelViewerCategory;
import net.minecraft.client.gui.modelviewer.categories.ViewerCategoryBlock;
import net.minecraft.client.gui.modelviewer.categories.ViewerCategoryEntity;
import net.minecraft.client.gui.modelviewer.categories.ViewerCategoryParticle;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerSliderElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerTextFieldElement;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.shader.PhotoModeRenderer;
import net.minecraft.client.render.shader.ShadersRenderer;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.util.helper.Buffer;
import net.minecraft.client.util.helper.FileOpener;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.chunk.DisplayChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class ScreenModelViewer
extends ScreenPhotoMode
implements ListenerTextFieldElement.ITextChangeListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private ListenerButtonElement buttonRotateLeft;
    private ListenerButtonElement buttonRotateRight;
    private ListenerButtonElement buttonCenterScreen;
    private ListenerButtonElement buttonTakeScreenshot;
    private ListenerButtonElement buttonOpenScreenshotFolder;
    private ListenerButtonElement buttonExit;
    private ListenerSliderElement sliderTilt;
    private ListenerButtonElement buttonShaders;
    private ListenerSliderElement sliderIntensity;
    public ListenerButtonElement buttonPrevEntry;
    public ListenerButtonElement buttonNextEntry;
    private ListenerButtonElement buttonCategory;
    private ListenerButtonElement buttonReloadTextures;
    private ListenerButtonElement buttonTickToggle;
    private final ModelViewerCategory entityCategory = new ViewerCategoryEntity(this);
    private final ModelViewerCategory particleCategory = new ViewerCategoryParticle(this);
    private final ModelViewerCategory blockCategory = new ViewerCategoryBlock(this);
    private final List<ViewerCategoryBlock.BlockRenderInfo> blockCategoryBulkRenders = new ArrayList<ViewerCategoryBlock.BlockRenderInfo>();
    public final List<ModelViewerCategory> categories = new ArrayList<ModelViewerCategory>();
    private ModelViewerCategory currentCategory;
    protected final int defaultRed = 63;
    protected final int defaultGreen = 63;
    protected final int defaultBlue = 89;
    protected int bgRed;
    protected int bgGreen;
    protected int bgBlue;
    protected boolean tickProgress;
    protected boolean rotateToCamera;
    @Nullable
    private ModelViewerCategory.Info lastInfo;
    public long timeLastKeyPressed;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public ScreenModelViewer() {
        Objects.requireNonNull(this);
        this.bgRed = 63;
        Objects.requireNonNull(this);
        this.bgGreen = 63;
        this.bgBlue = this.defaultBlue;
        this.tickProgress = true;
        this.rotateToCamera = true;
        this.lastInfo = null;
        this.timeLastKeyPressed = System.currentTimeMillis();
        DisplayChunk.displayBlockId = 0;
        DisplayChunk.displayBlockMeta = 0;
        this.mc.currentWorld.entities.clear();
        this.mc.currentWorld.tileEntityList.clear();
        this.mc.thePlayer.absMoveTo(0.5, 64.5, 0.5, 180.0f, 0.0f);
        this.mc.thePlayer.noPhysics = true;
        this.mc.textureManager.refreshTexturesAndDisplayErrors();
        this.mc.textureManager.updateDynamicTextures(false);
        this.photoModeRenderer = new PhotoModeRenderer(this.mc, this);
        this.previousRenderer = this.mc.renderer;
        this.showPlayer = false;
        this.showHelpText = false;
        this.iZoomGoal = 8.5f;
        this.iZoom = 8.5f;
        this.lastIZoom = 8.5f;
        this.mc.ppm.reset();
        this.iRotation = -2.0f;
        this.iRotationGoal = -2.0f;
        this.categories.add(this.blockCategory);
        this.categories.add(this.entityCategory);
        this.categories.add(this.particleCategory);
        this.setCategory(this.entityCategory);
    }

    @Override
    public void init() {
        this.buttons.clear();
        I18n i18n = I18n.getInstance();
        ArrayList<ButtonElement> leftSideButtons = new ArrayList<ButtonElement>();
        this.buttonExit = new ListenerButtonElement(5, 0, this.height - 20, 20, 20, "X");
        this.buttonExit.setActionListener(this::exitToMenu);
        this.buttonRotateLeft = new ListenerButtonElement(0, this.width / 2 - 49 - 2 - 20, this.height - 20, 20, 20, "<");
        this.buttonRotateLeft.setActionListener(() -> {
            this.iRotationGoal += 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        });
        this.buttonRotateRight = new ListenerButtonElement(1, this.width / 2 + 49 + 2, this.height - 20, 20, 20, ">");
        this.buttonRotateRight.setActionListener(() -> {
            this.iRotationGoal -= 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        });
        this.buttonTakeScreenshot = new ListenerButtonElement(4, this.width / 2 - 49, this.height - 20, 98, 20, i18n.translateKey("gui.photo_mode.button.take_screenshot"));
        this.buttonTakeScreenshot.setActionListener(this::screenShot);
        ListenerButtonElement bulkRender = new ListenerButtonElement(4, this.width - 100, this.height - 20, 98, 20, i18n.translateKey("gui.model_viewer.button.bulk_render")).setActionListener(this::bulkRender);
        this.buttonPrevEntry = new ListenerButtonElement(10, this.width / 2 - 49 - 2 - 20, this.height - 40 - 2, 20, 20, "<");
        this.buttonPrevEntry.setActionListener(() -> this.currentCategory.cycleCategoryEntry(-1));
        this.buttonNextEntry = new ListenerButtonElement(11, this.width / 2 + 49 + 2, this.height - 40 - 2, 20, 20, ">");
        this.buttonNextEntry.setActionListener(() -> this.currentCategory.cycleCategoryEntry(1));
        this.buttonCategory = new ListenerButtonElement(12, this.width / 2 - 49, this.height - 40 - 2, 98, 20, i18n.translateKey(this.currentCategory.getCategoryNameKey()));
        this.buttonCategory.setActionListener(() -> this.setCategory(this.categories.get((this.categories.indexOf(this.currentCategory) + 1) % this.categories.size())));
        this.buttonCategory.setOnValueChanged(() -> {
            this.buttonCategory.displayString = i18n.translateKey(this.currentCategory.getCategoryNameKey());
        });
        this.buttonReloadTextures = new ListenerButtonElement(12, 21, this.height - 20, 98, 20, i18n.translateKey("gui.model_viewer.button.reload_textures"));
        this.buttonReloadTextures.setActionListener(() -> this.mc.texturePackList.refresh());
        this.buttonOpenScreenshotFolder = (ListenerButtonElement)new ListenerButtonElement(30, this.buttonReloadTextures.getWidth() + this.buttonReloadTextures.getX() + 1, this.buttonReloadTextures.getY(), 20, 20, "").setTextures("minecraft:gui/misc/button_folder", "minecraft:gui/misc/button_folder_highlighted", "minecraft:gui/misc/button_folder");
        this.buttonOpenScreenshotFolder.setActionListener(() -> FileOpener.open(new File(this.mc.getMinecraftDir(), "")));
        this.buttonCenterScreen = new ListenerButtonElement(10, 0, 0, 120, 20, i18n.translateKey("gui.photo_mode.button.center_camera"));
        this.buttonCenterScreen.setActionListener(() -> {
            this.iPanXGoal = 0.0f;
            this.iPanYGoal = 0.0f;
        });
        this.buttonTickToggle = new ListenerButtonElement(13, this.width - 120, 0, 99, 20, i18n.translateKeyAndFormat("gui.model_viewer.button.tickprogress", this.tickProgress));
        this.buttonTickToggle.setActionListener(() -> {
            this.tickProgress = !this.tickProgress;
        });
        this.buttonTickToggle.setOnValueChanged(() -> {
            this.buttonTickToggle.displayString = i18n.translateKeyAndFormat("gui.model_viewer.button.tickprogress", this.tickProgress);
        });
        ListenerButtonElement cameraRotateButton = new ListenerButtonElement(-1, this.width - 120, 0, 120, 20, i18n.translateKeyAndFormat("gui.model_viewer.button.rotate", this.rotateToCamera));
        cameraRotateButton.setActionListener(() -> {
            this.rotateToCamera = !this.rotateToCamera;
            cameraRotateButton.displayString = i18n.translateKeyAndFormat("gui.model_viewer.button.rotate", this.rotateToCamera);
        });
        ListenerButtonElement buttonManualTick = new ListenerButtonElement(14, this.width - 21, 0, 20, 20, "+");
        buttonManualTick.setActionListener(this::entryTick);
        this.sliderTilt = new ListenerSliderElement(7, 0, 0, 120, 20, i18n.translateKey("gui.photo_mode.button.tilt.default"), this.iTiltGoal / 90.0f);
        this.sliderTilt.setOnValueChanged(() -> {
            Object tilt = i18n.translateKey("gui.photo_mode.button.tilt.default");
            if ((int)(this.sliderTilt.sliderValue * 90.0) != 30) {
                tilt = (int)(this.sliderTilt.sliderValue * 90.0) + " degrees";
            }
            this.sliderTilt.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.tilt", tilt);
            if (this.sliderTilt.dragging) {
                this.iTiltGoal = (int)(this.sliderTilt.sliderValue * 90.0);
            }
        });
        this.buttonShaders = new ListenerButtonElement(8, 0, 0, 120, 20, i18n.translateKeyAndFormat("gui.photo_mode.button.shader", i18n.translateKey("gui.photo_mode.button.shader.none")));
        this.buttonShaders.setActionListener(() -> {
            boolean ctrl;
            boolean bl = ctrl = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
            if (ctrl) {
                this.photoModeRenderer.first();
            } else {
                this.photoModeRenderer.next();
            }
            this.sliderIntensity.enabled = this.photoModeRenderer.getActiveShader() != null;
        });
        this.buttonShaders.setOnValueChanged(() -> {
            String activeShader = this.photoModeRenderer.getActiveShader();
            if (activeShader == null) {
                activeShader = i18n.translateKey("gui.photo_mode.button.shader.none");
            }
            activeShader = activeShader.toUpperCase(Locale.ROOT);
            this.buttonShaders.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.shader", activeShader);
        });
        this.sliderIntensity = new ListenerSliderElement(9, 0, 0, 120, 20, i18n.translateKeyAndFormat("gui.photo_mode.button.intensity", (int)(this.intensityValue * 100.0f) + "%"), this.intensityValue);
        this.sliderIntensity.setOnValueChanged(() -> {
            this.sliderIntensity.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.intensity", (int)(this.sliderIntensity.sliderValue * 100.0) + "%");
            if (this.sliderIntensity.dragging) {
                this.intensityValue = (float)this.sliderIntensity.sliderValue;
            }
        });
        if (this.photoModeRenderer.getActiveShader() == null) {
            this.sliderIntensity.enabled = false;
        }
        this.mc.setRenderer(this.photoModeRenderer);
        this.buttons.add(cameraRotateButton);
        this.buttons.add(this.buttonTickToggle);
        int i = 0;
        ArrayList _buttons = new ArrayList(this.buttons);
        for (Object button : _buttons) {
            ((ButtonElement)button).yPosition = i++ * 21;
        }
        this.buttons.add(buttonManualTick);
        buttonManualTick.yPosition = this.buttonTickToggle.yPosition;
        this.currentCategory.addContextButtons(this.buttons);
        leftSideButtons.add(this.buttonCenterScreen);
        leftSideButtons.add(this.sliderTilt);
        leftSideButtons.add(this.buttonShaders);
        leftSideButtons.add(this.sliderIntensity);
        int j = 0;
        for (ButtonElement button : leftSideButtons) {
            button.yPosition = j++ * 21;
        }
        this.buttons.addAll(leftSideButtons);
        ListenerTextFieldElement rField = new ListenerTextFieldElement(this, this.fontRenderer, 0, j++ * 21, 40, 20, String.valueOf(this.bgRed), "Red");
        rField.setPrefaceText("R: ");
        rField.setKeyListener(key -> {
            try {
                this.bgRed = Integer.parseInt(rField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        rField.setActionListener(() -> {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL)) {
                Objects.requireNonNull(this);
                rField.setText(String.valueOf(63));
                Objects.requireNonNull(this);
                this.bgRed = 63;
            }
        });
        ListenerTextFieldElement gField = new ListenerTextFieldElement(this, this.fontRenderer, 40, rField.yPosition, 40, 20, String.valueOf(this.bgGreen), "Green");
        gField.setPrefaceText("G: ");
        gField.setKeyListener(key -> {
            try {
                this.bgGreen = Integer.parseInt(gField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        gField.setActionListener(() -> {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL)) {
                Objects.requireNonNull(this);
                gField.setText(String.valueOf(63));
                Objects.requireNonNull(this);
                this.bgGreen = 63;
            }
        });
        ListenerTextFieldElement bField = new ListenerTextFieldElement(this, this.fontRenderer, 80, rField.yPosition, 40, 20, String.valueOf(this.bgBlue), "Blue");
        bField.setPrefaceText("B: ");
        bField.setKeyListener(key -> {
            try {
                this.bgBlue = Integer.parseInt(bField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        bField.setActionListener(() -> {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL)) {
                bField.setText(String.valueOf(this.defaultBlue));
                this.bgBlue = this.defaultBlue;
            }
        });
        this.buttons.add(rField);
        this.buttons.add(gField);
        this.buttons.add(bField);
        this.buttons.add(this.buttonRotateLeft);
        this.buttons.add(this.buttonRotateRight);
        this.buttons.add(this.buttonTakeScreenshot);
        this.buttons.add(bulkRender);
        this.buttons.add(this.buttonOpenScreenshotFolder);
        this.buttons.add(this.buttonPrevEntry);
        this.buttons.add(this.buttonNextEntry);
        this.buttons.add(this.buttonCategory);
        this.buttons.add(this.buttonReloadTextures);
        this.buttons.add(this.buttonExit);
    }

    private void setCategory(ModelViewerCategory category) {
        if (this.currentCategory != null) {
            this.currentCategory.onClose();
        }
        this.currentCategory = category;
        if (this.currentCategory != null) {
            this.currentCategory.onOpen();
        }
        this.init();
    }

    public static int cycleItemId(int itemId, int offset) {
        int id = (itemId + Item.itemsList.length + offset) % Item.itemsList.length;
        while (Item.itemsList[id] == null) {
            id = (id + (int)Math.signum(offset) + Item.itemsList.length) % Item.itemsList.length;
        }
        return id;
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        if (this.lastInfo != null) {
            this.specificScreenshot(this.lastInfo.outputFile());
        }
        if (this.currentCategory == this.blockCategory && !this.blockCategoryBulkRenders.isEmpty()) {
            this.lastInfo = this.blockCategoryBulkRenders.remove(0);
            this.mc.currentWorld.entities.clear();
            this.mc.currentWorld.tileEntityList.clear();
            this.blockCategory.setupRender(this.lastInfo);
            this.iRotation = this.iRotationGoal = this.lastInfo.renderRotation();
            this.iZoom = this.iZoomGoal = this.lastInfo.renderZoom();
        } else {
            this.lastInfo = null;
        }
        GL41.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
        GLRenderer.projectionM4f().identity().ortho(0.0f, (float)this.mc.resolution.getExactScaledWidthScreenCoords(), (float)this.mc.resolution.getExactScaledHeightScreenCoords(), 0.0f, 1000.0f, 3000.0f);
        GLRenderer.viewM4f().identity();
        GLRenderer.modelM4f().identity();
        GL41.glClear(256);
        GLRenderer.modelM4f().translate(0.0f, 0.0f, -2000.0f);
        if (this.rotateToCamera) {
            this.mc.thePlayer.yRotO = this.mc.thePlayer.yRot = this.getRotation(partialTick) * 45.0f - 135.0f;
        } else {
            this.mc.thePlayer.yRot = 180.0f;
            this.mc.thePlayer.yRotO = 180.0f;
        }
        this.lastIZoom = this.iZoom;
        if (this.iZoom != this.iZoomGoal) {
            this.iZoom += (this.iZoomGoal - this.iZoom) * 0.08f;
            if (Math.abs(this.iZoom - this.iZoomGoal) < 5.0E-4f) {
                this.iZoom = this.iZoomGoal;
            }
        }
        this.lastIRotation = this.iRotation;
        if (this.iRotation != this.iRotationGoal) {
            this.iRotation += (this.iRotationGoal - this.iRotation) * 0.08f;
            if (Math.abs(this.iRotation - this.iRotationGoal) < 5.0E-4f) {
                this.iRotation = this.iRotationGoal;
            }
        }
        this.lastITilt = this.iTilt;
        if (this.iTilt != this.iTiltGoal) {
            this.iTilt += (this.iTiltGoal - this.iTilt) * 0.08f;
            if (Math.abs(this.iTilt - this.iTiltGoal) < 0.01f) {
                this.iTilt = this.iTiltGoal;
            }
        }
        this.lastIPanX = this.iPanX;
        if (this.iPanX != this.iPanXGoal) {
            this.iPanX += (this.iPanXGoal - this.iPanX) * 0.4f;
            if (Math.abs(this.iPanX - this.iPanXGoal) < 0.01f) {
                this.iPanX = this.iPanXGoal;
            }
        }
        this.lastIPanY = this.iPanY;
        if (this.iPanY != this.iPanYGoal) {
            this.iPanY += (this.iPanYGoal - this.iPanY) * 0.4f;
            if (Math.abs(this.iPanY - this.iPanYGoal) < 0.01f) {
                this.iPanY = this.iPanYGoal;
            }
        }
        this.buttonCenterScreen.enabled = !(this.iPanX == 0.0f && this.iPanY == 0.0f || this.iPanXGoal == 0.0f && this.iPanYGoal == 0.0f);
        ArrayList _buttons = new ArrayList(this.buttons);
        for (ButtonElement button : _buttons) {
            button.drawButton(this.mc, mx, my);
        }
        this.scroll(Mouse.getDWheel());
        this.drawStringCenteredShadow(this.fontRenderer, this.currentCategory.getCurrentDisplayInfo(I18n.getInstance()), this.width / 2, 1, 0xFFFFFF);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.exitToMenu();
        }
        ArrayList _buttons = new ArrayList(this.buttons);
        for (ButtonElement button : _buttons) {
            if (!(button instanceof IListenerElement)) continue;
            IListenerElement element = (IListenerElement)((Object)button);
            if (!button.isHovered(mx, my)) continue;
            element.onKeyTyped(eventCharacter, eventKey);
        }
    }

    private void exitToMenu() {
        this.currentCategory.onClose();
        this.mc.changeWorld(null);
        this.mc.displayScreen(new ScreenOptions(null, OptionsPages.DEBUG));
    }

    public static int cycleBlockId(int id, int idOff) {
        int id2 = (id + Blocks.blocksList.length + idOff) % Blocks.blocksList.length;
        while (Blocks.blocksList[id2] == null) {
            id2 = (id2 + (int)Math.signum(idOff) + Blocks.blocksList.length) % Blocks.blocksList.length;
        }
        return id2;
    }

    @Override
    public void removed() {
        this.mc.setRenderer(this.previousRenderer);
        Minecraft.doPartialTick = true;
    }

    @Override
    public void tick() {
        super.tick();
        ArrayList _buttons = new ArrayList(this.buttons);
        for (ButtonElement button : _buttons) {
            if (!(button instanceof ListenerButtonElement)) continue;
            ListenerButtonElement element = (ListenerButtonElement)button;
            element.tick();
        }
        if (this.tickProgress) {
            this.entryTick();
        }
        Minecraft.doPartialTick = this.tickProgress;
    }

    private void entryTick() {
        this.mc.textureManager.updateDynamicTextures(false);
        this.mc.particleEngine.tick();
        this.currentCategory.onTick();
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
    }

    @Override
    public void textChanged(ListenerTextFieldElement textField) {
        this.timeLastKeyPressed = System.currentTimeMillis();
    }

    public float[] getBackgroundFogColor() {
        return new float[]{(float)this.bgRed / 255.0f, (float)this.bgGreen / 255.0f, (float)this.bgBlue / 255.0f};
    }

    public void screenShot() {
        try {
            File screenshotsDir = new File(this.mc.getMinecraftDir(), "screenshots");
            screenshotsDir.mkdir();
            Texture texture = ((ShadersRenderer)this.mc.renderer).getWorldFramebufferColor();
            texture.bind();
            int w = GL41.glGetTexLevelParameteri(3553, 0, 4096);
            int h = GL41.glGetTexLevelParameteri(3553, 0, 4097);
            int size = w * h * 4;
            Buffer.checkBufferSize(size);
            ByteBuffer buffer = Buffer.buffer;
            buffer.position(0).limit(size);
            GL41.glGetTexImage(3553, 0, 6408, 5121, buffer);
            if (GL41.glGetError() == 0) {
                File outPut;
                buffer.position(0);
                String timeStamp = "Render_" + dateFormat.format(new Date());
                int id = 1;
                while ((outPut = new File(screenshotsDir, timeStamp + (String)(id != 1 ? "_" + id : "") + ".png")).exists()) {
                    ++id;
                }
                ImageUtils.saveExternalImage(Textures.getImage(buffer, w, h, true, true), outPut);
            } else {
                LOGGER.warn("Cannot get pixel data for screenshot!");
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while trying to take Model Viewer ScreenShot", e);
        }
    }

    public void specificScreenshot(@NotNull File destination) {
        try {
            Texture texture = ((ShadersRenderer)this.mc.renderer).getWorldFramebufferColor();
            texture.bind();
            int w = GL41.glGetTexLevelParameteri(3553, 0, 4096);
            int h = GL41.glGetTexLevelParameteri(3553, 0, 4097);
            int size = w * h * 4;
            Buffer.checkBufferSize(size);
            ByteBuffer buffer = Buffer.buffer;
            buffer.position(0).limit(size);
            GL41.glGetTexImage(3553, 0, 6408, 5121, buffer);
            if (GL41.glGetError() == 0) {
                buffer.position(0);
                ImageUtils.saveExternalImage(Textures.getImage(buffer, w, h, true, true), destination);
            } else {
                LOGGER.warn("Cannot get pixel data for screenshot!");
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while trying to take Model Viewer ScreenShot", e);
        }
    }

    public void bulkRender() {
        this.iRotationGoal = 0.0f;
        this.iRotation = 0.0f;
        this.lastIPanX = 0.0f;
        this.iPanXGoal = 0.0f;
        this.iPanX = 0.0f;
        this.lastIPanY = -0.4574755f;
        this.iPanYGoal = -0.4574755f;
        this.iPanY = -0.4574755f;
        this.iZoomGoal = 8.5f;
        this.iZoom = 8.5f;
        this.mc.gameWindow.setWindowSize(1024, 1024);
        File bulkOutputDir = new File(this.mc.getMinecraftDir(), "bulkRenders");
        bulkOutputDir.mkdirs();
        this.setCategory(this.blockCategory);
        this.blockCategory.queueBulkRender(bulkOutputDir, this.blockCategoryBulkRenders);
    }
}

