/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerController {
    @NotNull
    protected final Minecraft mc;
    protected float destroyProgress;
    protected float oDestroyProgress;
    protected int soundDelay;
    protected int swingCooldown = 0;
    protected int destroyDelay;
    @Nullable
    protected TilePosc mining;

    public PlayerController(@NotNull Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void startDestroyBlock(@NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit, boolean repeat) {
        @NotNull World world = Objects.requireNonNull(this.mc.currentWorld);
        @NotNull Player player = Objects.requireNonNull(this.mc.thePlayer);
        if (player.getHeldObject() != null || !player.getGamemode().canInteract()) {
            return;
        }
        if (!player.getGamemode().hasBlockBreakingAnimation()) {
            this.swingItem(true);
            @Nullable ItemStack heldItem = player.getCurrentEquippedItem();
            if (heldItem != null && heldItem.getItem().hasTag(ItemTags.PREVENT_CREATIVE_MINING)) {
                return;
            }
            this.destroyBlock(tilePos, side);
            this.sendStartDigPacket(tilePos, side, xHit, yHit);
            return;
        }
        @NotNull Block<?> mineBlock = world.getBlockType(tilePos);
        float mineStrength = mineBlock.getStrength(world, tilePos, side, player);
        if (mineStrength < 1.0f && !repeat) {
            this.sendStartDigPacket(tilePos, side, xHit, yHit);
            this.hitBlock(tilePos, side, xHit, yHit);
            this.setMineBlock(tilePos);
        }
    }

    public void continueDestroyBlock(@NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        @NotNull World world = Objects.requireNonNull(this.mc.currentWorld);
        @NotNull Player player = Objects.requireNonNull(this.mc.thePlayer);
        if (!player.getGamemode().hasBlockBreakingAnimation() || !player.getGamemode().canInteract() || player.getHeldObject() != null) {
            return;
        }
        this.swingItem(false);
        if (this.destroyDelay > 0) {
            --this.destroyDelay;
            return;
        }
        Block<?> mineBlock = world.getBlockType(tilePos);
        this.syncCurrentPlayItem();
        float mineStrength = mineBlock.getStrength(world, tilePos, side, player);
        if (mineStrength >= 1.0f) {
            this.setMineBlock(tilePos);
            this.destroyBlock(tilePos, side);
            this.sendStartDigPacket(tilePos, side, xHit, yHit);
            this.destroyProgress = 0.0f;
            this.oDestroyProgress = 0.0f;
            this.soundDelay = 0;
            this.destroyDelay = 1;
        } else {
            if (!this.isMiningBlock(tilePos)) {
                this.sendStartDigPacket(tilePos, side, xHit, yHit);
                if (world.getBlockLogic(tilePos, BlockLogicDoor.class) == null) {
                    this.hitBlock(tilePos, side, xHit, yHit);
                }
                this.destroyProgress = 0.0f;
                this.oDestroyProgress = 0.0f;
                this.setMineBlock(tilePos);
            }
            Objects.requireNonNull(this.mc.particleEngine).crack(tilePos.x(), tilePos.y(), tilePos.z(), side);
            this.playDigSound(mineBlock, tilePos);
            this.destroyProgress += mineStrength;
            if (this.destroyProgress > 1.0f) {
                this.destroyBlock(tilePos, side);
                this.sendDestroyBlockPacket(tilePos, side, xHit, yHit);
                this.setMineBlock(null);
                this.destroyProgress = 0.0f;
                this.oDestroyProgress = 0.0f;
                this.soundDelay = 0;
                int newDestroyDelay = mineStrength > 0.5f ? 2 : (mineStrength > 0.4f ? 3 : (mineStrength > 0.3f ? 4 : 5));
                this.destroyDelay = newDestroyDelay;
            }
        }
    }

    public boolean swingItem(boolean force) {
        @NotNull Player player = Objects.requireNonNull(this.mc.thePlayer);
        if (this.swingCooldown == 0 || force) {
            player.swingItem();
            this.swingCooldown = 5;
            return true;
        }
        return false;
    }

    public boolean destroyBlock(@NotNull TilePosc tilePos, @NotNull Side side) {
        @NotNull World world = Objects.requireNonNull(this.mc.currentWorld);
        @NotNull Player player = Objects.requireNonNull(this.mc.thePlayer);
        if (!player.getGamemode().canInteract() || player.getHeldObject() != null) {
            return false;
        }
        @NotNull Block<?> block = world.getBlockType(tilePos);
        int data = world.getBlockData(tilePos);
        this.setMineBlock(null);
        Item heldItem = null;
        @Nullable ItemStack heldItemStack = player.getCurrentEquippedItem();
        if (heldItemStack != null) {
            if (!heldItemStack.beforeBlockDestroyed(world, player, block, tilePos, side)) {
                return false;
            }
            heldItem = heldItemStack.getItem();
        }
        world.playBlockEvent(tilePos, 2001, block.id());
        if (world.setBlockTypeNotify(tilePos, Blocks.AIR)) {
            block.onDestroyedByPlayer(world, tilePos, side, data, player, heldItem);
            return true;
        }
        return false;
    }

    public void stopDestroyBlock() {
        this.destroyProgress = 0.0f;
        this.oDestroyProgress = 0.0f;
        this.soundDelay = 0;
        if (this.destroyDelay > 0) {
            --this.destroyDelay;
        }
    }

    protected void hitBlock(@NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        @NotNull World world = Objects.requireNonNull(this.mc.currentWorld);
        @NotNull Player player = Objects.requireNonNull(this.mc.thePlayer);
        if (!player.getGamemode().canInteract() || player.getHeldObject() != null) {
            return;
        }
        world.onBlockHit(player, tilePos, side);
        @NotNull Block<?> block = world.getBlockType(tilePos);
        block.onAttacked(world, tilePos, player, side, xHit, yHit);
    }

    private boolean isMiningBlock(@NotNull TilePosc tilePos) {
        return tilePos.equals(this.mining);
    }

    private void setMineBlock(@Nullable TilePosc tilePos) {
        this.mining = tilePos;
    }

    public void render(float partialTick) {
        @NotNull HudIngame hud = Objects.requireNonNull(this.mc.hudIngame);
        @NotNull RenderGlobal renderGlobal = Objects.requireNonNull(this.mc.renderGlobal);
        if (this.destroyProgress <= 0.0f) {
            hud.destroyProgress = 0.0f;
            renderGlobal.destroyProgress = 0.0f;
        } else {
            float lDestroyProgress;
            hud.destroyProgress = lDestroyProgress = this.oDestroyProgress + (this.destroyProgress - this.oDestroyProgress) * partialTick;
            renderGlobal.destroyProgress = lDestroyProgress;
        }
        this.mc.ppm.render(partialTick);
    }

    public void tick() {
        if (this.swingCooldown > 0) {
            --this.swingCooldown;
        }
        this.syncCurrentPlayItem();
        this.oDestroyProgress = this.destroyProgress;
        this.mc.sndManager.tick();
        this.mc.ppm.tick();
    }

    public boolean useOrPlaceItemStackOnTile(@NotNull Player player, @NotNull World world, @Nullable ItemStack itemStack, @NotNull TilePosc tilePos, @NotNull Side side, double xPlaced, double yPlaced) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        @NotNull Block<?> block = world.getBlockType(tilePos);
        if (player.getHeldObject() == null) {
            TileEntity tileEntity;
            if (player.isSneaking() && itemStack == null && (tileEntity = world.getTileEntity(tilePos)) != null && tileEntity.canBeCarried(world, player)) {
                player.setHeldObject(tileEntity.pickup(world, player));
                return true;
            }
            if ((!player.isSneaking() || itemStack == null) && block.onInteracted(world, tilePos, player, side, xPlaced, yPlaced)) {
                return true;
            }
            if (itemStack == null) {
                return false;
            }
            return itemStack.useItemOnBlock(player, world, tilePos, side, xPlaced, yPlaced);
        }
        if (!player.isSneaking() && block.onInteracted(world, tilePos, player, side, xPlaced, yPlaced)) {
            return true;
        }
        if (player.getHeldObject().tryPlace(world, player, tilePos.x(), tilePos.y(), tilePos.z(), side, xPlaced, yPlaced)) {
            player.setHeldObject(null);
            return true;
        }
        return false;
    }

    public boolean useItemStackOnNothing(@NotNull Player player, @NotNull World world, @NotNull ItemStack stack) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        int prevStackSize = stack.stackSize;
        @Nullable ItemStack newItemStack = stack.useItem(world, player);
        if (newItemStack != stack || newItemStack.stackSize != prevStackSize) {
            player.inventory.setCurrentItem(newItemStack);
            if (newItemStack == null || newItemStack.stackSize <= 0) {
                player.inventory.setCurrentItem(null);
            }
            return true;
        }
        return false;
    }

    public boolean placeItemStackOnTile(@NotNull Player player, @NotNull World world, @Nullable ItemStack itemStack, @NotNull TilePosc tilePos, @NotNull Side side, double xPlaced, double yPlaced) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        if (player.getHeldObject() == null) {
            if (itemStack == null) {
                return false;
            }
            return itemStack.useItemOnBlock(player, world, tilePos, side, xPlaced, yPlaced);
        }
        return false;
    }

    @NotNull
    public Player createPlayer(@NotNull World world) {
        return new PlayerLocal(this.mc, world, Objects.requireNonNull(this.mc.session), Objects.requireNonNull(world.dimension).id);
    }

    public boolean interact(@NotNull Player player, @NotNull Entity entity) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        return player.useCurrentItemOnEntity(entity);
    }

    public void attack(@NotNull Player player, @NotNull Entity entity) {
        if (!player.getGamemode().canInteract()) {
            return;
        }
        player.attackTargetEntityWithCurrentItem(entity);
    }

    @Nullable
    public ItemStack handleInventoryMouseClick(int windowId, @NotNull InventoryAction action, int @Nullable [] args2, @NotNull Player player) {
        return player.containerMenu.clicked(action, args2, player);
    }

    public void handleCloseInventory(int windowId, @NotNull Player player) {
        player.containerMenu.onCraftGuiClosed(player);
        player.containerMenu = player.inventoryMenu;
    }

    public void playDigSound(@NotNull Block<?> block, @NotNull TilePosc tilePos) {
        if (this.soundDelay <= 0) {
            Objects.requireNonNull(this.mc.currentWorld).playBlockSoundEffect(null, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f, block, EnumBlockSoundEffectType.DIG);
            this.soundDelay = 3;
        } else {
            --this.soundDelay;
        }
    }

    protected void syncCurrentPlayItem() {
    }

    public void sendStartDigPacket(@NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
    }

    public void sendDestroyBlockPacket(@NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
    }

    public void setPaintingType(@NotNull ArtType art) {
        Objects.requireNonNull(this.mc.thePlayer).setSelectedArt(art);
    }
}

