/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.meta.AnimationProperties;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texturepack.TexturePackException;
import org.slf4j.Logger;

public class DynamicTextureCustom
extends DynamicTexture {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Random rand = new Random();
    private final int frameCount;
    private final byte[] frameData;
    private final AnimationProperties properties;
    private int currentIndex = 0;
    private final int indices;
    private int currentFrame = -1;
    private int previousFrame = -1;
    private int delayUntilNextFrame = 0;
    private int frameLength = 0;
    private final boolean tickWhenPaused;

    public DynamicTextureCustom(IconCoordinate texture, AnimationProperties animationProperties) {
        super(texture);
        this.properties = animationProperties;
        try {
            if (texture.height < texture.width) {
                throw new TexturePackException("Height is smaller than width!");
            }
        }
        catch (TexturePackException e) {
            throw new TexturePackException("Error in animation " + String.valueOf(texture.namespaceId), e);
        }
        int width = texture.width;
        int height = texture.height;
        int tileWidth = width;
        int tileHeight = animationProperties.height * width / animationProperties.width;
        texture.setDimension(tileWidth, tileHeight);
        this.frameCount = height / tileHeight;
        if (animationProperties.frames != null) {
            this.indices = animationProperties.frames.size();
            for (AnimationProperties.Frame f : animationProperties.frames) {
                if (f.index < this.frameCount) continue;
                throw new TexturePackException("Animation in '" + String.valueOf(texture.namespaceId) + "' illegally attempts to reference index '" + f.index + "' when theres only '" + this.frameCount + "' possible frames!");
            }
        } else {
            this.indices = this.frameCount;
        }
        BufferedImage image = texture.parentAtlas.getImage("color", texture);
        this.frameData = new byte[tileWidth * tileHeight * 4 * this.frameCount];
        for (int frame = 0; frame < this.frameCount; ++frame) {
            for (int x = 0; x < tileWidth; ++x) {
                for (int y = 0; y < tileHeight; ++y) {
                    int c = image.getRGB(x, frame * tileHeight + y);
                    int i = frame * tileWidth * tileHeight + y * tileWidth + x;
                    DynamicTextureCustom.putPixel(this.frameData, i, c);
                }
            }
        }
        this.tickWhenPaused = texture.parentAtlas.tickWhenPaused();
    }

    @Override
    public void postInit() {
        this.initTexture();
    }

    @Override
    public void update() {
        if (this.properties.interpolate) {
            if (this.delayUntilNextFrame > 0) {
                --this.delayUntilNextFrame;
            }
            if (this.delayUntilNextFrame <= 0) {
                this.progressFrame();
            }
            float blendFactor = 1.0f - (float)this.delayUntilNextFrame / (float)this.frameLength;
            if (this.previousFrame == -1) {
                this.transferFrame(this.currentFrame);
            } else {
                this.transferBlendedFrame(this.previousFrame, this.currentFrame, blendFactor);
            }
            return;
        }
        if (this.delayUntilNextFrame > 0) {
            --this.delayUntilNextFrame;
            if (this.delayUntilNextFrame > 0) {
                return;
            }
        }
        this.progressFrame();
        if (this.currentFrame != this.previousFrame) {
            this.transferFrame(this.currentFrame);
        }
    }

    private void progressFrame() {
        this.frameLength = this.delayUntilNextFrame = this.getNextFrameDelay();
        this.currentIndex = this.properties.random ? rand.nextInt(this.indices) : (this.currentIndex + 1) % this.indices;
        this.previousFrame = this.currentFrame;
        this.currentFrame = this.getNextFrame();
    }

    private int getNextFrame() {
        return this.properties.frames == null ? this.currentIndex : this.properties.frames.get((int)this.currentIndex).index;
    }

    private int getNextFrameDelay() {
        if (this.properties.frames == null) {
            return this.properties.frametime;
        }
        return this.properties.frames.get((int)this.currentIndex).time;
    }

    private void transferFrame(int frame) {
        try {
            for (int x0 = 0; x0 < this.targetTexture.width; ++x0) {
                for (int y0 = 0; y0 < this.targetTexture.height; ++y0) {
                    int i = frame * this.targetTexture.getArea() + y0 * this.targetTexture.width + x0 << 2;
                    int j = y0 * this.targetTexture.width + x0 << 2;
                    this.imageData[j] = this.frameData[i];
                    this.imageData[j + 1] = this.frameData[i + 1];
                    this.imageData[j + 2] = this.frameData[i + 2];
                    this.imageData[j + 3] = this.frameData[i + 3];
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while transferring frame '{}'!", (Object)frame, (Object)e);
        }
    }

    private void transferBlendedFrame(int frame1, int frame2, float blendFactor) {
        if (blendFactor <= 0.0f) {
            this.transferFrame(frame1);
        } else if (blendFactor >= 1.0f) {
            this.transferFrame(frame2);
        } else {
            for (int x0 = 0; x0 < this.targetTexture.width; ++x0) {
                for (int y0 = 0; y0 < this.targetTexture.height; ++y0) {
                    int i = frame1 * this.targetTexture.getArea() + y0 * this.targetTexture.width + x0 << 2;
                    int j = frame2 * this.targetTexture.getArea() + y0 * this.targetTexture.width + x0 << 2;
                    int k = y0 * this.targetTexture.width + x0 << 2;
                    this.imageData[k] = this.blend(this.frameData[i], this.frameData[j], blendFactor);
                    this.imageData[k + 1] = this.blend(this.frameData[i + 1], this.frameData[j + 1], blendFactor);
                    this.imageData[k + 2] = this.blend(this.frameData[i + 2], this.frameData[j + 2], blendFactor);
                    this.imageData[k + 3] = this.blend(this.frameData[i + 3], this.frameData[j + 3], blendFactor);
                }
            }
        }
    }

    private byte blend(int a, int b, float factor) {
        int c = (int)((float)(a & 0xFF) * (1.0f - factor) + (float)(b & 0xFF) * factor);
        return (byte)c;
    }

    @Override
    public boolean runUpdates(boolean isPaused) {
        return (Integer)this.mc.gameSettings.animations.value != 0 && (!isPaused || this.tickWhenPaused);
    }
}

