/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.renderer;

import com.mojang.logging.LogUtils;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.render.FogManager;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.CullFace;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.FrontFace;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.uniform.UniformBlockManager;
import net.minecraft.core.util.helper.Color;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector4dc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class GLRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean DEBUG = false;
    public static final int RENDER_FRAMES_STACK_SIZE = 64;
    @NotNull
    private static final GLRenderer instance = new GLRenderer();
    private static boolean LIGHT_ENABLED = false;
    @NotNull
    private static final Vector4f LIGHT_MODEL_AMBIENT = new Vector4f(0.2f, 0.2f, 0.2f, 1.0f);
    @NotNull
    private static final Lighting.LightSource LIGHT_0 = new Lighting.LightSource();
    @NotNull
    private static final Lighting.LightSource LIGHT_1 = new Lighting.LightSource();
    @NotNull
    private static final Matrix4f NORMAL_TRANSFORM_MATRIX;
    private static final StackWalker STACK_WALKER;
    private final StackTraceElement[] pushListenStack = new StackTraceElement[64];
    private final StackTraceElement[] popListenStack = new StackTraceElement[64];
    private boolean viewProjMatDirty = true;
    @NotNull
    private final Matrix4fStack projectionMatrixStack = new Matrix4fStack(64);
    @NotNull
    private final Matrix4fStack viewMatrixStack = new Matrix4fStack(64);
    @NotNull
    private final Matrix4fStack modelMatrixStack = new Matrix4fStack(64);
    @NotNull
    private final Matrix4fStack textureMatrixStack = new Matrix4fStack(64);
    private final long[] stateConfigStack = new long[64];
    private long currentStateConfig;
    private final int[] colorStack;
    private int currentColor;
    private final Shader[] shaderStack;
    @NotNull
    private Shader currentShader;
    private final FogManager.FogState[] fogStateStack;
    @NotNull
    private FogManager.FogState currentFogState;
    private boolean fogStateDirty;
    private final CompareFunc[] depthFuncStack;
    @NotNull
    private CompareFunc currentDepthFunc;
    private final CullFace[] cullFaceStack;
    @NotNull
    private CullFace currentCullFace;
    private final BlendFactor[] sFactorStack;
    private final BlendFactor[] dFactorStack;
    @NotNull
    private BlendFactor currentSFactor;
    @NotNull
    private BlendFactor currentDFactor;
    private final FrontFace[] frontFaceStack;
    @NotNull
    private FrontFace currentFrontFace;
    private final byte[] colorMaskStack;
    private byte currentColorMask;
    private final boolean[] depthMaskStack;
    private boolean currentDepthMask;
    private final float[] lineWidthStack;
    private float currentLineWidth;
    private final float[] polygonFactorStack;
    private final float[] polygonUnitsStack;
    private float currentPolygonFactor;
    private float currentPolygonUnits;
    private final float[] lightmapBlockStack;
    private final float[] lightmapSkyStack;
    private float currentLightmapBlock;
    private float currentLightmapSky;
    private final float[] alphaTestStack;
    private float currentAlphaTest;
    private int stackIndex;
    @NotNull
    private final Minecraft mc;
    private final FloatBuffer mat4fBuf;
    @NotNull
    private final TessellatorShader tessellatorShader;
    private static final FloatBuffer lightBuf;
    private static final Matrix4f matBuf;

    public static void globalSetLightEnabled(boolean flag) {
        LIGHT_ENABLED = flag;
    }

    @NotNull
    public static Vector4f globalGetLightModelAmbient() {
        return LIGHT_MODEL_AMBIENT;
    }

    @NotNull
    public static Lighting.LightSource globalGetLight0() {
        return LIGHT_0;
    }

    @NotNull
    public static Lighting.LightSource globalGetLight1() {
        return LIGHT_1;
    }

    @NotNull
    public static Matrix4f globalGetNormalTransformMatrix() {
        return NORMAL_TRANSFORM_MATRIX;
    }

    public GLRenderer() {
        this.currentStateConfig = State.DITHER.bitMask | State.MULTISAMPLE.bitMask;
        this.colorStack = new int[64];
        this.currentColor = Color.intToIntARGB(255, 255, 255, 255);
        this.shaderStack = new Shader[64];
        this.currentShader = Shaders.INTERFACE;
        this.fogStateStack = new FogManager.FogState[64];
        this.currentFogState = new FogManager.FogState().disable();
        this.fogStateDirty = true;
        this.depthFuncStack = new CompareFunc[64];
        this.currentDepthFunc = CompareFunc.LESS;
        this.cullFaceStack = new CullFace[64];
        this.currentCullFace = CullFace.BACK;
        this.sFactorStack = new BlendFactor[64];
        this.dFactorStack = new BlendFactor[64];
        this.currentSFactor = BlendFactor.ONE;
        this.currentDFactor = BlendFactor.ZERO;
        this.frontFaceStack = new FrontFace[64];
        this.currentFrontFace = FrontFace.CCW;
        this.colorMaskStack = new byte[64];
        this.currentColorMask = (byte)15;
        this.depthMaskStack = new boolean[64];
        this.currentDepthMask = true;
        this.lineWidthStack = new float[64];
        this.currentLineWidth = 1.0f;
        this.polygonFactorStack = new float[64];
        this.polygonUnitsStack = new float[64];
        this.currentPolygonFactor = 0.0f;
        this.currentPolygonUnits = 0.0f;
        this.lightmapBlockStack = new float[64];
        this.lightmapSkyStack = new float[64];
        this.currentLightmapBlock = 0.96875f;
        this.currentLightmapSky = 0.96875f;
        this.alphaTestStack = new float[64];
        this.currentAlphaTest = 0.1f;
        this.stackIndex = 0;
        this.mc = Minecraft.getMinecraft();
        this.mat4fBuf = BufferUtils.createFloatBuffer(16);
        this.tessellatorShader = new TessellatorShader("GLRender Tessellator", 0x200000);
    }

    public static void init() {
    }

    public static void globalSetUniforms(@NotNull Shader shader) {
        shader.bind();
        if (GLRenderer.instance.viewProjMatDirty) {
            GL41.glBindBuffer(35345, UniformBlockManager.BLOCK_MATRICES.ubo);
            UniformBlockManager.BLOCK_MATRICES.adapter.bufferData(GLRenderer.projectionM4f(), 0, UniformBlockManager.BLOCK_MATRICES.buffer);
            UniformBlockManager.BLOCK_MATRICES.adapter.bufferData(GLRenderer.projectionM4f().invert(matBuf), 64, UniformBlockManager.BLOCK_MATRICES.buffer);
            UniformBlockManager.BLOCK_MATRICES.adapter.bufferData(GLRenderer.viewM4f(), 128, UniformBlockManager.BLOCK_MATRICES.buffer);
            UniformBlockManager.BLOCK_MATRICES.adapter.bufferData(GLRenderer.viewM4f().invert(matBuf), 192, UniformBlockManager.BLOCK_MATRICES.buffer);
            GL41.glBufferSubData(35345, 0L, UniformBlockManager.BLOCK_MATRICES.buffer);
            GL41.glBindBuffer(35345, 0);
            GLRenderer.instance.viewProjMatDirty = false;
        }
        shader.uniformMat4f("model", GLRenderer.modelM4f());
        shader.uniformMat4f("texture", GLRenderer.textureM4f());
        shader.uniformFloat("uAlphaTest", GLRenderer.instance.currentAlphaTest);
        shader.uniformVec4f("uColor", (float)Color.redFromInt(GLRenderer.instance.currentColor) / 255.0f, (float)Color.greenFromInt(GLRenderer.instance.currentColor) / 255.0f, (float)Color.blueFromInt(GLRenderer.instance.currentColor) / 255.0f, (float)Color.alphaFromInt(GLRenderer.instance.currentColor) / 255.0f);
        shader.uniformFloat("uCurrentTick", (float)GLRenderer.instance.mc.ticksRan + GLRenderer.instance.mc.timer.partialTicks);
        shader.uniformFloat("uPartialTick", GLRenderer.instance.mc.timer.partialTicks);
        shader.uniformFloat("uLineWidth", GLRenderer.instance.currentLineWidth);
        double renderScale = (float)((RenderScale)((Object)GLRenderer.instance.mc.gameSettings.renderScale.value)).scale;
        int scaledWidth = (int)(renderScale * (double)GLRenderer.instance.mc.gameWindow.getWidthPixels());
        int scaledHeight = (int)(renderScale * (double)GLRenderer.instance.mc.gameWindow.getHeightPixels());
        shader.uniformVec2f("uViewPortSize", scaledWidth, scaledHeight);
        if (GLRenderer.instance.fogStateDirty) {
            GL41.glBindBuffer(35345, UniformBlockManager.BLOCK_FOG_STATE.ubo);
            GL41.glBufferSubData(35345, 0L, UniformBlockManager.BLOCK_FOG_STATE.adapter.bufferData(GLRenderer.instance.currentFogState, 0, UniformBlockManager.BLOCK_FOG_STATE.buffer.clear()));
            GL41.glBindBuffer(35345, 0);
            GLRenderer.instance.fogStateDirty = false;
        }
        shader.uniformMat4f("normalTransform", NORMAL_TRANSFORM_MATRIX);
        if (LIGHT_ENABLED) {
            shader.uniformVec4f("lightModelAmbient", LIGHT_MODEL_AMBIENT);
            shader.uniformVec4f("lightSourcePosition1", GLRenderer.LIGHT_0.position);
            shader.uniformVec4f("lightSourcePosition2", GLRenderer.LIGHT_1.position);
            shader.uniformVec4f("lightSourceDiffuse1", GLRenderer.LIGHT_0.diffuse);
            shader.uniformVec4f("lightSourceDiffuse2", GLRenderer.LIGHT_1.diffuse);
        } else {
            shader.uniformVec4f("lightModelAmbient", 1.0f, 1.0f, 1.0f, 1.0f);
            shader.uniformVec4f("lightSourcePosition1", GLRenderer.LIGHT_0.position);
            shader.uniformVec4f("lightSourcePosition2", GLRenderer.LIGHT_1.position);
            shader.uniformVec4f("lightSourceDiffuse1", 0.0f, 0.0f, 0.0f, 0.0f);
            shader.uniformVec4f("lightSourceDiffuse2", 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public static void render(@NotNull RenderBuffer renderBuffer) {
        GLRenderer.render(renderBuffer.vao(), renderBuffer.vbo(), renderBuffer.offset(), renderBuffer.count(), renderBuffer.drawMode());
    }

    public static void render(int vao, int vbo, int offset, int count, @NotNull DrawMode drawMode) {
        GL41.glBindVertexArray(vao);
        GL41.glBindBuffer(34962, vbo);
        GLRenderer.instance.currentShader.bind();
        GLRenderer.globalSetUniforms(GLRenderer.instance.currentShader);
        GL41.glDrawArrays(drawMode.cap, offset, count);
        GL41.glUseProgram(0);
        GL41.glBindVertexArray(0);
    }

    public static void enableState(@NotNull State state) {
        GLRenderer.instance.currentStateConfig |= state.bitMask;
        GL41.glEnable(state.cap);
    }

    public static void disableState(@NotNull State state) {
        GLRenderer.instance.currentStateConfig &= state.bitMask ^ 0xFFFFFFFFFFFFFFFFL;
        GL41.glDisable(state.cap);
    }

    public static boolean isStateEnabled(@NotNull State state) {
        return state.isEnabled(GLRenderer.instance.currentStateConfig);
    }

    @NotNull
    public static Matrix4f projectionM4f() {
        GLRenderer.instance.viewProjMatDirty = true;
        return GLRenderer.instance.projectionMatrixStack;
    }

    @NotNull
    public static Matrix4f viewM4f() {
        GLRenderer.instance.viewProjMatDirty = true;
        return GLRenderer.instance.viewMatrixStack;
    }

    @NotNull
    public static Matrix4f modelM4f() {
        return GLRenderer.instance.modelMatrixStack;
    }

    @NotNull
    public static Matrix4f textureM4f() {
        return GLRenderer.instance.textureMatrixStack;
    }

    public static void setShader(@NotNull Shader shader) {
        GLRenderer.instance.currentShader = shader;
    }

    @NotNull
    public static Shader getShader() {
        return GLRenderer.instance.currentShader;
    }

    @NotNull
    public static FogManager.FogState getFogState() {
        GLRenderer.instance.fogStateDirty = true;
        return GLRenderer.instance.currentFogState;
    }

    public static void setDepthFunc(@NotNull CompareFunc func) {
        GLRenderer.instance.currentDepthFunc = func;
        GL41.glDepthFunc(func.cap);
    }

    @NotNull
    public static CompareFunc getDepthFunc() {
        return GLRenderer.instance.currentDepthFunc;
    }

    public static void setCullFace(@NotNull CullFace cullFace) {
        GLRenderer.instance.currentCullFace = cullFace;
        GL41.glCullFace(cullFace.cap);
    }

    public static void setBlendFunc(@NotNull BlendFactor srcFactor, @NotNull BlendFactor destFactor) {
        GLRenderer.instance.currentSFactor = srcFactor;
        GLRenderer.instance.currentDFactor = destFactor;
        GL41.glBlendFunc(srcFactor.cap, destFactor.cap);
    }

    @NotNull
    public static BlendFactor getBlendSFactor() {
        return GLRenderer.instance.currentSFactor;
    }

    @NotNull
    public static BlendFactor getBlendDFactor() {
        return GLRenderer.instance.currentDFactor;
    }

    public static void setFrontFace(@NotNull FrontFace frontFace) {
        GLRenderer.instance.currentFrontFace = frontFace;
        GL41.glFrontFace(frontFace.cap);
    }

    @NotNull
    public static FrontFace getFrontFace() {
        return GLRenderer.instance.currentFrontFace;
    }

    public static void setLineWidth(float lineWidth) {
        GLRenderer.instance.currentLineWidth = lineWidth;
    }

    public static float getLineWidth() {
        return GLRenderer.instance.currentLineWidth;
    }

    public static void setColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GLRenderer.instance.currentColorMask = (byte)((red ? 8 : 0) | (green ? 4 : 0) | (blue ? 2 : 0) | (alpha ? 1 : 0));
        GL41.glColorMask(red, green, blue, alpha);
    }

    public static byte getColorMask() {
        return GLRenderer.instance.currentColorMask;
    }

    public static void setDepthMask(boolean flag) {
        GLRenderer.instance.currentDepthMask = flag;
        GL41.glDepthMask(flag);
    }

    public static boolean getDepthMask() {
        return GLRenderer.instance.currentDepthMask;
    }

    public static void setPolygonOffset(float factor, float units) {
        GLRenderer.instance.currentPolygonFactor = factor;
        GLRenderer.instance.currentPolygonUnits = units;
        GL41.glPolygonOffset(factor, units);
    }

    public static float getPolygonFactor() {
        return GLRenderer.instance.currentPolygonFactor;
    }

    public static float getPolygonUnits() {
        return GLRenderer.instance.currentPolygonUnits;
    }

    public static void setLightmapCoord1i(int lightmapCoord) {
        GLRenderer.setLightmapCoord2i(LightmapHelper.getBlockLightFromCoord(lightmapCoord), LightmapHelper.getSkyLightFromCoord(lightmapCoord));
    }

    public static void setLightmapCoord2i(int blockLight, int skyLight) {
        GLRenderer.setLightmapCoord2f(((float)blockLight + 0.5f) / 16.0f, ((float)skyLight + 0.5f) / 16.0f);
    }

    public static void setLightmapCoord2f(float blockLight, float skyLight) {
        GLRenderer.instance.currentLightmapBlock = blockLight;
        GLRenderer.instance.currentLightmapSky = skyLight;
    }

    public static float getLightmapBlock() {
        return GLRenderer.instance.currentLightmapBlock;
    }

    public static float getLightmapSky() {
        return GLRenderer.instance.currentLightmapSky;
    }

    public static void setAlphaTest(float alphaTest) {
        GLRenderer.instance.currentAlphaTest = alphaTest;
    }

    public static float getAlphaTest() {
        return GLRenderer.instance.currentAlphaTest;
    }

    public static void setColor1i(int argb) {
        GLRenderer.instance.currentColor = argb;
    }

    public static void setColor4f(float r, float g, float b, float a) {
        GLRenderer.setColor1i(Color.floatToIntARGB(a, r, g, b));
    }

    public static void setColor4d(double r, double g, double b, double a) {
        GLRenderer.setColor1i(Color.doubleToIntARGB(a, r, g, b));
    }

    public static void setColor4i(int r, int g, int b, int a) {
        GLRenderer.setColor1i(Color.intToIntARGB(a, r, g, b));
    }

    public static void setColor3f(float r, float g, float b) {
        GLRenderer.setColor4f(r, g, b, 1.0f);
    }

    public static void setColor(@NotNull Color color) {
        GLRenderer.setColor1i(color.value);
    }

    public static void setColor3fv(@NotNull Vector3fc colorVec) {
        GLRenderer.setColor4f(colorVec.x(), colorVec.y(), colorVec.z(), 1.0f);
    }

    public static void setColor4fv(@NotNull Vector4fc colorVec) {
        GLRenderer.setColor4f(colorVec.x(), colorVec.y(), colorVec.z(), colorVec.w());
    }

    public static void setColor3dv(@NotNull Vector3dc colorVec) {
        GLRenderer.setColor4d(colorVec.x(), colorVec.y(), colorVec.z(), 1.0);
    }

    public static void setColor4dv(@NotNull Vector4dc colorVec) {
        GLRenderer.setColor4d(colorVec.x(), colorVec.y(), colorVec.z(), colorVec.w());
    }

    public static void setColor3d(double r, double g, double b) {
        GLRenderer.setColor4d(r, g, b, 1.0);
    }

    public static void setColor3i(int r, int g, int b) {
        GLRenderer.setColor4i(r, g, b, 255);
    }

    public static int getColor() {
        return GLRenderer.instance.currentColor;
    }

    @NotNull
    public static TessellatorShader getTessellator() {
        return GLRenderer.instance.tessellatorShader;
    }

    public static void pushFrame() {
        GLRenderer.instance.stateConfigStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentStateConfig;
        GLRenderer.instance.colorStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentColor;
        GLRenderer.instance.shaderStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentShader;
        GLRenderer.instance.fogStateStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentFogState.copy();
        GLRenderer.instance.depthFuncStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentDepthFunc;
        GLRenderer.instance.cullFaceStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentCullFace;
        GLRenderer.instance.sFactorStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentSFactor;
        GLRenderer.instance.dFactorStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentDFactor;
        GLRenderer.instance.frontFaceStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentFrontFace;
        GLRenderer.instance.lineWidthStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentLineWidth;
        GLRenderer.instance.colorMaskStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentColorMask;
        GLRenderer.instance.depthMaskStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentDepthMask;
        GLRenderer.instance.polygonFactorStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentPolygonFactor;
        GLRenderer.instance.polygonUnitsStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentPolygonUnits;
        GLRenderer.instance.lightmapBlockStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentLightmapBlock;
        GLRenderer.instance.lightmapSkyStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentLightmapSky;
        GLRenderer.instance.alphaTestStack[GLRenderer.instance.stackIndex] = GLRenderer.instance.currentAlphaTest;
        if (DEBUG) {
            StackTraceElement[] eles = Thread.currentThread().getStackTrace();
            GLRenderer.instance.pushListenStack[GLRenderer.instance.stackIndex] = eles[2];
            if (GLRenderer.instance.stackIndex >= 63) {
                for (int i = 0; i < 64; ++i) {
                    StackTraceElement pushE = GLRenderer.instance.pushListenStack[i];
                    if (pushE == null) continue;
                    LOGGER.error("Index: {} \t {}.{}({}.java:{})", i, pushE.getClassName(), pushE.getMethodName(), pushE.getClassName().substring(pushE.getClassName().lastIndexOf(".") + 1), pushE.getLineNumber());
                }
                GLRenderer.reset();
                throw new RuntimeException("Stack Limit Exceeded");
            }
        }
        ++GLRenderer.instance.stackIndex;
        GLRenderer.instance.projectionMatrixStack.pushMatrix();
        GLRenderer.instance.viewMatrixStack.pushMatrix();
        GLRenderer.instance.viewProjMatDirty = true;
        GLRenderer.instance.modelMatrixStack.pushMatrix();
        GLRenderer.instance.textureMatrixStack.pushMatrix();
    }

    public static void popFrame() {
        --GLRenderer.instance.stackIndex;
        if (DEBUG) {
            StackTraceElement[] eles = Thread.currentThread().getStackTrace();
            if (GLRenderer.instance.stackIndex < 0) {
                for (int i = 0; i < 64; ++i) {
                    StackTraceElement pushE = GLRenderer.instance.pushListenStack[i];
                    StackTraceElement popE = GLRenderer.instance.popListenStack[i];
                    LOGGER.error("Index: {} \t {}.{}({}.java:{})", i, pushE.getClassName(), pushE.getMethodName(), pushE.getClassName().substring(pushE.getClassName().lastIndexOf(".") + 1), pushE.getLineNumber());
                    LOGGER.error("Index: {} \t {}.{}({}.java:{})", i, popE.getClassName(), popE.getMethodName(), popE.getClassName().substring(popE.getClassName().lastIndexOf(".") + 1), popE.getLineNumber());
                }
                GLRenderer.reset();
                throw new RuntimeException("Stack Limit Exceeded");
            }
            GLRenderer.instance.popListenStack[GLRenderer.instance.stackIndex] = eles[2];
        }
        GLRenderer.instance.projectionMatrixStack.popMatrix();
        GLRenderer.instance.viewMatrixStack.popMatrix();
        GLRenderer.instance.modelMatrixStack.popMatrix();
        GLRenderer.instance.textureMatrixStack.popMatrix();
        long newConfig = GLRenderer.instance.stateConfigStack[GLRenderer.instance.stackIndex];
        State.setStateConfig(GLRenderer.instance.currentStateConfig, newConfig);
        GLRenderer.instance.currentStateConfig = newConfig;
        GLRenderer.instance.currentColor = GLRenderer.instance.colorStack[GLRenderer.instance.stackIndex];
        GLRenderer.instance.currentShader = GLRenderer.instance.shaderStack[GLRenderer.instance.stackIndex];
        if (!GLRenderer.instance.currentFogState.equals(GLRenderer.instance.fogStateStack[GLRenderer.instance.stackIndex])) {
            GLRenderer.instance.fogStateDirty = true;
        }
        GLRenderer.instance.currentFogState = GLRenderer.instance.fogStateStack[GLRenderer.instance.stackIndex];
        if (GLRenderer.instance.currentDepthFunc != GLRenderer.instance.depthFuncStack[GLRenderer.instance.stackIndex]) {
            GLRenderer.instance.currentDepthFunc = GLRenderer.instance.depthFuncStack[GLRenderer.instance.stackIndex];
            GL41.glDepthFunc(GLRenderer.instance.currentDepthFunc.cap);
        }
        if (GLRenderer.instance.currentCullFace != GLRenderer.instance.cullFaceStack[GLRenderer.instance.stackIndex]) {
            GLRenderer.instance.currentCullFace = GLRenderer.instance.cullFaceStack[GLRenderer.instance.stackIndex];
            GL41.glCullFace(GLRenderer.instance.currentCullFace.cap);
        }
        if (GLRenderer.instance.currentSFactor != GLRenderer.instance.sFactorStack[GLRenderer.instance.stackIndex] || GLRenderer.instance.currentDFactor != GLRenderer.instance.dFactorStack[GLRenderer.instance.stackIndex]) {
            GLRenderer.instance.currentSFactor = GLRenderer.instance.sFactorStack[GLRenderer.instance.stackIndex];
            GLRenderer.instance.currentDFactor = GLRenderer.instance.dFactorStack[GLRenderer.instance.stackIndex];
            GL41.glBlendFunc(GLRenderer.instance.currentSFactor.cap, GLRenderer.instance.currentDFactor.cap);
        }
        if (GLRenderer.instance.currentFrontFace != GLRenderer.instance.frontFaceStack[GLRenderer.instance.stackIndex]) {
            GLRenderer.instance.currentFrontFace = GLRenderer.instance.frontFaceStack[GLRenderer.instance.stackIndex];
            GL41.glFrontFace(GLRenderer.instance.currentFrontFace.cap);
        }
        GLRenderer.instance.currentLineWidth = GLRenderer.instance.lineWidthStack[GLRenderer.instance.stackIndex];
        if (GLRenderer.instance.currentColorMask != GLRenderer.instance.colorMaskStack[GLRenderer.instance.stackIndex]) {
            GLRenderer.instance.currentColorMask = GLRenderer.instance.colorMaskStack[GLRenderer.instance.stackIndex];
            GL41.glColorMask((GLRenderer.instance.currentColorMask & 8) != 0, (GLRenderer.instance.currentColorMask & 4) != 0, (GLRenderer.instance.currentColorMask & 2) != 0, (GLRenderer.instance.currentColorMask & 1) != 0);
        }
        if (GLRenderer.instance.currentDepthMask != GLRenderer.instance.depthMaskStack[GLRenderer.instance.stackIndex]) {
            GLRenderer.instance.currentDepthMask = GLRenderer.instance.depthMaskStack[GLRenderer.instance.stackIndex];
            GL41.glDepthMask(GLRenderer.instance.currentDepthMask);
        }
        if (GLRenderer.instance.currentPolygonFactor != GLRenderer.instance.polygonFactorStack[GLRenderer.instance.stackIndex] || GLRenderer.instance.currentPolygonUnits != GLRenderer.instance.polygonUnitsStack[GLRenderer.instance.stackIndex]) {
            GLRenderer.instance.currentPolygonFactor = GLRenderer.instance.polygonFactorStack[GLRenderer.instance.stackIndex];
            GLRenderer.instance.currentPolygonUnits = GLRenderer.instance.polygonUnitsStack[GLRenderer.instance.stackIndex];
            GL41.glPolygonOffset(GLRenderer.instance.currentPolygonFactor, GLRenderer.instance.currentPolygonUnits);
        }
        GLRenderer.instance.currentLightmapBlock = GLRenderer.instance.lightmapBlockStack[GLRenderer.instance.stackIndex];
        GLRenderer.instance.currentLightmapSky = GLRenderer.instance.lightmapSkyStack[GLRenderer.instance.stackIndex];
        GLRenderer.instance.currentAlphaTest = GLRenderer.instance.alphaTestStack[GLRenderer.instance.stackIndex];
    }

    protected static void reset() {
        GLRenderer.instance.stackIndex = 1;
        GLRenderer.setShader(Shaders.INTERFACE);
    }

    static {
        GLRenderer.LIGHT_0.diffuse.set(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.LIGHT_0.specular.set(1.0f, 1.0f, 1.0f, 1.0f);
        NORMAL_TRANSFORM_MATRIX = new Matrix4f().identity();
        STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        lightBuf = BufferUtils.createFloatBuffer(8);
        matBuf = new Matrix4f();
    }
}

