/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import net.minecraft.client.render.tessellator.Tessellator;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public interface TessellatorTextured
extends Tessellator {
    public void setTextureUV(double var1, double var3);

    default public void addVertexWithUV(double x, double y, double z, double u, double v) {
        this.setTextureUV(u, v);
        this.addVertex(x, y, z);
    }

    default public void addVertexWithUV(@NotNull Vector3dc pos, double u, double v) {
        this.addVertexWithUV(pos.x(), pos.y(), pos.z(), u, v);
    }

    default public void addVertexWithUV(@NotNull Vector3fc pos, double u, double v) {
        this.addVertexWithUV(pos.x(), pos.y(), pos.z(), u, v);
    }

    default public void drawRectangleWithUV(int x, int y, int width, int height, double u, double v, double uvWidth, double uvHeight) {
        this.addVertexWithUV(x, y, 0.0, u, v);
        this.addVertexWithUV(x, y + height, 0.0, u, v + uvHeight);
        this.addVertexWithUV(x + width, y + height, 0.0, u + uvWidth, v + uvHeight);
        this.addVertexWithUV(x + width, y, 0.0, u + uvWidth, v);
    }
}

