/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.IArmorWearing;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkPosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;

public class ExplosionCannonball
extends Explosion {
    public ExplosionCannonball(@NotNull World world, @Nullable Entity exploder, double x, double y, double z, float explosionSize) {
        super(world, exploder, x, y, z, explosionSize);
    }

    @Override
    public void explode() {
        int i = 16;
        for (int j = 0; j < i; ++j) {
            for (int l = 0; l < i; ++l) {
                for (int j1 = 0; j1 < i; ++j1) {
                    if (j != 0 && j != i - 1 && l != 0 && l != i - 1 && j1 != 0 && j1 != i - 1) continue;
                    double d = (float)j / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)l / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)j1 / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d * d + d1 * d1 + d2 * d2);
                    d /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d5 = this.explosionX;
                    double d7 = this.explosionY;
                    double d9 = this.explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = this.explosionSize * (0.7f + this.world.rand.nextFloat() * 0.6f); !(f1 <= 0.0f); f1 -= f2 * 0.75f) {
                        int l4;
                        int k4;
                        int j4 = MathHelper.floor(d5);
                        int i5 = this.world.getBlockId(j4, k4 = MathHelper.floor(d7), l4 = MathHelper.floor(d9));
                        if (i5 > 0) {
                            f1 -= (Blocks.blocksList[i5].getBlastResistance(this.exploder) + 0.3f) * f2;
                        }
                        if (f1 > 0.0f) {
                            this.destroyedBlockPositions.add(new ChunkPosition(j4, k4, l4));
                        }
                        d5 += d * (double)f2;
                        d7 += d1 * (double)f2;
                        d9 += d2 * (double)f2;
                    }
                }
            }
        }
        this.explosionSize *= 2.0f;
        int minX = MathHelper.floor(this.explosionX - (double)this.explosionSize - 1.0);
        int maxX = MathHelper.floor(this.explosionX + (double)this.explosionSize + 1.0);
        int minY = MathHelper.floor(this.explosionY - (double)this.explosionSize - 1.0);
        int maxY = MathHelper.floor(this.explosionY + (double)this.explosionSize + 1.0);
        int minZ = MathHelper.floor(this.explosionZ - (double)this.explosionSize - 1.0);
        int maxZ = MathHelper.floor(this.explosionZ + (double)this.explosionSize + 1.0);
        List<Entity> list = this.world.getEntitiesWithinAABB(Entity.class, new AABBd(minX, minY, minZ, maxX, maxY, maxZ));
        Vector3d vec3 = new Vector3d(this.explosionX, this.explosionY, this.explosionZ);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Entity entity = list.get(k2);
            double d4 = entity.distanceTo(this.explosionX, this.explosionY, this.explosionZ) / (double)this.explosionSize;
            if (!(d4 <= 1.0)) continue;
            double xComp = entity.x - this.explosionX;
            double yComp = entity.y - this.explosionY;
            double zComp = entity.z - this.explosionZ;
            double d11 = MathHelper.sqrt(xComp * xComp + yComp * yComp + zComp * zComp);
            xComp *= 2.5;
            yComp /= d11;
            yComp += 0.5;
            zComp *= 2.5;
            double d12 = this.world.getSeenPercent(vec3, entity.bb);
            double flingForce = (1.0 - d4) * d12;
            entity.hurt(this.exploder, (int)((flingForce * flingForce + flingForce) / 2.0 * 8.0 * (double)this.explosionSize + 1.0), DamageType.BLAST);
            if (entity instanceof IArmorWearing && entity != this.exploder) {
                float proc = 1.0f - ((IArmorWearing)((Object)entity)).getTotalProtectionAmount(DamageType.BLAST) / 2.0f;
                flingForce *= (double)proc;
            }
            entity.fling(xComp * flingForce, yComp * flingForce, zComp * flingForce, 1.0f);
        }
        ArrayList arraylist = new ArrayList(this.destroyedBlockPositions);
        if (this.isFlaming) {
            for (int l2 = arraylist.size() - 1; l2 >= 0; --l2) {
                ChunkPosition chunkposition = (ChunkPosition)arraylist.get(l2);
                int i3 = chunkposition.x;
                int j3 = chunkposition.y;
                int k3 = chunkposition.z;
                int l3 = this.world.getBlockId(i3, j3, k3);
                int i4 = this.world.getBlockId(i3, j3 - 1, k3);
                if (l3 != Blocks.AIR.id() || !Blocks.solid[i4] || this.ExplosionRNG.nextInt(3) != 0) continue;
                this.world.setBlockWithNotify(i3, j3, k3, Blocks.FIRE.id());
            }
        }
    }

    @Override
    public void addEffects(boolean particles) {
        if (!this.world.isClientSide) {
            this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f);
        }
        ArrayList arraylist = new ArrayList(this.destroyedBlockPositions);
        for (int i = arraylist.size() - 1; i >= 0; --i) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(i);
            int x = chunkposition.x;
            int y = chunkposition.y;
            int z = chunkposition.z;
            Block<?> block = this.world.getBlock(x, y, z);
            TileEntity tileEntity = this.world.getTileEntity(x, y, z);
            if (particles) {
                double d = (double)x + (double)this.world.rand.nextFloat();
                double d1 = (double)y + (double)this.world.rand.nextFloat();
                double d2 = (double)z + (double)this.world.rand.nextFloat();
                double d3 = d - this.explosionX;
                double d4 = d1 - this.explosionY;
                double d5 = d2 - this.explosionZ;
                double d6 = MathHelper.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                this.world.spawnParticle("explode", (d + this.explosionX) / 2.0, (d1 + this.explosionY) / 2.0, (d2 + this.explosionZ) / 2.0, d3 *= (d7 *= (double)(this.world.rand.nextFloat() * this.world.rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, 0);
                this.world.spawnParticle("smoke", d, d1, d2, d3, d4, d5, 0);
            }
            if (block == null || block != Blocks.GLASS && block.getMaterial() != Materials.TOP_SNOW && block.getMaterial() != Materials.PLANT && block.getMaterial() != Materials.WEB && block.getMaterial() != Materials.DECORATION && block.getMaterial() != Materials.ICE) continue;
            block.dropBlockWithCause(this.world, EnumDropCause.EXPLOSION, x, y, z, this.world.getBlockMetadata(x, y, z), tileEntity, null);
            this.world.setBlockWithNotify(x, y, z, 0);
            block.onBlockDestroyedByExplosion(this.world, x, y, z);
        }
    }
}

