/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.packet.PacketSignUpdate;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.lwjgl.input.Keyboard;

public class ScreenSignEditor
extends Screen {
    private boolean inKeyboard = false;
    protected String screenTitle = I18n.getInstance().translateKey("gui.edit_sign.label.title");
    @NotNull
    private final TileEntitySign entitySign;
    private int updateCounter;
    private int editLine = 0;
    private int yOffset = 0;
    private static final String allowedCharacters = ChatAllowedCharacters.ALLOWED_CHARACTERS;

    public ScreenSignEditor(@NotNull TileEntitySign sign) {
        this.entitySign = sign;
    }

    @Override
    public void init() {
        this.buttons.clear();
        Keyboard.enableRepeatEvents(true);
        Block<?> block = this.entitySign.getBlock();
        if (block == Blocks.SIGN_POST_PLANKS_OAK) {
            this.yOffset = 36;
        }
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, 200 + this.yOffset, I18n.getInstance().translateKey("gui.edit_sign.button.done")));
        this.buttons.add(new ButtonElement(1, this.width / 2 - 20, 170 + this.yOffset, 20, 20, "<"));
        this.buttons.add(new ButtonElement(2, this.width / 2, 170 + this.yOffset, 20, 20, ">"));
        boolean wallSign = false;
        if (Block.hasLogicClass(block, BlockLogicSign.class)) {
            wallSign = !((BlockLogicSign)block.getLogic()).isFreeStanding;
        }
        this.add(new ListenerButtonElement(30, this.width / 2 - 50, 67 + (wallSign ? 31 : 0), 100, 12, "").setActionListener(() -> {
            this.editLine = 0;
            this.inKeyboard = true;
        })).mute().hide();
        this.add(new ListenerButtonElement(30, this.width / 2 - 50, 79 + (wallSign ? 31 : 0), 100, 12, "").setActionListener(() -> {
            this.editLine = 1;
            this.inKeyboard = true;
        })).mute().hide();
        this.add(new ListenerButtonElement(30, this.width / 2 - 50, 91 + (wallSign ? 31 : 0), 100, 12, "").setActionListener(() -> {
            this.editLine = 2;
            this.inKeyboard = true;
        })).mute().hide();
        this.add(new ListenerButtonElement(30, this.width / 2 - 50, 103 + (wallSign ? 31 : 0), 100, 12, "").setActionListener(() -> {
            this.editLine = 3;
            this.inKeyboard = true;
        })).mute().hide();
        this.inKeyboard = ((Boolean)this.mc.gameSettings.forceOnscreenKeyboard.value != false || this.mc.inputType == InputType.CONTROLLER) && !(this.mc.currentScreen instanceof ScreenKeyboard);
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
        if (this.mc.currentWorld != null && this.mc.currentWorld.isClientSide) {
            this.mc.getSendQueue().addToSendQueue(new PacketSignUpdate(this.entitySign.x, this.entitySign.y, this.entitySign.z, this.entitySign.signText, this.entitySign.getPicture().getId(), this.entitySign.getColor().id));
        }
    }

    @Override
    public void tick() {
        ++this.updateCounter;
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        int id;
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.entitySign.setChanged();
            this.mc.displayScreen(null);
        }
        if (button.id == 1) {
            id = this.entitySign.getPicture().getId();
            int lastId = id - 1;
            if (lastId < 0) {
                lastId = EnumSignPicture.values().length - 1;
            }
            this.entitySign.setPicture(EnumSignPicture.values()[lastId]);
            this.entitySign.setChanged();
        }
        if (button.id == 2) {
            id = this.entitySign.getPicture().getId();
            int nextId = id + 1;
            if (nextId >= EnumSignPicture.values().length) {
                nextId = 0;
            }
            this.entitySign.setPicture(EnumSignPicture.values()[nextId]);
            this.entitySign.setChanged();
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.entitySign.setChanged();
            this.mc.displayScreen(null);
        }
        if (eventKey == Keyboard.KEY_UP) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (eventKey == Keyboard.KEY_DOWN || eventKey == Keyboard.KEY_PRINT_SCREEN || eventKey == Keyboard.KEY_NUMPADENTER) {
            this.editLine = this.editLine + 1 & 3;
        }
        if (eventKey == Keyboard.KEY_BACK && !this.entitySign.signText[this.editLine].isEmpty()) {
            this.entitySign.signText[this.editLine] = this.entitySign.signText[this.editLine].substring(0, this.entitySign.signText[this.editLine].length() - 1);
        }
        if ((allowedCharacters.indexOf(eventCharacter) >= 0 || Character.isLetterOrDigit(eventCharacter)) && this.entitySign.signText[this.editLine].length() < 15) {
            int n = this.editLine;
            this.entitySign.signText[n] = this.entitySign.signText[n] + eventCharacter;
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.inKeyboard && (((Boolean)this.mc.gameSettings.forceOnscreenKeyboard.value).booleanValue() || this.mc.inputType == InputType.CONTROLLER) && !(this.mc.currentScreen instanceof ScreenKeyboard) && this.editLine < this.entitySign.signText.length) {
            ScreenKeyboard keyboard = new ScreenKeyboard(this, null, s -> {
                this.entitySign.signText[this.editLine] = s;
                if (this.editLine < this.entitySign.signText.length - 1) {
                    ++this.editLine;
                } else {
                    this.inKeyboard = false;
                }
            }, (c, k, s) -> {
                this.entitySign.signText[this.editLine] = s;
            }, s -> {
                this.entitySign.signText[this.editLine] = s;
            });
            keyboard.editor.setText(this.entitySign.signText[this.editLine]);
            keyboard.editor.setCursor(Integer.MAX_VALUE);
            this.mc.displayScreen(keyboard);
        }
        this.renderBackground();
        this.drawStringCenteredShadow(this.fontRenderer, this.screenTitle, this.width / 2, 40, 0xFFFFFF);
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)this.width / 2.0f, 0.0f, 50.0f);
        float scale = 93.75f;
        GLRenderer.modelM4f().scale(-scale, -scale, -scale);
        GLRenderer.modelM4f().rotateY((float)java.lang.Math.PI);
        Block<?> block = this.entitySign.getBlock();
        if (Block.hasLogicClass(block, BlockLogicSign.class)) {
            BlockLogicSign sign = (BlockLogicSign)block.getLogic();
            if (sign.isFreeStanding) {
                float signAngle = (float)((this.entitySign.getBlockMeta() & 0xF) * 360) / 16.0f;
                GLRenderer.modelM4f().rotateY(Math.toRadians(signAngle));
                GLRenderer.modelM4f().translate(0.0f, -1.0625f, 0.0f);
            } else {
                int meta = this.entitySign.getBlockMeta() & 0xF;
                float signAngle = 0.0f;
                if (meta == 2) {
                    signAngle = 180.0f;
                }
                if (meta == 4) {
                    signAngle = 90.0f;
                }
                if (meta == 5) {
                    signAngle = -90.0f;
                }
                GLRenderer.modelM4f().rotateY(Math.toRadians(signAngle));
                GLRenderer.modelM4f().translate(0.0f, -1.0625f, 0.0f);
            }
        }
        if (this.updateCounter / 6 % 2 == 0) {
            this.entitySign.lineBeingEdited = this.editLine;
        }
        GLRenderer.enableState(State.BLEND);
        TileEntityRenderDispatcher.instance.renderTileEntity(GLRenderer.getTessellator(), this.entitySign, -0.5, -0.75, -0.5, 0.0f);
        this.entitySign.lineBeingEdited = -1;
        GLRenderer.disableState(State.BLEND);
        GLRenderer.popFrame();
        this.drawStringCenteredShadow(this.fontRenderer, I18n.getInstance().translateKey(this.entitySign.getPicture().getLanguageKey()), this.width / 2, 150 + this.yOffset, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        super.guiSpecificControllerInput(controller);
        if (controller.digitalPad.up.pressedThisFrame()) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (controller.digitalPad.down.pressedThisFrame()) {
            this.editLine = this.editLine + 1 & 3;
        }
    }
}

