/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.block.model.BlockModelTransparent;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelGlass<T extends BlockLogic>
extends BlockModelTransparent<T> {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    protected final IconCoordinate[] coordinates = new IconCoordinate[16];

    public BlockModelGlass(Block<T> block, @NotNull String rootKey) {
        super(block, false);
        this.coordinates[0] = TextureRegistry.getTexture(rootKey + "none");
        this.coordinates[1] = TextureRegistry.getTexture(rootKey + "up");
        this.coordinates[2] = TextureRegistry.getTexture(rootKey + "down");
        this.coordinates[4] = TextureRegistry.getTexture(rootKey + "left");
        this.coordinates[8] = TextureRegistry.getTexture(rootKey + "right");
        this.coordinates[3] = TextureRegistry.getTexture(rootKey + "up_down");
        this.coordinates[5] = TextureRegistry.getTexture(rootKey + "up_left");
        this.coordinates[9] = TextureRegistry.getTexture(rootKey + "up_right");
        this.coordinates[6] = TextureRegistry.getTexture(rootKey + "down_left");
        this.coordinates[10] = TextureRegistry.getTexture(rootKey + "down_right");
        this.coordinates[12] = TextureRegistry.getTexture(rootKey + "left_right");
        this.coordinates[7] = TextureRegistry.getTexture(rootKey + "up_down_left");
        this.coordinates[11] = TextureRegistry.getTexture(rootKey + "up_down_right");
        this.coordinates[13] = TextureRegistry.getTexture(rootKey + "up_left_right");
        this.coordinates[14] = TextureRegistry.getTexture(rootKey + "down_left_right");
        this.coordinates[15] = TextureRegistry.getTexture(rootKey + "up_down_left_right");
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (((Boolean)Minecraft.getMinecraft().gameSettings.connectedGlass.value).booleanValue()) {
            boolean l;
            boolean d;
            boolean u;
            TilePos queryPos = new TilePos();
            return this.coordinates[(u ? 1 : 0) | (d ? 2 : 0) | (l ? 4 : 0) | ((switch (side) {
                case Side.SOUTH -> {
                    u = source.getBlockType(tilePos.up(queryPos)) == this.block;
                    d = source.getBlockType(tilePos.down(queryPos)) == this.block;
                    l = source.getBlockType(tilePos.west(queryPos)) == this.block;
                    yield source.getBlockType(tilePos.east(queryPos)) == this.block;
                }
                case Side.NORTH -> {
                    u = source.getBlockType(tilePos.up(queryPos)) == this.block;
                    d = source.getBlockType(tilePos.down(queryPos)) == this.block;
                    l = source.getBlockType(tilePos.east(queryPos)) == this.block;
                    yield source.getBlockType(tilePos.west(queryPos)) == this.block;
                }
                case Side.WEST -> {
                    u = source.getBlockType(tilePos.up(queryPos)) == this.block;
                    d = source.getBlockType(tilePos.down(queryPos)) == this.block;
                    l = source.getBlockType(tilePos.north(queryPos)) == this.block;
                    yield source.getBlockType(tilePos.south(queryPos)) == this.block;
                }
                case Side.EAST -> {
                    u = source.getBlockType(tilePos.up(queryPos)) == this.block;
                    d = source.getBlockType(tilePos.down(queryPos)) == this.block;
                    l = source.getBlockType(tilePos.south(queryPos)) == this.block;
                    yield source.getBlockType(tilePos.north(queryPos)) == this.block;
                }
                default -> {
                    u = source.getBlockType(tilePos.north(queryPos)) == this.block;
                    d = source.getBlockType(tilePos.south(queryPos)) == this.block;
                    l = source.getBlockType(tilePos.west(queryPos)) == this.block;
                    yield source.getBlockType(tilePos.east(queryPos)) == this.block;
                }
            }) ? 8 : 0)];
        }
        return super.getBlockTexture(source, tilePos, side);
    }
}

