/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPiston;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPistonHead;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.piston.BlockLogicPistonBaseSteel;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.world.BlocksContainer;
import net.minecraft.core.world.pos.TilePos;

public class TileEntityRendererMovingPiston
extends TileEntityRenderer<TileEntityMovingPistonBlock> {
    private final Minecraft mc = Minecraft.getMinecraft();
    private BlocksContainer container = null;

    @Override
    public void doRender(TessellatorGeneral tessellator, TileEntityMovingPistonBlock tileEntity, double x, double y, double z, float partialTick) {
        Block<?> block = tileEntity.getMovedBlock();
        if (tileEntity.getProgress(partialTick) < 1.0f) {
            if (this.container == null || this.container.world != tileEntity.worldObj) {
                this.container = new BlocksContainer(tileEntity.worldObj);
            }
            TilePos tileEntPos = new TilePos(tileEntity.x, tileEntity.y, tileEntity.z);
            TextureRegistry.worldAtlas.bind();
            GLRenderer.setShader(Shaders.TERRAIN);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            GLRenderer.enableState(State.BLEND);
            GLRenderer.disableState(State.CULL_FACE);
            tessellator.startDrawingQuads();
            tessellator.setTranslation((float)x - (float)tileEntity.x + tileEntity.getXOff(partialTick), (float)y - (float)tileEntity.y + tileEntity.getYOff(partialTick), (float)z - (float)tileEntity.z + tileEntity.getZOff(partialTick));
            if (Block.hasLogicClass(block, BlockLogicPistonHead.class) && tileEntity.getProgress(partialTick) < 0.5f) {
                ((BlockModelGenericPistonHead)BlockModelDispatcher.getInstance().getDispatch(block)).renderPistonHeadNoCulling(tessellator, tileEntity.worldObj, tileEntity.getBlockMeta(), tileEntPos, false);
            } else if (tileEntity.isSourcePiston() && !tileEntity.isExtending()) {
                BlockModelGenericPiston pistonBase = (BlockModelGenericPiston)BlockModelDispatcher.getInstance().getDispatch(block);
                if (Block.hasLogicClass(block, BlockLogicPistonBaseSteel.class)) {
                    ((BlockModelGenericPistonHead)BlockModelDispatcher.getInstance().getDispatch(Blocks.PISTON_HEAD_STEEL)).renderPistonHeadNoCulling(tessellator, tileEntity.worldObj, 16, tileEntPos, tileEntity.getProgress(partialTick) < 0.5f);
                } else {
                    ((BlockModelGenericPistonHead)BlockModelDispatcher.getInstance().getDispatch(Blocks.PISTON_HEAD)).renderPistonHeadNoCulling(tessellator, tileEntity.worldObj, tileEntity.getBlockMeta(), tileEntPos, tileEntity.getProgress(partialTick) < 0.5f);
                }
                tessellator.setTranslation((float)x - (float)tileEntity.x, (float)y - (float)tileEntity.y, (float)z - (float)tileEntity.z);
                pistonBase.renderHeadless(tessellator, tileEntity.worldObj, tileEntPos);
            } else {
                this.container.setBlock(tileEntity.x, tileEntity.y, tileEntity.z, block.id(), tileEntity.getMovedData(), tileEntity.getMovedEntity());
                ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderNoCulling(tessellator, this.container, tileEntPos);
                this.container.setLightReferenceEntity(null);
                this.container.clear();
            }
            tessellator.setTranslation(0.0, 0.0, 0.0);
            tessellator.draw();
            TileEntity movedEntity = tileEntity.getMovedEntity();
            TileEntityRenderer<TileEntity> renderer = TileEntityRenderDispatcher.instance.getRenderer(movedEntity);
            if (renderer != null) {
                GLRenderer.pushFrame();
                GLRenderer.modelM4f().translate(tileEntity.getXOff(partialTick), tileEntity.getYOff(partialTick), tileEntity.getZOff(partialTick));
                renderer.doRender(tessellator, movedEntity, x, y, z, partialTick);
                GLRenderer.popFrame();
            }
        }
    }
}

