/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pos.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkProviderClient
implements IChunkProvider {
    @NotNull
    private final Chunk blankChunk;
    @NotNull
    private final Map<ChunkPos, Chunk> chunkMapping = new HashMap<ChunkPos, Chunk>();
    @NotNull
    private final List<Chunk> chunks = new ArrayList<Chunk>();
    @NotNull
    private final World worldObj;

    public ChunkProviderClient(@NotNull World world) {
        this.blankChunk = new EmptyChunk(world, 0, 0);
        this.worldObj = world;
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPos chunkPos) {
        return this.chunkMapping.containsKey(chunkPos);
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPos chunkPos) {
    }

    public void dropChunk(@NotNull ChunkPos chunkPos) {
        Chunk chunk = this.provideChunk(chunkPos, true);
        if (!chunk.isChunkEmpty()) {
            chunk.onUnload();
        }
        this.chunkMapping.remove(chunkPos);
        this.chunks.remove(chunk);
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        if (this.chunkMapping.containsKey(chunkPos)) {
            return this.chunkMapping.get(chunkPos);
        }
        Chunk chunk = new Chunk(this.worldObj, new ChunkPos(chunkPos));
        this.chunkMapping.put(chunk.pos, chunk);
        chunk.isLoaded = true;
        return chunk;
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        Chunk chunk = this.chunkMapping.get(chunkPos);
        if (chunk == null) {
            return this.blankChunk;
        }
        return chunk;
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        return true;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public void populate(@NotNull ChunkPos chunkPos) {
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "MultiplayerChunkCache: " + this.chunkMapping.size();
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPos chunkPos) {
    }
}

