/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.drift.BiomeDrift;
import net.minecraft.core.world.biome.nether.BiomeAshPlains;
import net.minecraft.core.world.biome.nether.BiomeBoneyard;
import net.minecraft.core.world.biome.nether.BiomeCrystalForest;
import net.minecraft.core.world.biome.nether.BiomeNether;
import net.minecraft.core.world.biome.nether.BiomeSulfurPools;
import net.minecraft.core.world.biome.nether.BiomeVolcanoIslands;
import net.minecraft.core.world.biome.overworld.BiomeBirchForest;
import net.minecraft.core.world.biome.overworld.BiomeBorealForest;
import net.minecraft.core.world.biome.overworld.BiomeCaatinga;
import net.minecraft.core.world.biome.overworld.BiomeDesert;
import net.minecraft.core.world.biome.overworld.BiomeForest;
import net.minecraft.core.world.biome.overworld.BiomeOutback;
import net.minecraft.core.world.biome.overworld.BiomePlains;
import net.minecraft.core.world.biome.overworld.BiomeRainforest;
import net.minecraft.core.world.biome.overworld.BiomeRetro;
import net.minecraft.core.world.biome.overworld.BiomeSeasonalForest;
import net.minecraft.core.world.biome.overworld.BiomeShrubland;
import net.minecraft.core.world.biome.overworld.BiomeSwamp;
import net.minecraft.core.world.biome.overworld.BiomeTaiga;
import net.minecraft.core.world.biome.overworld.legacy.BiomeDesertLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeForestLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeRainforestLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeSwampLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeTaigaLegacy;
import net.minecraft.core.world.weather.Weathers;

public class Biomes {
    public static final Biome OVERWORLD_RAINFOREST = Biomes.register("minecraft:overworld.rainforest", new BiomeRainforest("overworld.rainforest").setColor(1896704).setBlockedWeathers(Weathers.OVERWORLD_SNOW));
    public static final Biome OVERWORLD_SWAMPLAND = Biomes.register("minecraft:overworld.swampland", new BiomeSwamp("overworld.swampland").setColor(65400));
    public static final Biome OVERWORLD_SEASONAL_FOREST = Biomes.register("minecraft:overworld.seasonal_forest", new BiomeSeasonalForest("overworld.seasonal_forest").setColor(6606357));
    public static final Biome OVERWORLD_FOREST = Biomes.register("minecraft:overworld.forest", new BiomeForest("overworld.forest").setColor(2532885));
    public static final Biome OVERWORLD_GRASSLANDS = Biomes.register("minecraft:overworld.grasslands", new Biome("overworld.grasslands").setColor(15790152).setBlockedWeathers(Weathers.OVERWORLD_SNOW));
    public static final Biome OVERWORLD_OUTBACK = Biomes.register("minecraft:overworld.outback", new BiomeOutback("overworld.outback").setColor(14245408).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setTopBlock(Blocks.DIRT_SCORCHED.id()).setFillerBlock(Blocks.DIRT_SCORCHED.id()));
    public static final Biome OVERWORLD_SHRUBLAND = Biomes.register("minecraft:overworld.shrubland", new BiomeShrubland("overworld.shrubland").setColor(12237368));
    public static final Biome OVERWORLD_TAIGA = Biomes.register("minecraft:overworld.taiga", new BiomeTaiga("overworld.taiga").setColor(9092351).setSurfaceSnow().setSurfaceIce());
    public static final Biome OVERWORLD_BOREAL_FOREST = Biomes.register("minecraft:overworld.boreal_forest", new BiomeBorealForest("overworld.boreal_forest").setColor(1344868));
    public static final Biome OVERWORLD_DESERT = Biomes.register("minecraft:overworld.desert", new BiomeDesert("overworld.desert").setColor(15589999).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM).setTopBlock(Blocks.SAND.id()).setFillerBlock(Blocks.SAND.id()));
    public static final Biome OVERWORLD_PLAINS = Biomes.register("minecraft:overworld.plains", new BiomePlains("overworld.plains").setColor(10733129));
    public static final Biome OVERWORLD_GLACIER = Biomes.register("minecraft:overworld.glacier", new Biome("overworld.glacier").setColor(13367039).setSurfaceSnow().setTopBlock(Blocks.BLOCK_SNOW.id()).setFillerBlock(Blocks.BLOCK_SNOW.id()));
    public static final Biome OVERWORLD_TUNDRA = Biomes.register("minecraft:overworld.tundra", new Biome("overworld.tundra").setColor(5759231).setSurfaceSnow().setSurfaceIce());
    public static final Biome OVERWORLD_MEADOW = Biomes.register("minecraft:overworld.meadow", new BiomeBorealForest("overworld.meadow").setColor(0x8C8C22));
    public static final Biome DRIFT_DRIFT = Biomes.register("minecraft:drift.drift", new BiomeDrift("drift.drift").setColor(0x8080FF).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG));
    public static final Biome OVERWORLD_BIRCH_FOREST = Biomes.register("minecraft:overworld.birch_forest", new BiomeBirchForest("overworld.birch_forest").setColor(4967262));
    public static final Biome OVERWORLD_RETRO = Biomes.register("minecraft:overworld.retro", new BiomeRetro("overworld.retro").setColor(7778634).setTopBlock(Blocks.GRASS_RETRO.id()));
    public static final Biome OVERWORLD_HELL = Biomes.register("minecraft:overworld.hell", new Biome("overworld.hell").setColor(14246435).setTopBlock(Blocks.DIRT_SCORCHED.id()).setTopBlock(Blocks.DIRT_SCORCHED.id()));
    public static final Biome OVERWORLD_SWAMPLAND_MUDDY = Biomes.register("minecraft:overworld.swampland.muddy", new BiomeSwamp("overworld.swampland.muddy").setColor(5383936));
    public static final Biome OVERWORLD_OUTBACK_GRASSY = Biomes.register("minecraft:overworld.outback.grassy", new BiomeOutback("overworld.outback.grassy").setColor(15765559).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setTopBlock(Blocks.GRASS_SCORCHED.id()).setFillerBlock(Blocks.DIRT_SCORCHED.id()));
    public static final Biome OVERWORLD_CAATINGA = Biomes.register("minecraft:overworld.caatinga", new BiomeCaatinga("overworld.caatinga").setColor(14601638).setTopBlock(Blocks.MUD_BAKED.id()).setFillerBlock(Blocks.MUD_BAKED.id()).setBlockedWeathers(Weathers.OVERWORLD_SNOW));
    public static final Biome OVERWORLD_CAATINGA_PLAINS = Biomes.register("minecraft:overworld.caatinga.plains", new Biome("overworld.caatinga.plains").setColor(10589303).setTopBlock(Blocks.MUD_BAKED.id()).setFillerBlock(Blocks.MUD_BAKED.id()).setBlockedWeathers(Weathers.OVERWORLD_SNOW));
    public static final Biome NETHER_NETHER = Biomes.register("minecraft:nether.nether", new BiomeNether("nether.nether").setColor(0xDD0000).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome NETHER_VOLCANIC_ISLANDS = Biomes.register("minecraft:nether.volcanic_islands", new BiomeVolcanoIslands("nether.volcanic_islands").setColor(0xDD0000).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome NETHER_SULFUR_POOLS = Biomes.register("minecraft:nether.sulfur_pools", new BiomeSulfurPools("nether.sulfur_pools").setColor(0xDD0000).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome NETHER_CRYSTAL_FOREST = Biomes.register("minecraft:nether.crystal_forest", new BiomeCrystalForest("nether.crystal_forest").setColor(0xDD0000).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome NETHER_ASH_PLAINS = Biomes.register("minecraft:nether.ash_plains", new BiomeAshPlains("nether.ash_plains").setColor(0xDD0000).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.SLATE.id()).setFillerBlock(Blocks.SLATE.id()));
    public static final Biome NETHER_BONEYARD = Biomes.register("minecraft:nether.boneyard", new BiomeBoneyard("nether.boneyard").setColor(0xDD0000).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.SOULSAND.id()).setFillerBlock(Blocks.SOULSAND.id()));
    public static final Biome OVERWORLD_LEGACY_RAINFOREST = Biomes.register("minecraft:overworld.legacy.rainforest", new BiomeRainforestLegacy("overworld.legacy.rainforest").setColor(14278691).setBlockedWeathers(Weathers.OVERWORLD_SNOW));
    public static final Biome OVERWORLD_LEGACY_SWAMPLAND = Biomes.register("minecraft:overworld.legacy.swampland", new BiomeSwampLegacy("overworld.legacy.swampland").setColor(522674));
    public static final Biome OVERWORLD_LEGACY_SEASONAL_FOREST = Biomes.register("minecraft:overworld.legacy.seasonal_forest", new Biome("overworld.legacy.seasonal_forest").setColor(10215459));
    public static final Biome OVERWORLD_LEGACY_FOREST = Biomes.register("minecraft:overworld.legacy.forest", new BiomeForestLegacy("overworld.legacy.forest").setColor(353825));
    public static final Biome OVERWORLD_LEGACY_SAVANNA = Biomes.register("minecraft:overworld.legacy.savanna", new BiomeDesertLegacy("overworld.legacy.savanna").setColor(14278691).setBlockedWeathers(Weathers.OVERWORLD_SNOW));
    public static final Biome OVERWORLD_LEGACY_SHRUBLAND = Biomes.register("minecraft:overworld.legacy.shrubland", new Biome("overworld.legacy.shrubland").setColor(10595616));
    public static final Biome OVERWORLD_LEGACY_TAIGA = Biomes.register("minecraft:overworld.legacy.taiga", new BiomeTaigaLegacy("overworld.legacy.taiga").setColor(3060051).setSurfaceSnow().setSurfaceIce());
    public static final Biome OVERWORLD_LEGACY_DESERT = Biomes.register("minecraft:overworld.legacy.desert", new BiomeDesertLegacy("overworld.legacy.desert").setColor(16421912).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM).setTopBlock(Blocks.SAND.id()).setFillerBlock(Blocks.SAND.id()));
    public static final Biome OVERWORLD_LEGACY_PLAINS = Biomes.register("minecraft:overworld.legacy.plains", new BiomeDesertLegacy("overworld.legacy.plains").setColor(16767248));
    public static final Biome OVERWORLD_LEGACY_TUNDRA = Biomes.register("minecraft:overworld.legacy.tundra", new Biome("overworld.legacy.tundra").setColor(5762041).setSurfaceSnow().setSurfaceIce());

    public static Biome register(String key, Biome biome) {
        Registries.BIOMES.register(key, biome);
        return biome;
    }

    public static void init() {
    }
}

