/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.indev;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.CavesLargeFeature;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.generate.chunk.indev.IndevWorldTheme;
import net.minecraft.core.world.generate.chunk.indev.IndevWorldType;
import net.minecraft.core.world.generate.chunk.indev.LevelGenerator;
import net.minecraft.core.world.generate.chunk.perlin.SurfaceGenerator;
import net.minecraft.core.world.generate.chunk.perlin.overworld.retro.ChunkDecoratorOverworldRetro;
import net.minecraft.core.world.generate.chunk.perlin.overworld.retro.SurfaceGeneratorOverworldRetro;
import org.jetbrains.annotations.NotNull;

public class ChunkGeneratorIndev
extends ChunkGenerator {
    @NotNull
    private final LevelGenerator lg;
    @NotNull
    private final SurfaceGenerator sg;
    @NotNull
    private final CavesLargeFeature cg;

    public ChunkGeneratorIndev(@NotNull World world, int sizeX, int sizeY, int sizeZ, @NotNull IndevWorldType worldType, @NotNull IndevWorldTheme worldTheme) {
        super(world, new ChunkDecoratorOverworldRetro(world));
        this.lg = new LevelGenerator(sizeX, sizeY, sizeZ, worldType, worldTheme);
        this.sg = new SurfaceGeneratorOverworldRetro(world);
        this.cg = new CavesLargeFeature();
    }

    @Override
    @NotNull
    protected ChunkGeneratorResult doBlockGeneration(@NotNull Chunk chunk) {
        ChunkGeneratorResult result = new ChunkGeneratorResult();
        int chunkX = chunk.pos.x;
        int chunkZ = chunk.pos.z;
        this.lg.generate(this.world, result, chunkX * 16, chunkZ * 16);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                result.setBlock(x, 0, z, Blocks.BEDROCK.id());
            }
        }
        this.sg.generateSurface(chunk, result);
        this.cg.generate(this.world, chunkX, chunkZ, result);
        return result;
    }
}

