/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.pos.ChunkSectionTilePosc;
import net.minecraft.core.world.pos.ChunkTilePosc;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3dc;
import org.joml.Vector3ic;

public class ChunkSectionTilePos
implements Externalizable,
Cloneable,
ChunkSectionTilePosc {
    public int x;
    public int y;
    public int z;

    public ChunkSectionTilePos() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public ChunkSectionTilePos(int x, int y, int z) {
        this.x = Integer.remainderUnsigned(x, 16);
        this.y = Integer.remainderUnsigned(y, 16);
        this.z = Integer.remainderUnsigned(z, 16);
    }

    public ChunkSectionTilePos(float x, float y, float z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public ChunkSectionTilePos(double x, double y, double z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public ChunkSectionTilePos(@NotNull ChunkTilePosc tilePos) {
        this(tilePos.x(), tilePos.y(), tilePos.z());
    }

    public ChunkSectionTilePos(@NotNull TilePosc tilePos) {
        this(tilePos.x(), tilePos.y(), tilePos.z());
    }

    public ChunkSectionTilePos(@NotNull Vector3dc vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public ChunkSectionTilePos(@NotNull Entity entity) {
        this(entity.x, entity.y, entity.z);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @NotNull
    public ChunkSectionTilePos set(int x, int y, int z) {
        this.x = Integer.remainderUnsigned(x, 16);
        this.y = Integer.remainderUnsigned(y, 16);
        this.z = Integer.remainderUnsigned(z, 16);
        return this;
    }

    @NotNull
    public ChunkSectionTilePos set(@NotNull ChunkTilePosc pos) {
        return this.set(pos.x(), pos.y(), pos.z());
    }

    @Override
    @NotNull
    public ChunkSectionTilePos add(int x, int y, int z, @NotNull ChunkSectionTilePos dest) {
        return dest.set(this.x + x, this.y + y, this.z + z);
    }

    @Override
    @NotNull
    public ChunkSectionTilePos add(@NotNull Vector3ic v, @NotNull ChunkSectionTilePos dest) {
        return this.add(v.x(), v.y(), v.z(), dest);
    }

    @Override
    @NotNull
    public ChunkSectionTilePos add(@NotNull Direction dir, @NotNull ChunkSectionTilePos dest) {
        return this.add(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), dest);
    }

    @NotNull
    public ChunkSectionTilePos add(int x, int y, int z) {
        return this.add(x, y, z, this);
    }

    @NotNull
    public ChunkSectionTilePos add(@NotNull Vector3ic v) {
        return this.add(v.x(), v.y(), v.z(), this);
    }

    @NotNull
    public ChunkSectionTilePos add(@NotNull Direction dir) {
        return this.add(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), this);
    }

    @Override
    @NotNull
    public ChunkSectionTilePos sub(int x, int y, int z, @NotNull ChunkSectionTilePos dest) {
        return dest.set(this.x - x, this.y - y, this.z - z);
    }

    @Override
    @NotNull
    public ChunkSectionTilePos sub(@NotNull Vector3ic v, @NotNull ChunkSectionTilePos dest) {
        return this.sub(v.x(), v.y(), v.z(), dest);
    }

    @Override
    @NotNull
    public ChunkSectionTilePos sub(@NotNull Direction dir, @NotNull ChunkSectionTilePos dest) {
        return this.sub(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), dest);
    }

    @NotNull
    public ChunkSectionTilePos sub(int x, int y, int z) {
        return this.sub(x, y, z, this);
    }

    @NotNull
    public ChunkSectionTilePos sub(@NotNull Vector3ic v) {
        return this.sub(v.x(), v.y(), v.z(), this);
    }

    @NotNull
    public ChunkSectionTilePos sub(@NotNull Direction dir) {
        return this.sub(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), this);
    }

    @Override
    public double distance(@NotNull ChunkSectionTilePosc pos) {
        int dx = this.x - pos.x();
        int dy = this.y - pos.y();
        int dz = this.z - pos.z();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double distanceSquared(@NotNull ChunkSectionTilePosc pos) {
        int dx = this.x - pos.x();
        int dy = this.y - pos.y();
        int dz = this.z - pos.z();
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    public boolean inBounds() {
        return this.x >= 0 && this.x < 16 && this.y >= 0 && this.y < 16 && this.z >= 0 && this.z < 16;
    }

    @Override
    public boolean equals(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkSectionTilePos) {
            @NotNull ChunkSectionTilePos other = (ChunkSectionTilePos)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return MathHelper.cantor(MathHelper.cantor(this.x, this.y), this.z);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.set(in.readInt(), in.readInt(), in.readInt());
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

