/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;

public class HudComponentCrosshair
extends HudComponent {
    public HudComponentCrosshair(String key, Layout layout) {
        super(key, 15, 15, layout);
    }

    @Override
    public boolean isVisible() {
        return HudComponentCrosshair.mc.gameSettings.immersiveMode.drawCrosshair() && (Integer)HudComponentCrosshair.mc.gameSettings.thirdPersonView.value == 0;
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.ONE_MINUS_DST_COLOR, BlendFactor.ONE_MINUS_SRC_COLOR);
        hud.drawGuiIcon(x, y, 15, 15, TextureRegistry.getTexture("minecraft:gui/hud/crosshair"));
        GLRenderer.disableState(State.BLEND);
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(this, xSizeScreen);
        int y = layout.getComponentY(this, ySizeScreen);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gui.drawGuiIcon(x, y, 15, 15, TextureRegistry.getTexture("minecraft:gui/hud/crosshair"));
    }
}

