/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ScaledResolution;
import net.minecraft.client.discord.RichPresenceHandlerThread;
import net.minecraft.client.enums.MusicFrequency;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.hud.component.HudComponents;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.OptionBoolean;
import net.minecraft.client.option.OptionColor;
import net.minecraft.client.option.OptionEnum;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.option.OptionFont;
import net.minecraft.client.option.OptionImmersiveMode;
import net.minecraft.client.option.OptionInteger;
import net.minecraft.client.option.OptionRange;
import net.minecraft.client.option.OptionString;
import net.minecraft.client.option.OptionTooltip;
import net.minecraft.client.option.OptionVolume;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.Fonts;
import net.minecraft.client.world.chunk.provider.SelectedProvider;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ChatVisibility;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.Util;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.ITranslatable;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.slf4j.Logger;

public class GameSettings {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String[] ANIMATIONS = new String[]{"options.animations.off", "options.animations.procedural", "options.animations.custom"};
    public final Minecraft mc;
    private final File optionsFile;
    @NotNull
    public OptionInteger windowWidth = new OptionInteger(this, "windowWidth", 854);
    @NotNull
    public OptionInteger windowHeight = new OptionInteger(this, "windowHeight", 480);
    @NotNull
    public OptionVolume masterVolume = new OptionVolume(this, "sound.master", 1.0f, SoundCategory.GUI_SOUNDS);
    @NotNull
    public OptionVolume musicVolume = new OptionVolume(this, "sound.music", 1.0f, SoundCategory.MUSIC);
    @NotNull
    public OptionVolume worldSoundsVolume = new OptionVolume(this, "sound.world", 1.0f, SoundCategory.WORLD_SOUNDS);
    @NotNull
    public OptionVolume entitySoundsVolume = new OptionVolume(this, "sound.entity", 1.0f, SoundCategory.ENTITY_SOUNDS);
    @NotNull
    public OptionVolume caveSoundsVolume = new OptionVolume(this, "sound.cave", 1.0f, SoundCategory.CAVE_SOUNDS);
    @NotNull
    public OptionVolume guiSoundsVolume = new OptionVolume(this, "sound.gui", 1.0f, SoundCategory.GUI_SOUNDS);
    @NotNull
    public OptionVolume weatherSoundsVolume = new OptionVolume(this, "sound.weather", 1.0f, SoundCategory.WEATHER_SOUNDS);
    @NotNull
    public OptionBoolean playTitleScreenMusic = new OptionBoolean(this, "playTitleScreenMusic", false);
    @NotNull
    public OptionFloat FoV = new OptionFloat(this, "fov", 0.40140846f);
    @NotNull
    public OptionFloat mouseSensitivity = new OptionFloat(this, "mouseSensitivity", 0.5f);
    @NotNull
    public OptionFloat screenPadding = new OptionFloat(this, "screenPadding", 0.0f);
    @NotNull
    public OptionFloat gamma = new OptionFloat(this, "gamma", 0.5f);
    @NotNull
    public OptionFloat brightness = new OptionFloat(this, "brightness", 0.5f);
    @NotNull
    public OptionFloat fxaa = new OptionFloat(this, "fxaa", 0.0f);
    @NotNull
    public OptionFloat controllerSensitivity = new OptionFloat(this, "controllerSensitivity", 0.5f);
    @NotNull
    public OptionFloat controllerMenuSensitivity = new OptionFloat(this, "controllerMenuSensitivity", 0.5f);
    @NotNull
    public OptionFloat controllerDeadzoneLeft = new OptionFloat(this, "controllerDeadzoneL", 0.25f);
    @NotNull
    public OptionFloat controllerDeadzoneRight = new OptionFloat(this, "controllerDeadzoneR", 0.25f);
    @NotNull
    public OptionFloat blockOutlineWidth = new OptionFloat(this, "blockOutlineWidth", 0.25f);
    @NotNull
    public OptionFloat flightSpeed = new OptionFloat(this, "flightSpeed", 0.5f);
    @NotNull
    public OptionFloat flightSmoothness = new OptionFloat(this, "flightSmoothness", 0.5f);
    @NotNull
    public OptionBoolean invertMouse = new OptionBoolean(this, "invertYMouse", false);
    @NotNull
    public OptionBoolean rawMouseInput = new OptionBoolean(this, "rawMouseInput", false);
    @NotNull
    public OptionBoolean viewBobbing = new OptionBoolean(this, "bobView", true);
    @NotNull
    public OptionRange fancyGraphics = new OptionRange(this, "fancyGraphics", 1, 2);
    @NotNull
    public OptionBoolean treeShadows = new OptionBoolean(this, "treeShadows", true);
    @NotNull
    public OptionBoolean connectedGlass = new OptionBoolean(this, "connectedGlass", false);
    @NotNull
    public OptionBoolean ambientOcclusion = new OptionBoolean(this, "ambientOcclusion", true);
    @NotNull
    public OptionBoolean items3D = new OptionBoolean(this, "3Ditems", false);
    @NotNull
    public OptionBoolean smoothCamera = new OptionBoolean(this, "smoothCamera", false);
    @NotNull
    public OptionBoolean lockCamera = new OptionBoolean(this, "lockCamera", false);
    @NotNull
    public OptionBoolean biomeWater = new OptionBoolean(this, "biomeWater", true);
    @NotNull
    public OptionBoolean vignette = new OptionBoolean(this, "vignette", true);
    @NotNull
    public OptionBoolean showPlayerList = new OptionBoolean(this, "showPlayerList", false);
    @NotNull
    public OptionBoolean slimeParticles = new OptionBoolean(this, "slimeParticles", true);
    @NotNull
    public OptionString shaderOverride = new OptionString(this, "shaderOverride", "");
    @NotNull
    public OptionBoolean autoHit = new OptionBoolean(this, "autoHit", true);
    @NotNull
    public OptionBoolean easyBridge = new OptionBoolean(this, "easyBridge", true);
    @NotNull
    public OptionBoolean foodHealthRegenOverlay = new OptionBoolean(this, "foodHealthRegenOverlay", true);
    @NotNull
    public OptionBoolean fpsInOverlay = new OptionBoolean(this, "fpsInOverlay", false);
    @NotNull
    public OptionBoolean versionInOverlay = new OptionBoolean(this, "versionInOverlay", false);
    @NotNull
    public OptionBoolean controllerSwapShoulderButtons = new OptionBoolean(this, "controllerSwapShoulderButtons", false);
    @NotNull
    public OptionBoolean controllerSwapAB = new OptionBoolean(this, "controllerSwapAB", false);
    @NotNull
    public OptionBoolean controllerSwapXY = new OptionBoolean(this, "controllerSwapXY", false);
    @NotNull
    public OptionBoolean clouds = new OptionBoolean(this, "clouds", true);
    @NotNull
    public OptionFloat cloudHeight = new OptionFloat(this, "cloudHeight", 0.0f);
    @NotNull
    public OptionFloat entityRenderDistance = new OptionFloat(this, "entityRenderDistance", 1.0f);
    @NotNull
    public OptionBoolean armorDurabilityOverlay = new OptionBoolean(this, "armorDurabilityOverlay", false);
    @NotNull
    public OptionBoolean armorProtectionOverlay = new OptionBoolean(this, "armorProtectionOverlay", true);
    @NotNull
    public OptionBoolean heldItemCountOverlay = new OptionBoolean(this, "heldItemCountOverlay", false);
    @NotNull
    public OptionBoolean pauseOnLostFocus = new OptionBoolean(this, "pauseOnLostFocus", true);
    @NotNull
    public OptionBoolean showDebugScreen = new OptionBoolean(this, "showDebugScreen", false);
    @NotNull
    public OptionBoolean showFrameTimes = new OptionBoolean(this, "showFrameTimes", false);
    @NotNull
    public OptionBoolean showItemDebugInfo = new OptionBoolean(this, "showItemDebugInfo", false);
    @NotNull
    public OptionBoolean showChunkBorders = new OptionBoolean(this, "showChunkBorders", false);
    @NotNull
    public OptionBoolean showCollisionBoxes = new OptionBoolean(this, "showCollisionBoxes", false);
    @NotNull
    public OptionBoolean swapCraftingButtons = new OptionBoolean(this, "swapCraftingButtons", false);
    @NotNull
    public OptionBoolean forceOnscreenKeyboard = new OptionBoolean(this, "forceOnscreenKeyboard", false);
    @NotNull
    public OptionEnum<PlacementMode> placementMode = new OptionEnum<PlacementMode>(this, "placementMode", PlacementMode.class, PlacementMode.DEFAULT).setIsSlider(false);
    @NotNull
    public OptionBoolean discordRichPresence = new OptionBoolean(this, "discordRichPresence", false);
    @NotNull
    public OptionImmersiveMode immersiveMode = new OptionImmersiveMode(this);
    @NotNull
    public OptionColor guiBackgroundColor = new OptionColor(this, "guiBackgroundColor", new Color().setARGB(-1072689136));
    @NotNull
    public OptionEnum<Difficulty> difficulty = new OptionEnum<Difficulty>(this, "difficulty", Difficulty.class, Difficulty.NORMAL);
    @NotNull
    public OptionInteger thirdPersonView = new OptionInteger(this, "thirdPersonView", 0);
    @NotNull
    public OptionRange renderDistance = new OptionRange(this, "renderDistance", 12, 2, 32);
    @NotNull
    public OptionBoolean enableVsync = new OptionBoolean(this, "enableVsync", false);
    @NotNull
    public OptionEnum<ChatVisibility> chatVisibility = new OptionEnum<ChatVisibility>(this, "chatVisibility", ChatVisibility.class, ChatVisibility.SHOW_ALL);
    @NotNull
    public OptionRange customFpsLimit = new OptionRange(this, "customFpsLimit", 165, 301);
    @NotNull
    public OptionInteger guiScale = new OptionInteger(this, "guiScale", 0);
    @NotNull
    public OptionInteger overlayMode = new OptionInteger(this, "overlayMode", 0);
    @NotNull
    public OptionInteger rotationOverlayMode = new OptionInteger(this, "rotationOverlayMode", 0);
    @NotNull
    public OptionRange animations = new OptionRange(this, "animations", 2, 3);
    @NotNull
    public OptionBoolean customAnimations = new OptionBoolean(this, "customAnimations", true);
    @NotNull
    public OptionInteger playerListPosition = new OptionInteger(this, "playerListPosition", 2);
    @NotNull
    public OptionBoolean heldItemTooltips = new OptionBoolean(this, "heldItemTooltips", true);
    @NotNull
    public OptionFloat colorCorrection = new OptionFloat(this, "colorCorrection", 0.5f);
    @NotNull
    public OptionBoolean sneakToggle = new OptionBoolean(this, "sneakToggle", false);
    @NotNull
    public OptionFloat autosaveTimer = new OptionFloat(this, "autosaveTimer", 0.041666668f);
    @NotNull
    public OptionBoolean enableItemDragging = new OptionBoolean(this, "enableItemDragging", true);
    @NotNull
    public OptionRange bloom = new OptionRange(this, "bloom", 0, 3);
    @NotNull
    public OptionEnum<RenderScale> renderScale = new OptionEnum<RenderScale>(this, "renderScale", RenderScale.class, RenderScale.SCALE_100);
    @NotNull
    public OptionBoolean heatHaze = new OptionBoolean(this, "heatHaze", false);
    @NotNull
    public OptionBoolean alphaMenu = new OptionBoolean(this, "old", false);
    @NotNull
    public OptionBoolean enableItemClumping = new OptionBoolean(this, "enableItemClumping", true);
    @NotNull
    public OptionEnum<DescriptionPromptEnum> itemDescriptions = new OptionEnum<DescriptionPromptEnum>(this, "itemDescriptions", DescriptionPromptEnum.class, DescriptionPromptEnum.PROMPT);
    @NotNull
    public OptionBoolean turnWithVehicle = new OptionBoolean(this, "turnWithVehicle", true);
    @NotNull
    public OptionBoolean disableCrashHandler = new OptionBoolean(this, "disableCrashHandler", false);
    @NotNull
    public OptionEnum<SelectedProvider> enableThreadedChunkProvider = new OptionEnum<SelectedProvider>(this, "enableThreadedChunkProvider", SelectedProvider.class, SelectedProvider.THREADED);
    @NotNull
    public OptionBoolean musicToasts = new OptionBoolean(this, "musicToasts", true);
    @NotNull
    public OptionEnum<MusicFrequency> musicFrequency = new OptionEnum<MusicFrequency>(this, "musicFrequency", MusicFrequency.class, MusicFrequency.DEFAULT);
    @NotNull
    public OptionBoolean enableDevResourceLoading = new OptionBoolean(this, "enableDevResourceLoading", false);
    @NotNull
    public OptionBoolean downloadSoundfiles = new OptionBoolean(this, "downloadSoundfiles", true);
    @NotNull
    public OptionBoolean allowSoundOverrides = new OptionBoolean(this, "allowSoundOverrides", false);
    @NotNull
    public OptionBoolean loadAllSounds = new OptionBoolean(this, "loadAllSounds", false);
    @NotNull
    public OptionBoolean overlayShowCoords = new OptionBoolean(this, "overlayShowCoords", true);
    @NotNull
    public OptionBoolean overlayShowDirection = new OptionBoolean(this, "overlayShowDirection", true);
    @NotNull
    public OptionBoolean overlayShowTime = new OptionBoolean(this, "overlayShowTime", true);
    @NotNull
    public OptionBoolean overlayShowSeason = new OptionBoolean(this, "overlayShowSeason", true);
    @NotNull
    public OptionBoolean overlayShowWeather = new OptionBoolean(this, "overlayShowWeather", true);
    @NotNull
    public OptionBoolean overlayShowBiome = new OptionBoolean(this, "overlayShowBiome", true);
    @NotNull
    public @NotNull OptionBoolean @NotNull [] overlayElements = new OptionBoolean[]{this.overlayShowCoords, this.overlayShowDirection, this.overlayShowTime, this.overlayShowSeason, this.overlayShowWeather, this.overlayShowBiome};
    @NotNull
    public OptionString lastServer = new OptionString(this, "lastServer", "");
    @NotNull
    public OptionString skin = new OptionString(this, "skin", "Default");
    @NotNull
    public OptionString selectedController = new OptionString(this, "selectedController", "");
    @NotNull
    public OptionString language = new OptionString(this, "language", "en_US");
    @NotNull
    public OptionRange mipmapLevels = new OptionRange(this, "mipmapLevels", 0, 5);
    @NotNull
    public OptionEnum<MipmapType> mipmapType = new OptionEnum<MipmapType>(this, "mipmapType", MipmapType.class, MipmapType.SMOOTH);
    @NotNull
    public OptionBoolean fovModification = new OptionBoolean(this, "fov.modification", true);
    @NotNull
    public OptionBoolean screenMotionEffects = new OptionBoolean(this, "screen.motion.effects", true);
    @NotNull
    public OptionBoolean fullscreen = new OptionBoolean(this, "fullscreen", Minecraft.isClientASteamDeck());
    @NotNull
    public OptionBoolean borderlessFullscreen = new OptionBoolean(this, "borderlessFullscreen", true);
    @NotNull
    public OptionBoolean startInFullscreen = new OptionBoolean(this, "startInFullscreen", true);
    @NotNull
    public OptionTooltip tooltipStyle = new OptionTooltip(this, "tooltipStyle", "default");
    @NotNull
    public OptionFont font = new OptionFont(this, "font", Fonts.DEFAULT);
    @NotNull
    public OptionEnum<LightmapStyle> lightmapStyle = new OptionEnum<LightmapStyle>(this, "lightmapStyle", LightmapStyle.class, LightmapStyle.GRAY);
    @NotNull
    public OptionBoolean customLightmap = new OptionBoolean(this, "customLightmap", true);
    @NotNull
    public OptionBoolean fog = new OptionBoolean(this, "fog", true);
    @NotNull
    public OptionBoolean hideUndiscoveredItems = new OptionBoolean(this, "hideUndiscoveredItems", true);
    @NotNull
    public OptionBoolean muteOnLostFocus = new OptionBoolean(this, "muteOnLostFocus", false);
    @NotNull
    public OptionBoolean aurora = new OptionBoolean(this, "aurora", true);
    @NotNull
    public OptionBoolean mobVariants = new OptionBoolean(this, "mobVariants", true);
    @NotNull
    public OptionEnum<Colorblindness> colorblindnessFix = new OptionEnum<Colorblindness>(this, "colorblindnessFix", Colorblindness.class, Colorblindness.NONE);
    @NotNull
    public OptionBoolean subtitles = new OptionBoolean(this, "subtitles", false);
    @NotNull
    public OptionBoolean developerMode = new OptionBoolean(this, "developerMode", false);
    @NotNull
    public OptionBoolean viewSupportMode = new OptionBoolean(this, "viewSupportMode", false);
    @NotNull
    public OptionBoolean enableHolidayTextures = new OptionBoolean(this, "enableHolidayTextures", true);
    @NotNull
    public OptionBoolean dynamicCursor = new OptionBoolean(this, "dynamicCursor", true);
    @NotNull
    public OptionBoolean devModels = new OptionBoolean(this, "devModels", true);
    @NotNull
    public OptionBoolean doJCECheck = new OptionBoolean(this, "doJCECheck", true);
    @NotNull
    public OptionString uuidServer = new OptionString(this, "uuidServer", "https://api.minecraftservices.com/minecraft/profile/lookup/name/%s");
    @NotNull
    public OptionBoolean playerLeftHanded = new OptionBoolean(this, "player.left.handed", false);
    @NotNull
    public OptionBoolean playerCape = new OptionBoolean(this, "player.cape", true);
    @NotNull
    public OptionBoolean playerHat = new OptionBoolean(this, "player.hat", true);
    @NotNull
    public OptionBoolean playerJacket = new OptionBoolean(this, "player.jacket", true);
    @NotNull
    public OptionBoolean playerSleeveLeft = new OptionBoolean(this, "player.sleeve.left", true);
    @NotNull
    public OptionBoolean playerSleeveRight = new OptionBoolean(this, "player.sleeve.right", true);
    @NotNull
    public OptionBoolean playerPantLeft = new OptionBoolean(this, "player.pant.left", true);
    @NotNull
    public OptionBoolean playerPantRight = new OptionBoolean(this, "player.pant.right", true);
    @NotNull
    public OptionBoolean playerDevModel = new OptionBoolean(this, "player.devmodel", true);
    @NotNull
    public OptionEnum<Player.PlayerConfig.HurtSound> playerHurtSound = new OptionEnum<Player.PlayerConfig.HurtSound>(this, "player.hurtsound", Player.PlayerConfig.HurtSound.class, Player.PlayerConfig.HurtSound.MASCULINE);
    @NotNull
    public KeyBinding keyAttack = new KeyBinding("key.attack").setDefault(InputDevice.mouse, 0);
    @NotNull
    public KeyBinding keyInteract = new KeyBinding("key.interact").setDefault(InputDevice.mouse, 1);
    @NotNull
    public KeyBinding keyPickBlock = new KeyBinding("key.pickBlock").setDefault(InputDevice.mouse, 2);
    @NotNull
    public KeyBinding keySortInventory = new KeyBinding("key.sortInventory").setDefault(InputDevice.mouse, 2);
    @NotNull
    public KeyBinding keyForward = new KeyBinding("key.forward").setDefault(InputDevice.keyboard, Keyboard.KEY_W);
    @NotNull
    public KeyBinding keyLeft = new KeyBinding("key.left").setDefault(InputDevice.keyboard, Keyboard.KEY_A);
    @NotNull
    public KeyBinding keyBack = new KeyBinding("key.back").setDefault(InputDevice.keyboard, Keyboard.KEY_S);
    @NotNull
    public KeyBinding keyRight = new KeyBinding("key.right").setDefault(InputDevice.keyboard, Keyboard.KEY_D);
    @NotNull
    public KeyBinding keyJump = new KeyBinding("key.jump").setDefault(InputDevice.keyboard, Keyboard.KEY_SPACE);
    @NotNull
    public KeyBinding keyInventory = new KeyBinding("key.inventory").setDefault(InputDevice.keyboard, Keyboard.KEY_E);
    @NotNull
    public KeyBinding keyDrop = new KeyBinding("key.drop").setDefault(InputDevice.keyboard, Keyboard.KEY_Q);
    @NotNull
    public KeyBinding keyChat = new KeyBinding("key.chat").setDefault(InputDevice.keyboard, Keyboard.KEY_T);
    @NotNull
    public KeyBinding keyCommand = new KeyBinding("key.command").setDefault(InputDevice.keyboard, Keyboard.KEY_SLASH);
    @NotNull
    public KeyBinding keyToggleFog = new KeyBinding("key.fog");
    @NotNull
    public KeyBinding keyToggleGamma = new KeyBinding("key.gamma");
    @NotNull
    public KeyBinding keySneak = new KeyBinding("key.sneak").setDefault(InputDevice.keyboard, Keyboard.KEY_LSHIFT);
    @NotNull
    public KeyBinding keyFly = new KeyBinding("key.fly").setDefault(InputDevice.keyboard, Keyboard.KEY_LCONTROL);
    @NotNull
    public KeyBinding keyGuidebook = new KeyBinding("key.guidebook").setDefault(InputDevice.keyboard, Keyboard.KEY_R);
    @NotNull
    public KeyBinding keyDescription = new KeyBinding("key.description").setDefault(InputDevice.keyboard, Keyboard.KEY_LCONTROL);
    @NotNull
    public KeyBinding keyShowRecipe = new KeyBinding("key.showRecipe").setDefault(InputDevice.keyboard, Keyboard.KEY_R);
    @NotNull
    public KeyBinding keyShowUsage = new KeyBinding("key.showUsage").setDefault(InputDevice.keyboard, Keyboard.KEY_U);
    @NotNull
    public KeyBinding keyHotBarLeft = new KeyBinding("key.hotbar.left").setDefault(InputDevice.keyboard, Keyboard.KEY_COMMA);
    @NotNull
    public KeyBinding keyHotBarRight = new KeyBinding("key.hotbar.right").setDefault(InputDevice.keyboard, Keyboard.KEY_PERIOD);
    @NotNull
    public KeyBinding keyHotBarSwitch = new KeyBinding("key.hotbar.switch").setDefault(InputDevice.keyboard, Keyboard.KEY_TAB);
    @NotNull
    public KeyBinding keyHideGui = new KeyBinding("key.immersiveMode").setDefault(InputDevice.keyboard, Keyboard.KEY_F1);
    @NotNull
    public KeyBinding keyScreenshot = new KeyBinding("key.screenshot").setDefault(InputDevice.keyboard, Keyboard.KEY_F2);
    @NotNull
    public KeyBinding keyToggleDebug = new KeyBinding("key.toggleDebug").setDefault(InputDevice.keyboard, Keyboard.KEY_F3);
    @NotNull
    public KeyBinding keyToggleOverlay = new KeyBinding("key.toggleOverlay").setDefault(InputDevice.keyboard, Keyboard.KEY_F4);
    @NotNull
    public KeyBinding keySwitchPerspective = new KeyBinding("key.switchPerspective").setDefault(InputDevice.keyboard, Keyboard.KEY_F5);
    @NotNull
    public KeyBinding keyCinematicCamera = new KeyBinding("key.cinematicCamera").setDefault(InputDevice.keyboard, Keyboard.KEY_F8);
    @NotNull
    public KeyBinding keyFullScreen = new KeyBinding("key.fullscreen").setDefault(InputDevice.keyboard, Keyboard.KEY_F11);
    @NotNull
    public KeyBinding keyReleaseCursor = new KeyBinding("key.debug.releasecursor").setDefault(InputDevice.keyboard, Keyboard.KEY_F12);
    @NotNull
    public KeyBinding keyHotBarSlot1 = new KeyBinding("key.hotbar.1").setDefault(InputDevice.keyboard, Keyboard.KEY_1);
    @NotNull
    public KeyBinding keyHotBarSlot2 = new KeyBinding("key.hotbar.2").setDefault(InputDevice.keyboard, Keyboard.KEY_2);
    @NotNull
    public KeyBinding keyHotBarSlot3 = new KeyBinding("key.hotbar.3").setDefault(InputDevice.keyboard, Keyboard.KEY_3);
    @NotNull
    public KeyBinding keyHotBarSlot4 = new KeyBinding("key.hotbar.4").setDefault(InputDevice.keyboard, Keyboard.KEY_4);
    @NotNull
    public KeyBinding keyHotBarSlot5 = new KeyBinding("key.hotbar.5").setDefault(InputDevice.keyboard, Keyboard.KEY_5);
    @NotNull
    public KeyBinding keyHotBarSlot6 = new KeyBinding("key.hotbar.6").setDefault(InputDevice.keyboard, Keyboard.KEY_6);
    @NotNull
    public KeyBinding keyHotBarSlot7 = new KeyBinding("key.hotbar.7").setDefault(InputDevice.keyboard, Keyboard.KEY_7);
    @NotNull
    public KeyBinding keyHotBarSlot8 = new KeyBinding("key.hotbar.8").setDefault(InputDevice.keyboard, Keyboard.KEY_8);
    @NotNull
    public KeyBinding keyHotBarSlot9 = new KeyBinding("key.hotbar.9").setDefault(InputDevice.keyboard, Keyboard.KEY_9);
    @NotNull
    public KeyBinding keyLookLeft = new KeyBinding("key.look.left").setDefault(InputDevice.keyboard, Keyboard.KEY_LEFT);
    @NotNull
    public KeyBinding keyLookRight = new KeyBinding("key.look.right").setDefault(InputDevice.keyboard, Keyboard.KEY_RIGHT);
    @NotNull
    public KeyBinding keyLookUp = new KeyBinding("key.look.up").setDefault(InputDevice.keyboard, Keyboard.KEY_UP);
    @NotNull
    public KeyBinding keyLookDown = new KeyBinding("key.look.down").setDefault(InputDevice.keyboard, Keyboard.KEY_DOWN);
    @NotNull
    public KeyBinding keyCenterView = new KeyBinding("key.look.center").setDefault(InputDevice.keyboard, Keyboard.KEY_END);
    @NotNull
    public KeyBinding keyZoom = new KeyBinding("key.zoom").setDefault(InputDevice.keyboard, Keyboard.KEY_C);
    @NotNull
    public KeyBinding keyPlayerList = new KeyBinding("key.playerList").setDefault(InputDevice.keyboard, Keyboard.KEY_L);
    @NotNull
    public KeyBinding keyPhotoMode = new KeyBinding("key.photoMode").setDefault(InputDevice.keyboard, Keyboard.KEY_P);
    @NotNull
    public KeyBinding keyLockRotation = new KeyBinding("key.lockRotation").setDefault(InputDevice.keyboard, Keyboard.KEY_Z);
    @NotNull
    public KeyBinding keyAutoWalk = new KeyBinding("key.autoWalk");
    @NotNull
    public KeyBinding keyEasyBridge = new KeyBinding("key.easyBridge");
    @NotNull
    public KeyBinding keySprint = new KeyBinding("key.sprint");
    @NotNull
    public KeyBinding keyOpenAchievements = new KeyBinding("key.openAchievements");
    @NotNull
    public KeyBinding keyOpenStatistics = new KeyBinding("key.openStatistics");
    @NotNull
    public KeyBinding keyShowConsole = new KeyBinding("key.showConsole").setDefault(InputDevice.keyboard, Keyboard.KEY_GRAVE);
    @NotNull
    public List<KeyBinding> debugsKeys = new ArrayList<KeyBinding>();
    @NotNull
    public KeyBinding keyReload = new KeyBinding("key.debug.reload").setDefault(InputDevice.keyboard, Keyboard.KEY_R);
    @NotNull
    public KeyBinding keySwitchGamemode = new KeyBinding("key.debug.gamemode").setDefault(InputDevice.keyboard, Keyboard.KEY_N);
    @NotNull
    public KeyBinding keyDumpTextures = new KeyBinding("key.debug.dumptextures").setDefault(InputDevice.keyboard, Keyboard.KEY_D);
    @NotNull
    public KeyBinding keyFullbright = new KeyBinding("key.debug.fullbright").setDefault(InputDevice.keyboard, Keyboard.KEY_F);
    @NotNull
    public KeyBinding keyLightmaps = new KeyBinding("key.debug.lightmap").setDefault(InputDevice.keyboard, Keyboard.KEY_L);
    @NotNull
    public KeyBinding keyCollisionBoxes = new KeyBinding("key.debug.collision").setDefault(InputDevice.keyboard, Keyboard.KEY_B);
    @NotNull
    public KeyBinding keyChunkBorders = new KeyBinding("key.debug.chunkborders").setDefault(InputDevice.keyboard, Keyboard.KEY_G);
    @NotNull
    public KeyBinding keyClearChat = new KeyBinding("key.debug.clearchat").setDefault(InputDevice.keyboard, Keyboard.KEY_C);
    @NotNull
    public KeyBinding keyPauseLostFocus = new KeyBinding("key.debug.pauseFocus").setDefault(InputDevice.keyboard, Keyboard.KEY_P);
    @NotNull
    public KeyBinding keyToggleItemInfo = new KeyBinding("key.debug.iteminfo").setDefault(InputDevice.keyboard, Keyboard.KEY_H);
    @NotNull
    public KeyBinding keyReloadChunks = new KeyBinding("key.debug.reloadchunks").setDefault(InputDevice.keyboard, Keyboard.KEY_A);
    @NotNull
    public KeyBinding keySmoothLighting = new KeyBinding("key.debug.smoothlighting").setDefault(InputDevice.keyboard, Keyboard.KEY_S);
    @NotNull
    public KeyBinding keyShowShortcuts = new KeyBinding("key.debug.shortcuts").setDefault(InputDevice.keyboard, Keyboard.KEY_Q);
    @NotNull
    public KeyBinding keyToggleTextureAtlas = new KeyBinding("key.debug.textureAtlas");
    @NotNull
    public KeyBinding keyLoadChunksQuickly = new KeyBinding("key.debug.loadChunksQuickly");
    @NotNull
    public static final @NotNull List<@NotNull KeyBinding> keys = new ArrayList<KeyBinding>();
    @NotNull
    public static final @NotNull List<@NotNull Option<?>> options = new ArrayList();

    @NotNull
    public @NotNull List<@NotNull Option<?>> getAllOptions() {
        return options;
    }

    public KeyBinding getKey(int i) {
        return keys.get(i);
    }

    public String getKeyBindName(int id) {
        return I18n.getInstance().translateKey(this.getKey(id).getId());
    }

    public GameSettings(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.optionsFile = new File(file, "options.txt");
        this.debugsKeys.add(this.keyShowShortcuts);
        this.debugsKeys.add(this.keyReload);
        this.debugsKeys.add(this.keySwitchGamemode);
        this.debugsKeys.add(this.keyDumpTextures);
        this.debugsKeys.add(this.keyFullbright);
        this.debugsKeys.add(this.keyLightmaps);
        this.debugsKeys.add(this.keyCollisionBoxes);
        this.debugsKeys.add(this.keyChunkBorders);
        this.debugsKeys.add(this.keyClearChat);
        this.debugsKeys.add(this.keyPauseLostFocus);
        this.debugsKeys.add(this.keyToggleItemInfo);
        this.debugsKeys.add(this.keyReloadChunks);
        this.debugsKeys.add(this.keySmoothLighting);
    }

    public void init() {
        this.loadOptions();
        this.saveOptions();
    }

    @NotNull
    public String getDisplayString(Option<?> option) {
        if (option == null) {
            return "";
        }
        I18n trans = I18n.getInstance();
        if (option instanceof OptionFloat) {
            OptionFloat optionFloat = (OptionFloat)option;
            float value = ((Float)optionFloat.value).floatValue();
            if (option == this.brightness) {
                int percent = (int)(value * 200.0f);
                if (percent == 0) {
                    return trans.translateKey("options.brightness.min");
                }
                if (percent == 100) {
                    return trans.translateKey("options.brightness.default");
                }
                if (percent == 200) {
                    return trans.translateKey("options.brightness.max");
                }
                return percent + "%";
            }
            if (option == this.mouseSensitivity) {
                if (value == 0.0f) {
                    return trans.translateKey("options.mouseSensitivity.min");
                }
                if (value == 1.0f) {
                    return trans.translateKey("options.mouseSensitivity.max");
                }
                return (int)(value * 200.0f) + "%";
            }
            if (option == this.FoV) {
                if (value == 0.0f) {
                    return trans.translateKey("options.fov.min");
                }
                if (value == 1.0f) {
                    return trans.translateKey("options.fov.max");
                }
                return (int)(value * 100.0f + 30.0f) + "\u00b0";
            }
            if (option == this.screenPadding) {
                int percent = (int)(value * 100.0f);
                return percent + "%";
            }
            if (option == this.gamma) {
                int percent = (int)(value * 200.0f);
                return percent + "%";
            }
            if (option == this.autosaveTimer) {
                int timer = (int)(value * 24.0f);
                if (timer == 0) {
                    return trans.translateKey("options.autosaveTimer.off");
                }
                return timer * 5 + " seconds";
            }
            if (option == this.cloudHeight) {
                int percent = (int)(value * 100.0f + 100.0f);
                if (percent == 100) {
                    return trans.translateKey("options.cloudHeight.default");
                }
                return percent + "%";
            }
            if (option == this.entityRenderDistance) {
                int percent = MathHelper.round(value * 100.0f);
                if (percent == 100) {
                    return trans.translateKey("options.entityRenderDistance.default");
                }
                return percent + "%";
            }
            if (value == 0.0f) {
                return trans.translateKey("options.off");
            }
            return (int)(value * 100.0f) + "%";
        }
        if (option == this.guiScale) {
            if ((Integer)this.guiScale.value == 0) {
                return trans.translateKey("options.guiScale.auto");
            }
            return String.valueOf(this.guiScale.value) + "x";
        }
        if (option == this.customFpsLimit) {
            int value = (Integer)this.customFpsLimit.value;
            int maxValue = 300;
            if (((Boolean)this.enableVsync.value).booleanValue()) {
                return String.valueOf(this.mc.gameWindow.getFrequency());
            }
            if (value > maxValue) {
                this.customFpsLimit.set(maxValue);
            }
            if (value < 15) {
                this.customFpsLimit.set(0);
                return trans.translateKey("options.customFpsLimit.unlimited");
            }
        }
        if (option == this.animations) {
            return trans.translateKey(ANIMATIONS[(Integer)this.animations.value]);
        }
        if (option == this.fancyGraphics) {
            if ((Integer)this.fancyGraphics.value == 1) {
                return trans.translateKey("options.graphics.fancy");
            }
            return trans.translateKey("options.graphics.fast");
        }
        if (option == this.lightmapStyle) {
            return trans.translateKey(((LightmapStyle)((Object)this.lightmapStyle.value)).getTranslationKey());
        }
        if (option == this.bloom) {
            if ((Integer)this.bloom.value == 0) {
                return trans.translateKey("options.off");
            }
            if ((Integer)this.bloom.value == 1) {
                return trans.translateKey("options.bloom.low");
            }
            if ((Integer)this.bloom.value == 2) {
                return trans.translateKey("options.bloom.high");
            }
        }
        if (option == this.tooltipStyle) {
            TooltipElement.Style style = TooltipElement.styleMap.get(this.tooltipStyle.value);
            if (style != null) {
                return trans.translateKey(style.translationKey);
            }
            return "Unknown";
        }
        if (option == this.font) {
            return trans.translateKey("options.font." + ((Font)this.font.value).getKey());
        }
        if (option instanceof OptionBoolean) {
            Boolean flag = (Boolean)option.value;
            if (flag.booleanValue()) {
                return trans.translateKey("options.on");
            }
            return trans.translateKey("options.off");
        }
        if (option instanceof OptionEnum) {
            String key;
            OptionEnum optionEnum = (OptionEnum)option;
            if (optionEnum.value instanceof ITranslatable) {
                ITranslatable translatable = (ITranslatable)optionEnum.value;
                key = translatable.getTranslationKey();
            } else {
                key = ((Enum)optionEnum.value).toString().toLowerCase();
            }
            return trans.translateKey("options." + optionEnum.name + "." + key);
        }
        return Util.emptyStringIfNull(option.value.toString());
    }

    public void optionChanged(Option<?> option) {
        int max;
        if (option == null) {
            return;
        }
        if (option == this.difficulty && this.mc.currentWorld != null) {
            this.mc.currentWorld.setDifficulty((Difficulty)((Object)this.difficulty.value), false);
        }
        if (option == this.renderDistance) {
            if (this.mc.currentScreen instanceof ScreenOptions) {
                ScreenOptions.queueReload = true;
            } else {
                this.mc.renderGlobal.allChanged();
            }
        }
        if (option == this.playerLeftHanded && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setLeftHand((Boolean)this.playerLeftHanded.value);
        }
        if (option == this.playerCape && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setCape((Boolean)this.playerCape.value);
        }
        if (option == this.playerHat && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setHat((Boolean)this.playerHat.value);
        }
        if (option == this.playerJacket && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setJacket((Boolean)this.playerJacket.value);
        }
        if (option == this.playerSleeveLeft && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setSleeveLeft((Boolean)this.playerSleeveLeft.value);
        }
        if (option == this.playerSleeveRight && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setSleeveRight((Boolean)this.playerSleeveRight.value);
        }
        if (option == this.playerPantLeft && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setPantLeft((Boolean)this.playerPantLeft.value);
        }
        if (option == this.playerPantRight && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setPantRight((Boolean)this.playerPantRight.value);
        }
        if (option == this.playerDevModel && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setDevModelEnabled((Boolean)this.playerDevModel.value);
        }
        if (option == this.playerHurtSound && this.mc.thePlayer != null) {
            this.mc.thePlayer.playerConfig.setHurtSound((Player.PlayerConfig.HurtSound)((Object)this.playerHurtSound.value));
        }
        if (option == this.enableVsync) {
            this.mc.gameWindow.setVsync((Boolean)this.enableVsync.value);
        }
        if (option == this.fancyGraphics) {
            this.mc.renderGlobal.allChanged();
        }
        if (option == this.ambientOcclusion) {
            this.mc.renderGlobal.allChanged();
        }
        if (option == this.connectedGlass) {
            this.mc.renderGlobal.allChanged();
        }
        if (option == this.biomeWater) {
            this.mc.renderGlobal.allChanged();
            this.mc.textureManager.updateDynamicTextures(false);
        }
        if (option == this.treeShadows) {
            this.mc.renderGlobal.allChanged();
        }
        if (option == this.placementMode && this.mc.thePlayer != null) {
            this.mc.thePlayer.syncPlacementMode();
        }
        if (option == this.animations || option == this.customAnimations) {
            this.mc.textureManager.refreshTexturesAndDisplayErrors();
            this.mc.textureManager.updateDynamicTextures(false);
            this.mc.renderGlobal.allChanged();
        }
        if (option == this.fullscreen) {
            this.mc.gameWindow.updateWindowState();
        }
        if (option == this.borderlessFullscreen && ((Boolean)this.fullscreen.value).booleanValue()) {
            this.mc.gameWindow.updateWindowState();
        }
        if (option == this.guiScale) {
            ScaledResolution cfr_ignored_0 = this.mc.resolution;
            max = ScaledResolution.getMaxScale(this.mc.gameWindow.getWidthScreenCoords(), this.mc.gameWindow.getHeightScreenCoords());
            this.guiScale.value = ((Integer)this.guiScale.value + max) % max;
            this.mc.resolution.setScale((Integer)this.guiScale.value);
            if (this.mc.currentScreen != null) {
                this.mc.currentScreen.opened(this.mc.resolution.getScaledWidthScreenCoords(), this.mc.resolution.getScaledHeightScreenCoords());
            }
        }
        if (option == this.mipmapType || option == this.mipmapLevels) {
            this.mc.textureManager.refreshTexturesAndDisplayErrors();
        }
        if (option == this.autosaveTimer) {
            max = 24;
            this.autosaveTimer.value = Float.valueOf((((Float)this.autosaveTimer.value).floatValue() + (float)max) % (float)max);
        }
        if (option == this.discordRichPresence && ((Boolean)this.discordRichPresence.value).booleanValue() && this.mc.rpcThread == null) {
            this.mc.rpcThread = new RichPresenceHandlerThread(this.mc);
            this.mc.rpcThread.setName("Discord RPC Thread");
            this.mc.rpcThread.start();
        }
        if (option == this.language && this.mc.currentScreen != null) {
            this.mc.currentScreen.opened(this.mc.resolution.getScaledWidthScreenCoords(), this.mc.resolution.getScaledHeightScreenCoords());
        }
        if (option == this.customLightmap) {
            this.mc.worldRenderer.lightmapHelper.setup();
        }
        if (option == this.rawMouseInput) {
            this.mc.mouseInput.setRawInput((Boolean)this.rawMouseInput.value);
        }
        if (option == this.enableHolidayTextures) {
            this.mc.textureManager.refreshTexturesAndDisplayErrors();
            this.mc.renderGlobal.allChanged();
        }
        if (option == this.musicFrequency) {
            this.mc.sndManager.resetMusicTicks();
        }
    }

    public void loadOptions() {
        HudComponents.DEFAULT_LAYOUT = HudComponents.INSTANCE.toSettingsString();
        if (!this.optionsFile.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.optionsFile));
            block4: while ((line = br.readLine()) != null) {
                try {
                    int i = line.indexOf(58);
                    String key = line.substring(0, i);
                    String value = line.substring(i + 1);
                    if (key.equals("hudLayout")) {
                        HudComponents.INSTANCE.fromSettingsString(value);
                        continue;
                    }
                    for (Option<?> option : this.getAllOptions()) {
                        if (!option.name.equalsIgnoreCase(key)) continue;
                        option.parse(value);
                        continue block4;
                    }
                    for (KeyBinding keyBinding : keys) {
                        if (!key.equals("key_" + keyBinding.getId())) continue;
                        keyBinding.fromOptionsString(value);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Skipping bad option: {}", (Object)line, (Object)e);
                }
            }
            br.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load options", e);
        }
    }

    public void saveOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            for (Option<?> option : this.getAllOptions()) {
                printwriter.println(option.name + ":" + option.getValueString());
            }
            for (KeyBinding key : keys) {
                printwriter.println("key_" + key.getId() + ":" + key.toOptionsString());
            }
            String hudComponentsString = HudComponents.INSTANCE.toSettingsString();
            if (hudComponentsString != null) {
                printwriter.println("hudLayout:" + hudComponentsString);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save options", exception);
        }
    }
}

