/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;
import net.minecraft.core.world.pos.ChunkSectionTilePos;
import net.minecraft.core.world.pos.ChunkSectionTilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class ChunkSection {
    public static final int SECTION_SIZE_Y = 16;
    @NotNull
    public final Chunk chunk;
    public int yPosition;
    public short @Nullable [] blocks;
    @Nullable
    public ChunkUnsignedByteArray data = null;
    @Nullable
    public ChunkNibbleArray skylightMap = null;
    @Nullable
    public ChunkNibbleArray blocklightMap = null;
    public byte @NotNull [] biome = new byte[512];
    @NotNull
    public @NotNull List<@NotNull Entity> entities = new ArrayList<Entity>();

    public ChunkSection(@NotNull Chunk chunk, int yPosition) {
        this.chunk = chunk;
        this.yPosition = yPosition;
    }

    public void init() {
        this.data = new ChunkUnsignedByteArray(16, 16, 16);
        this.skylightMap = new ChunkNibbleArray(16, 16, 16);
        this.blocklightMap = new ChunkNibbleArray(16, 16, 16);
        Arrays.fill(this.biome, (byte)-1);
    }

    public static int makeBlockIndex(@NotNull ChunkSectionTilePosc sectionPos) {
        return sectionPos.y() * 16 * 16 + sectionPos.z() * 16 + sectionPos.x();
    }

    @Deprecated
    public static int makeBlockIndex(int x, int y, int z) {
        return ChunkSection.makeBlockIndex(new ChunkSectionTilePos(x, y, z));
    }

    public static int makeBiomeIndex(@NotNull ChunkSectionTilePosc sectionPos) {
        return (sectionPos.y() >> 3) * 16 * 16 + sectionPos.z() * 16 + sectionPos.x();
    }

    @Deprecated
    public static int makeBiomeIndex(int x, int y, int z) {
        return ChunkSection.makeBiomeIndex(new ChunkSectionTilePos(x, y, z));
    }

    public int getBlockId(@NotNull ChunkSectionTilePosc sectionPos) {
        if (!sectionPos.inBounds() || this.blocks == null) {
            return 0;
        }
        return this.blocks[ChunkSection.makeBlockIndex(sectionPos)] & 0x3FFF;
    }

    @Deprecated
    public int getBlock(int x, int y, int z) {
        return this.getBlockId(new ChunkSectionTilePos(x, y, z));
    }

    public void setBlockId(@NotNull ChunkSectionTilePosc sectionPos, int id) {
        assert (Blocks.getBlock(id) != null);
        if (!sectionPos.inBounds() || this.blocks == null && id == Blocks.AIR.id()) {
            return;
        }
        if (this.blocks == null) {
            this.blocks = new short[4096];
        }
        this.blocks[ChunkSection.makeBlockIndex((ChunkSectionTilePosc)sectionPos)] = (short)(id & 0x3FFF);
    }

    @Deprecated
    public void setBlock(int x, int y, int z, int id) {
        this.setBlockId(new ChunkSectionTilePos(x, y, z), id);
    }

    public int getData(@NotNull ChunkSectionTilePosc sectionPos) {
        if (!sectionPos.inBounds() || this.blocks == null || this.data == null) {
            return 0;
        }
        return this.data.get(sectionPos.x(), sectionPos.y(), sectionPos.z());
    }

    @Deprecated
    public int getData(int x, int y, int z) {
        return this.getData(new ChunkSectionTilePos(x, y, z));
    }

    public void setData(@NotNull ChunkSectionTilePosc sectionPos, int data) {
        if (!sectionPos.inBounds() || this.blocks == null) {
            return;
        }
        if (this.data == null) {
            this.data = new ChunkUnsignedByteArray(16, 16, 16);
        }
        this.data.set(sectionPos.x(), sectionPos.y(), sectionPos.z(), data);
    }

    @Deprecated
    public void setData(int x, int y, int z, int data) {
        this.setData(new ChunkSectionTilePos(x, y, z), data);
    }

    @Nullable
    public Biome getBiome(@NotNull ChunkSectionTilePosc sectionPos) {
        if (!sectionPos.inBounds()) {
            return null;
        }
        byte biomeId = this.biome[ChunkSection.makeBiomeIndex(sectionPos)];
        if (biomeId < 0) {
            return null;
        }
        return Registries.BIOMES.getItemByNumericId(biomeId);
    }

    @Deprecated
    @Nullable
    public Biome getBiome(int x, int y, int z) {
        return this.getBiome(new ChunkSectionTilePos(x, y, z));
    }

    public void setSectionBiome(Biome biome) {
        int biomeId = Registries.BIOMES.getNumericIdOfItem(biome);
        Arrays.fill(this.biome, (byte)biomeId);
    }

    public void setBiome(@NotNull ChunkSectionTilePosc sectionPos, @NotNull Biome biome) {
        if (!sectionPos.inBounds()) {
            return;
        }
        int biomeId = Registries.BIOMES.getNumericIdOfItem(biome);
        this.biome[ChunkSection.makeBiomeIndex((ChunkSectionTilePosc)sectionPos)] = (byte)biomeId;
    }

    @Deprecated
    public void setBiome(int x, int y, int z, @NotNull Biome biome) {
        this.setBiome(new ChunkSectionTilePos(x, y, z), biome);
    }

    public int getBrightness(@NotNull LightLayer lightLayer, @NotNull ChunkSectionTilePosc sectionPos) {
        if (!sectionPos.inBounds()) {
            return 0;
        }
        switch (lightLayer) {
            case Sky: {
                if (this.skylightMap == null) {
                    return 0;
                }
                return this.skylightMap.get(sectionPos.x(), sectionPos.y(), sectionPos.z());
            }
            case Block: {
                if (this.blocklightMap == null) {
                    return 0;
                }
                return this.blocklightMap.get(sectionPos.x(), sectionPos.y(), sectionPos.z());
            }
        }
        return 0;
    }

    @Deprecated
    public int getBrightness(@NotNull LightLayer lightLayer, int x, int y, int z) {
        return this.getBrightness(lightLayer, new ChunkSectionTilePos(x, y, z));
    }

    public void setBrightness(@NotNull LightLayer lightLayer, @NotNull ChunkSectionTilePosc sectionPos, int brightness) {
        if (!sectionPos.inBounds()) {
            return;
        }
        switch (lightLayer) {
            case Sky: {
                if (this.skylightMap == null) {
                    this.skylightMap = new ChunkNibbleArray(16, 16, 16);
                }
                this.skylightMap.set(sectionPos.x(), sectionPos.y(), sectionPos.z(), brightness);
                break;
            }
            case Block: {
                if (this.blocklightMap == null) {
                    this.blocklightMap = new ChunkNibbleArray(16, 16, 16);
                }
                this.blocklightMap.set(sectionPos.x(), sectionPos.y(), sectionPos.z(), brightness);
            }
        }
    }

    @Deprecated
    public void setBrightness(@NotNull LightLayer lightLayer, int x, int y, int z, int brightness) {
        this.setBrightness(lightLayer, new ChunkSectionTilePos(x, y, z), brightness);
    }

    public int getRawBrightness(@NotNull ChunkSectionTilePosc sectionPos, int subtractedSkyLight) {
        if (!sectionPos.inBounds()) {
            return 0;
        }
        return Math.max(this.getBrightness(LightLayer.Sky, sectionPos) - subtractedSkyLight, this.getBrightness(LightLayer.Block, sectionPos));
    }

    @Deprecated
    public int getRawBrightness(int x, int y, int z, int subtractedSkyLight) {
        return this.getRawBrightness(new ChunkSectionTilePos(x, y, z), subtractedSkyLight);
    }

    public void addEntity(@NotNull Entity entity) {
        this.entities.add(entity);
    }

    public void removeEntity(@NotNull Entity entity) {
        this.entities.remove(entity);
    }

    public void getEntitiesWithin(@Nullable Entity toExclude, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull Entity> entities) {
        for (Entity e : this.entities) {
            if (e == toExclude || !e.bb.intersectsAABB((AABBd)aabb)) continue;
            entities.add(e);
        }
    }

    public <T extends Entity> void getEntitiesWithin(@NotNull Class<T> ofClass, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull T> entities) {
        for (Entity e : this.entities) {
            if (!ofClass.isAssignableFrom(e.getClass()) || !e.bb.intersectsAABB((AABBd)aabb)) continue;
            entities.add(e);
        }
    }

    public void onLoad(World world) {
        world.addLoadedEntities(this.entities);
    }

    public void onUnload(World world) {
        world.unloadEntities(this.entities);
    }

    public int setChunkSectionData(byte @NotNull [] data, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int cIndex;
        int cz;
        int xSize = maxX - minX;
        int ySize = maxY - minY;
        int zSize = maxZ - minZ;
        if (data[startIndex++] == 1) {
            if (this.blocks == null) {
                this.blocks = new short[4096];
            }
            ByteBuffer bb = ByteBuffer.allocate(this.blocks.length * 2);
            bb.asShortBuffer().put(this.blocks);
            for (int cy = minY; cy < maxY; ++cy) {
                for (int cz2 = minZ; cz2 < maxZ; ++cz2) {
                    int cIndex2 = ChunkSection.makeBlockIndex(minX, cy, cz2);
                    System.arraycopy(data, startIndex, bb.array(), cIndex2 * 2, xSize * 2);
                    startIndex += xSize * 2;
                }
            }
            ShortBuffer.wrap(this.blocks).put(bb.asShortBuffer());
        }
        if (data[startIndex++] == 1) {
            if (this.data == null || this.data.data == null) {
                this.data = new ChunkUnsignedByteArray(16, 16, 16);
            }
            for (int cy = minY; cy < maxY; ++cy) {
                for (cz = minZ; cz < maxZ; ++cz) {
                    cIndex = ChunkSection.makeBlockIndex(minX, cy, cz);
                    System.arraycopy(data, startIndex, this.data.data, cIndex, xSize);
                    startIndex += xSize;
                }
            }
        }
        if (data[startIndex++] == 1) {
            if (this.skylightMap == null || this.skylightMap.data == null) {
                this.skylightMap = new ChunkNibbleArray(16, 16, 16);
            }
            for (int cy = minY; cy < maxY; ++cy) {
                for (cz = minZ; cz < maxZ; ++cz) {
                    cIndex = ChunkSection.makeBlockIndex(minX, cy, cz) / 2;
                    System.arraycopy(data, startIndex, this.skylightMap.data, cIndex, xSize / 2);
                    startIndex += xSize / 2;
                }
            }
        }
        if (data[startIndex++] == 1) {
            if (this.blocklightMap == null || this.blocklightMap.data == null) {
                this.blocklightMap = new ChunkNibbleArray(16, 16, 16);
            }
            for (int cy = minY; cy < maxY; ++cy) {
                for (cz = minZ; cz < maxZ; ++cz) {
                    cIndex = ChunkSection.makeBlockIndex(minX, cy, cz) / 2;
                    System.arraycopy(data, startIndex, this.blocklightMap.data, cIndex, xSize / 2);
                    startIndex += xSize / 2;
                }
            }
        }
        if (data[startIndex++] == 1) {
            if (this.biome == null) {
                this.biome = new byte[512];
            }
            for (int cy = minY >> 3; cy < maxY >> 3; ++cy) {
                for (cz = minZ; cz < maxZ; ++cz) {
                    cIndex = ChunkSection.makeBlockIndex(minX, cy, cz);
                    System.arraycopy(data, startIndex, this.biome, cIndex, xSize);
                    startIndex += xSize;
                }
            }
        }
        return startIndex;
    }

    public int getChunkSectionData(byte @NotNull [] data, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int xSize = maxX - minX;
        int ySize = maxY - minY;
        int zSize = maxZ - minZ;
        ByteBuffer bb = null;
        if (this.blocks != null) {
            bb = ByteBuffer.allocate(this.blocks.length * 2);
            bb.asShortBuffer().put(this.blocks);
        }
        if (xSize * ySize * zSize == 4096) {
            if (this.blocks != null) {
                data[startIndex++] = 1;
                System.arraycopy(bb.array(), 0, data, startIndex, this.blocks.length * 2);
                startIndex += this.blocks.length * 2;
            } else {
                data[startIndex++] = 0;
            }
            if (this.data != null && this.data.isValid() && this.data.data != null) {
                data[startIndex++] = 1;
                System.arraycopy(this.data.data, 0, data, startIndex, this.data.data.length);
                startIndex += this.data.data.length;
            } else {
                data[startIndex++] = 0;
            }
            if (this.skylightMap != null && this.skylightMap.isValid() && this.skylightMap.data != null) {
                data[startIndex++] = 1;
                System.arraycopy(this.skylightMap.data, 0, data, startIndex, this.skylightMap.data.length);
                startIndex += this.skylightMap.data.length;
            } else {
                data[startIndex++] = 0;
            }
            if (this.blocklightMap != null && this.blocklightMap.isValid() && this.blocklightMap.data != null) {
                data[startIndex++] = 1;
                System.arraycopy(this.blocklightMap.data, 0, data, startIndex, this.blocklightMap.data.length);
                startIndex += this.blocklightMap.data.length;
            } else {
                data[startIndex++] = 0;
            }
            if (this.biome != null) {
                data[startIndex++] = 1;
                System.arraycopy(this.biome, 0, data, startIndex, this.biome.length);
                startIndex += this.biome.length;
            } else {
                data[startIndex++] = 0;
            }
        } else {
            int cIndex;
            int cz;
            int cy;
            if (this.blocks != null) {
                data[startIndex++] = 1;
                for (cy = minY; cy < maxY; ++cy) {
                    for (cz = minZ; cz < maxZ; ++cz) {
                        cIndex = ChunkSection.makeBlockIndex(minX, cy, cz);
                        System.arraycopy(bb.array(), cIndex * 2, data, startIndex, xSize * 2);
                        startIndex += xSize * 2;
                    }
                }
            } else {
                data[startIndex++] = 0;
            }
            if (this.data != null && this.data.isValid() && this.data.data != null) {
                data[startIndex++] = 1;
                for (cy = minY; cy < maxY; ++cy) {
                    for (cz = minZ; cz < maxZ; ++cz) {
                        cIndex = ChunkSection.makeBlockIndex(minX, cy, cz);
                        System.arraycopy(this.data.data, cIndex, data, startIndex, xSize);
                        startIndex += xSize;
                    }
                }
            } else {
                data[startIndex++] = 0;
            }
            if (this.skylightMap != null && this.skylightMap.isValid() && this.skylightMap.data != null) {
                data[startIndex++] = 1;
                for (cy = minY; cy < maxY; ++cy) {
                    for (cz = minZ; cz < maxZ; ++cz) {
                        cIndex = ChunkSection.makeBlockIndex(minX, cy, cz) / 2;
                        System.arraycopy(this.skylightMap.data, cIndex, data, startIndex, xSize / 2);
                        startIndex += xSize / 2;
                    }
                }
            } else {
                data[startIndex++] = 0;
            }
            if (this.blocklightMap != null && this.blocklightMap.isValid() && this.blocklightMap.data != null) {
                data[startIndex++] = 1;
                for (cy = minY; cy < maxY; ++cy) {
                    for (cz = minZ; cz < maxZ; ++cz) {
                        cIndex = ChunkSection.makeBlockIndex(minX, cy, cz) / 2;
                        System.arraycopy(this.blocklightMap.data, cIndex, data, startIndex, xSize / 2);
                        startIndex += xSize / 2;
                    }
                }
            } else {
                data[startIndex++] = 0;
            }
            if (this.biome != null) {
                data[startIndex++] = 1;
                for (cy = minY >> 3; cy < maxY >> 3; ++cy) {
                    for (cz = minZ; cz < maxZ; ++cz) {
                        cIndex = ChunkSection.makeBlockIndex(minX, cy, cz);
                        System.arraycopy(this.biome, cIndex, data, startIndex, xSize);
                        startIndex += xSize;
                    }
                }
            } else {
                data[startIndex++] = 0;
            }
        }
        return startIndex;
    }
}

