/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import net.minecraft.core.world.noise.Noise2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class FractalNoise2D<T extends Noise2D>
implements Noise2D {
    public static final double DEFAULT_LACUNARITY = 0.5;
    public static final double DEFAULT_PERSISTENCE = 2.0;
    @NotNull
    protected final @NotNull T @NotNull [] octaves;
    protected double lacunarity = 0.5;
    protected double persistence = 2.0;
    @NotNull
    protected final Vector2d range = new Vector2d();

    public FractalNoise2D(@NotNull @NotNull T @NotNull [] octaves) {
        this.octaves = octaves;
        this.calculateRange();
    }

    private void calculateRange() {
        @NotNull Vector2dc innerRange = this.octaves[0].getRange2D();
        double min = 0.0;
        double max = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < this.octaves.length; ++i) {
            min += innerRange.x() * amplitude;
            max += innerRange.y() * amplitude;
            amplitude *= this.persistence;
        }
        this.range.set(min, max);
    }

    @Override
    @NotNull
    public Vector2dc getRange2D() {
        return this.range;
    }

    @NotNull
    public FractalNoise2D<T> setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
        return this;
    }

    @NotNull
    public FractalNoise2D<T> setPersistence(double persistence) {
        this.persistence = persistence;
        this.calculateRange();
        return this;
    }

    @Override
    public double getValue(double x, double z) {
        double out = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        for (T octave : this.octaves) {
            out += octave.getValue(x * frequency, z * frequency) * amplitude;
            frequency *= this.lacunarity;
            amplitude *= this.persistence;
        }
        return out;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * zSize) {
            out = new double[xSize * zSize];
        }
        double frequency = 1.0;
        for (T octave : this.octaves) {
            octave.addRegion(out, x, z, xSize, zSize, xScale * frequency, zScale * frequency, amplitude);
            frequency *= this.lacunarity;
            amplitude *= this.persistence;
        }
        return out;
    }
}

