/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.player.inventory.slot.Slot;
import org.jetbrains.annotations.Nullable;

public class SlotGuidebook
extends Slot {
    public ItemStack item;
    public RecipeSymbol symbol;
    public RecipeEntryBase<?, ?, ?> recipe;
    public int recipeIndex = 0;
    public int recipeAmount = 0;
    public boolean isOutput = false;

    public SlotGuidebook(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe) {
        super(null, id, x, y);
        this.index = id;
        this.symbol = symbol;
        if (symbol != null && symbol.getItemGroup() != null) {
            this.showRandomItem();
        } else if (symbol != null) {
            this.item = symbol.resolve().get(0);
            if (recipe instanceof RecipeEntryTrommel) {
                WeightedRandomBag loot = (WeightedRandomBag)recipe.getOutput();
                this.recipeAmount = loot.getEntries().size() - 1;
            }
        }
        this.discovered = discovered;
        this.recipe = recipe;
    }

    @Deprecated
    public SlotGuidebook(int id, int x, int y, RecipeSymbol symbol, boolean discovered) {
        super(null, id, x, y);
        this.symbol = symbol;
        if (symbol != null && symbol.getItemGroup() != null) {
            this.showRandomItem();
        } else if (symbol != null) {
            this.item = symbol.resolve().get(0);
        }
        this.discovered = discovered;
        this.recipe = null;
    }

    public SlotGuidebook setAsOutput() {
        this.isOutput = true;
        return this;
    }

    @Override
    @Nullable
    public ItemStack remove(int i) {
        return null;
    }

    @Override
    public boolean hasItem() {
        return this.item != null;
    }

    @Override
    public int getMaxStackSize() {
        return this.item.getMaxStackSize();
    }

    @Override
    @Nullable
    public ItemStack getItemStack() {
        return this.item;
    }

    @Override
    public void onTake(ItemStack itemstack) {
    }

    @Override
    public void setChanged() {
    }

    @Override
    public void set(@Nullable ItemStack itemstack) {
    }

    public void showRandomItem() {
        if (this.symbol != null && this.symbol.getItemGroup() != null) {
            Random r = new Random();
            List<ItemStack> list = this.symbol.resolve();
            ItemStack newItem = list.get(r.nextInt(list.size()));
            if (list.size() > 1) {
                while (newItem == this.item) {
                    newItem = list.get(r.nextInt(list.size()));
                }
            }
            this.item = newItem;
        }
    }

    @Override
    public boolean getIsDiscovered(Player player) {
        if (this.item == null || this.discovered) {
            return true;
        }
        if (player instanceof PlayerLocal) {
            Minecraft mc = Minecraft.getMinecraft();
            if (!((Boolean)mc.gameSettings.hideUndiscoveredItems.value).booleanValue()) {
                return true;
            }
        }
        return player.getStat(this.item.getItem().getStat("stat_picked_up")) > 0 || player.getGamemode() == Gamemodes.CREATIVE;
    }

    public void scrollRecipe() {
    }
}

