/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import java.util.Random;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicEdible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.util.phys.HitResult;

public class HudComponentHealthBar
extends HudComponentMovable {
    private final Random random = new Random();

    public HudComponentHealthBar(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible() {
        return !HudComponentHealthBar.mc.thePlayer.getGamemode().hasInvulnerablePlayer() && HudComponentHealthBar.mc.gameSettings.immersiveMode.drawHotbar();
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        boolean heartsFlash;
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.BLEND);
        boolean bl = heartsFlash = HudComponentHealthBar.mc.thePlayer.heartsFlashTime / 3 % 2 == 1;
        if (HudComponentHealthBar.mc.thePlayer.heartsFlashTime < 10) {
            heartsFlash = false;
        }
        int health = HudComponentHealthBar.mc.thePlayer.getHealth();
        int prevHealth = HudComponentHealthBar.mc.thePlayer.prevHealth;
        this.random.setSeed((long)hud.updateCounter * 312871L);
        boolean isHardcore = HudComponentHealthBar.mc.thePlayer.getGamemode() == Gamemodes.HARDCORE;
        for (int i = 0; i < 10; ++i) {
            HitResult hitResult;
            Item heldItem;
            boolean heartOffset = false;
            if (heartsFlash) {
                heartOffset = true;
            }
            int xHeart = x + i * 8;
            int yHeart = y;
            if (health <= 4) {
                yHeart += this.random.nextInt(2);
            }
            hud.drawGuiIcon(xHeart, yHeart, 9, 9, !heartOffset ? TextureRegistry.getTexture("minecraft:gui/hud/heart/container") : TextureRegistry.getTexture("minecraft:gui/hud/heart/container_blinking"));
            if (heartsFlash) {
                if (i * 2 + 1 < prevHealth) {
                    hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "full_blinking"));
                }
                if (i * 2 + 1 == prevHealth) {
                    hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "half_blinking"));
                }
            }
            if (i * 2 + 1 < health) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "full"));
            }
            if (i * 2 + 1 == health) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "half"));
            }
            if (!((Boolean)HudComponentHealthBar.mc.gameSettings.foodHealthRegenOverlay.value).booleanValue()) continue;
            int healing = 0;
            ItemStack held = HudComponentHealthBar.mc.thePlayer.getHeldItem();
            if (held != null && (heldItem = held.getItem()) instanceof ItemFood) {
                healing = ((ItemFood)heldItem).getHealAmount();
            }
            if ((hitResult = HudComponentHealthBar.mc.objectMouseOver) instanceof HitResult.Tile) {
                HitResult.Tile hitTile = (HitResult.Tile)hitResult;
                Block<?> b = HudComponentHealthBar.mc.currentWorld.getBlockType(hitTile.tilePos);
                BlockLogic blockLogic = Block.getLogicClass(b);
                if (blockLogic instanceof BlockLogicEdible) {
                    BlockLogicEdible edible = (BlockLogicEdible)blockLogic;
                    healing = edible.getHealAmount(HudComponentHealthBar.mc.currentWorld, hitTile.tilePos);
                }
            }
            if (healing <= 0 || i * 2 + 1 < health) continue;
            if (i * 2 + 1 == health) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_half_right"));
                continue;
            }
            if (i * 2 + 1 < health + healing) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_full"));
                continue;
            }
            if (i * 2 + 1 != health + healing) continue;
            hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_half"));
        }
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(this, xSizeScreen);
        int y = layout.getComponentY(this, ySizeScreen);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.BLEND);
        int health = 11;
        for (int i = 0; i < 10; ++i) {
            int xHeart = x + i * 8;
            gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/container"));
            if (i * 2 + 1 < health) {
                gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/full"));
            }
            if (i * 2 + 1 != health) continue;
            gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/half"));
        }
    }
}

