/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockModelFire<T extends BlockLogic>
extends BlockModelStandard<T> {
    private final boolean overrideRender;

    public BlockModelFire(Block<T> block) {
        this(block, false);
    }

    public BlockModelFire(Block<T> block, boolean overrideRender) {
        super(block);
        this.overrideRender = overrideRender;
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        IconCoordinate tex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, worldSource.getBlockData(tilePos));
        if (BlockModelFire.renderBlocks.overrideBlockTexture != null) {
            tex = BlockModelFire.renderBlocks.overrideBlockTexture;
        }
        tessellator.setLightmapCoord1i(LightmapHelper.getOverbrightLightmapCoord(worldSource.getSavedLightValue(LightLayer.Sky, tilePos)));
        double uMin = tex.getIconUMin();
        double uMax = tex.getIconUMax();
        double vMin = tex.getIconVMin();
        double vMax = tex.getIconVMax();
        float yOffset = 1.4f;
        TilePos queryPos = new TilePos();
        int x = tilePos.x();
        int y = tilePos.y();
        int z = tilePos.z();
        if (this.overrideRender || worldSource.isBlockNormalCube(tilePos.down(queryPos)) || BlockLogicFire.canBurn(worldSource, tilePos.down(queryPos)) || worldSource == WorldClient.EMPTY_WORLD) {
            double d8 = (double)x + 0.5 + 0.2;
            double d9 = (double)x + 0.5 - 0.2;
            double d12 = (double)z + 0.5 + 0.2;
            double d14 = (double)z + 0.5 - 0.2;
            double d16 = (double)x + 0.5 - 0.3;
            double d18 = (double)x + 0.5 + 0.3;
            double d20 = (double)z + 0.5 - 0.3;
            double d22 = (double)z + 0.5 + 0.3;
            tessellator.addVertexWithUV(d16, (float)y + 1.4f, z + 1, uMax, vMin);
            tessellator.addVertexWithUV(d8, y, z + 1, uMax, vMax);
            tessellator.addVertexWithUV(d8, y, z, uMin, vMax);
            tessellator.addVertexWithUV(d16, (float)y + 1.4f, z, uMin, vMin);
            tessellator.addVertexWithUV(d18, (float)y + 1.4f, z, uMax, vMin);
            tessellator.addVertexWithUV(d9, y, z, uMax, vMax);
            tessellator.addVertexWithUV(d9, y, z + 1, uMin, vMax);
            tessellator.addVertexWithUV(d18, (float)y + 1.4f, z + 1, uMin, vMin);
            uMin = tex.getIconUMin();
            uMax = tex.getIconUMax();
            vMin = tex.getIconVMin();
            vMax = tex.getIconVMax();
            tessellator.addVertexWithUV(x + 1, (float)y + 1.4f, d22, uMax, vMin);
            tessellator.addVertexWithUV(x + 1, y, d14, uMax, vMax);
            tessellator.addVertexWithUV(x, y, d14, uMin, vMax);
            tessellator.addVertexWithUV(x, (float)y + 1.4f, d22, uMin, vMin);
            tessellator.addVertexWithUV(x, (float)y + 1.4f, d20, uMax, vMin);
            tessellator.addVertexWithUV(x, y, d12, uMax, vMax);
            tessellator.addVertexWithUV(x + 1, y, d12, uMin, vMax);
            tessellator.addVertexWithUV(x + 1, (float)y + 1.4f, d20, uMin, vMin);
            d8 = (double)x + 0.5 - 0.5;
            d9 = (double)x + 0.5 + 0.5;
            d12 = (double)z + 0.5 - 0.5;
            d14 = (double)z + 0.5 + 0.5;
            d16 = (double)x + 0.5 - 0.4;
            d18 = (double)x + 0.5 + 0.4;
            d20 = (double)z + 0.5 - 0.4;
            d22 = (double)z + 0.5 + 0.4;
            tessellator.addVertexWithUV(d16, (float)y + 1.4f, z, uMin, vMin);
            tessellator.addVertexWithUV(d8, y, z, uMin, vMax);
            tessellator.addVertexWithUV(d8, y, z + 1, uMax, vMax);
            tessellator.addVertexWithUV(d16, (float)y + 1.4f, z + 1, uMax, vMin);
            tessellator.addVertexWithUV(d18, (float)y + 1.4f, z + 1, uMin, vMin);
            tessellator.addVertexWithUV(d9, y, z + 1, uMin, vMax);
            tessellator.addVertexWithUV(d9, y, z, uMax, vMax);
            tessellator.addVertexWithUV(d18, (float)y + 1.4f, z, uMax, vMin);
            uMin = tex.getIconUMin();
            uMax = tex.getIconUMax();
            vMin = tex.getIconVMin();
            vMax = tex.getIconVMax();
            tessellator.addVertexWithUV(x, (float)y + 1.4f, d22, uMin, vMin);
            tessellator.addVertexWithUV(x, y, d14, uMin, vMax);
            tessellator.addVertexWithUV(x + 1, y, d14, uMax, vMax);
            tessellator.addVertexWithUV(x + 1, (float)y + 1.4f, d22, uMax, vMin);
            tessellator.addVertexWithUV(x + 1, (float)y + 1.4f, d20, uMin, vMin);
            tessellator.addVertexWithUV(x + 1, y, d12, uMin, vMax);
            tessellator.addVertexWithUV(x, y, d12, uMax, vMax);
            tessellator.addVertexWithUV(x, (float)y + 1.4f, d20, uMax, vMin);
        } else {
            float f3 = 0.2f;
            float f4 = 0.0625f;
            if ((x + y + z & 1) == 1) {
                uMin = tex.getIconUMin();
                uMax = tex.getIconUMax();
                vMin = tex.getIconVMin();
                vMax = tex.getIconVMax();
            }
            if ((x / 2 + y / 2 + z / 2 & 1) == 1) {
                double d10 = uMax;
                uMax = uMin;
                uMin = d10;
            }
            if (BlockLogicFire.canBurn(worldSource, tilePos.west(queryPos))) {
                tessellator.addVertexWithUV((float)x + f3, (float)y + 1.4f + f4, z + 1, uMax, vMin);
                tessellator.addVertexWithUV(x, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV(x, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV((float)x + f3, (float)y + 1.4f + f4, z, uMin, vMin);
                tessellator.addVertexWithUV((float)x + f3, (float)y + 1.4f + f4, z, uMin, vMin);
                tessellator.addVertexWithUV(x, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV(x, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV((float)x + f3, (float)y + 1.4f + f4, z + 1, uMax, vMin);
            }
            if (BlockLogicFire.canBurn(worldSource, tilePos.east(queryPos))) {
                tessellator.addVertexWithUV((float)(x + 1) - f3, (float)y + 1.4f + f4, z, uMin, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV((float)(x + 1) - f3, (float)y + 1.4f + f4, z + 1, uMax, vMin);
                tessellator.addVertexWithUV((float)(x + 1) - f3, (float)y + 1.4f + f4, z + 1, uMax, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV((float)(x + 1) - f3, (float)y + 1.4f + f4, z, uMin, vMin);
            }
            if (BlockLogicFire.canBurn(worldSource, tilePos.north(queryPos))) {
                tessellator.addVertexWithUV(x, (float)y + 1.4f + f4, (float)z + f3, uMax, vMin);
                tessellator.addVertexWithUV(x, (float)y + f4, z, uMax, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + 1.4f + f4, (float)z + f3, uMin, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + 1.4f + f4, (float)z + f3, uMin, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV(x, (float)y + f4, z, uMax, vMax);
                tessellator.addVertexWithUV(x, (float)y + 1.4f + f4, (float)z + f3, uMax, vMin);
            }
            if (BlockLogicFire.canBurn(worldSource, tilePos.south(queryPos))) {
                tessellator.addVertexWithUV(x + 1, (float)y + 1.4f + f4, (float)(z + 1) - f3, uMin, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z + 1, uMin, vMax);
                tessellator.addVertexWithUV(x, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV(x, (float)y + 1.4f + f4, (float)(z + 1) - f3, uMax, vMin);
                tessellator.addVertexWithUV(x, (float)y + 1.4f + f4, (float)(z + 1) - f3, uMax, vMin);
                tessellator.addVertexWithUV(x, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z + 1, uMin, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + 1.4f + f4, (float)(z + 1) - f3, uMin, vMin);
            }
            if (BlockLogicFire.canBurn(worldSource, tilePos.up(queryPos))) {
                double d11 = (double)x + 0.5 + 0.5;
                double d13 = (double)x + 0.5 - 0.5;
                double d15 = (double)z + 0.5 + 0.5;
                double d17 = (double)z + 0.5 - 0.5;
                double d19 = (double)x + 0.5 - 0.5;
                double d21 = (double)x + 0.5 + 0.5;
                double d23 = (double)z + 0.5 - 0.5;
                double d24 = (double)z + 0.5 + 0.5;
                double d1 = tex.getIconUMin();
                double d3 = tex.getIconUMax();
                double d5 = tex.getIconVMin();
                double d7 = tex.getIconVMax();
                float f2 = -0.2f;
                if ((x + ++y + z & 1) == 0) {
                    tessellator.addVertexWithUV(d19, (float)y + f2, z, d3, d5);
                    tessellator.addVertexWithUV(d11, y, z, d3, d7);
                    tessellator.addVertexWithUV(d11, y, z + 1, d1, d7);
                    tessellator.addVertexWithUV(d19, (float)y + f2, z + 1, d1, d5);
                    d1 = tex.getIconUMin();
                    d3 = tex.getIconUMax();
                    d5 = tex.getIconVMin();
                    d7 = tex.getIconVMax();
                    tessellator.addVertexWithUV(d21, (float)y + f2, z + 1, d3, d5);
                    tessellator.addVertexWithUV(d13, y, z + 1, d3, d7);
                    tessellator.addVertexWithUV(d13, y, z, d1, d7);
                    tessellator.addVertexWithUV(d21, (float)y + f2, z, d1, d5);
                } else {
                    tessellator.addVertexWithUV(x, (float)y + f2, d24, d3, d5);
                    tessellator.addVertexWithUV(x, y, d17, d3, d7);
                    tessellator.addVertexWithUV(x + 1, y, d17, d1, d7);
                    tessellator.addVertexWithUV(x + 1, (float)y + f2, d24, d1, d5);
                    d1 = tex.getIconUMin();
                    d3 = tex.getIconUMax();
                    d5 = tex.getIconVMin();
                    d7 = tex.getIconVMax();
                    tessellator.addVertexWithUV(x + 1, (float)y + f2, d23, d3, d5);
                    tessellator.addVertexWithUV(x + 1, y, d15, d3, d7);
                    tessellator.addVertexWithUV(x, y, d15, d1, d7);
                    tessellator.addVertexWithUV(x, (float)y + f2, d23, d1, d5);
                }
            }
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

