/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFullyRotatable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelFullyRotatable<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelFullyRotatable(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int meta = worldSource.getBlockData(tilePos);
        Direction dir = BlockLogicFullyRotatable.metaToDirection(meta);
        switch (dir) {
            case DOWN: {
                BlockModelFullyRotatable.renderBlocks.uvRotateEast = 3;
                BlockModelFullyRotatable.renderBlocks.uvRotateWest = 3;
                BlockModelFullyRotatable.renderBlocks.uvRotateSouth = 3;
                BlockModelFullyRotatable.renderBlocks.uvRotateNorth = 3;
                break;
            }
            case NORTH: {
                BlockModelFullyRotatable.renderBlocks.uvRotateSouth = 1;
                BlockModelFullyRotatable.renderBlocks.uvRotateNorth = 2;
                break;
            }
            case SOUTH: {
                BlockModelFullyRotatable.renderBlocks.uvRotateSouth = 2;
                BlockModelFullyRotatable.renderBlocks.uvRotateNorth = 1;
                BlockModelFullyRotatable.renderBlocks.uvRotateTop = 3;
                BlockModelFullyRotatable.renderBlocks.uvRotateBottom = 3;
                break;
            }
            case WEST: {
                BlockModelFullyRotatable.renderBlocks.uvRotateEast = 1;
                BlockModelFullyRotatable.renderBlocks.uvRotateWest = 2;
                BlockModelFullyRotatable.renderBlocks.uvRotateTop = 2;
                BlockModelFullyRotatable.renderBlocks.uvRotateBottom = 1;
                break;
            }
            case EAST: {
                BlockModelFullyRotatable.renderBlocks.uvRotateEast = 2;
                BlockModelFullyRotatable.renderBlocks.uvRotateWest = 1;
                BlockModelFullyRotatable.renderBlocks.uvRotateTop = 1;
                BlockModelFullyRotatable.renderBlocks.uvRotateBottom = 2;
            }
        }
        boolean result = renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsFromState(worldSource, tilePos), tilePos);
        renderBlocks.resetRenderBlocks();
        return result;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        super.renderStandalone(tessellator, 1, lightmapCoord);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        Direction dir = BlockLogicFullyRotatable.metaToDirection(data);
        if (side == dir.getSide()) {
            return this.blockTextures.get(Side.TOP);
        }
        return side.getDirection() != dir.getOpposite() ? this.blockTextures.get(Side.NORTH) : this.blockTextures.get(Side.BOTTOM);
    }
}

