/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericChestPainted<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel[] single = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] left = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] right = new StaticBlockModel[16];

    public BlockModelGenericChestPainted(@NotNull Block<T> block) {
        super(block, BlockModelDispatcher.loadDataModel("minecraft:block/chest/single/" + DyeColor.WHITE.colorID));
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            this.single[c.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/chest/single/" + c.colorID).asModel();
            this.left[c.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/chest/left/" + c.colorID).asModel();
            this.right[c.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/chest/right/" + c.colorID).asModel();
        }
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        Direction direction = BlockLogicChest.getDirectionFromMeta(worldSource.getBlockData(tilePos));
        switch (direction) {
            case NORTH: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case WEST: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case EAST: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case SOUTH: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
        }
        return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }

    @Override
    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        int data = source.getBlockData(tilePosc);
        int color = data >> 4;
        BlockLogicChest.Type type = BlockLogicChest.getTypeFromMeta(data);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BlockLogicChest.Type.LEFT -> this.left[color];
            case BlockLogicChest.Type.RIGHT -> this.right[color];
            case BlockLogicChest.Type.SINGLE -> this.single[color];
        };
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        int color = data >> 4;
        return this.single[color];
    }
}

