/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockInterface;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolShears;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogic
implements BlockInterface,
IItemConvertible {
    @NotNull
    protected final AABBd bounds = new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    @NotNull
    public final Block<?> block;
    @NotNull
    protected Material material;

    public BlockLogic(@NotNull Block<?> block, @NotNull Material material) {
        this.block = block;
        this.material = material;
    }

    public void initializeBlock() {
    }

    @Override
    public final int id() {
        return this.block.id();
    }

    @Override
    @NotNull
    public final String getKey() {
        return this.block.getKey();
    }

    @Override
    @NotNull
    public final NamespaceID namespaceId() {
        return this.block.namespaceId();
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    @NotNull
    public MaterialColor getMaterialColor() {
        return this.material.color;
    }

    @Override
    public boolean isCubeShaped() {
        return true;
    }

    @Override
    public boolean canPlaceOnSurface() {
        return this.isCubeShaped();
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.canPlaceOnSurface();
    }

    @Override
    public boolean renderAsNormalBlockOnCondition(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return this.isCubeShaped();
    }

    @Override
    public boolean canPlaceOnSurface(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.canPlaceOnSurface();
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity) {
        return this.getBreakResult(world, dropCause, data, tileEntity);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(this.block)};
        }
        return null;
    }

    public final void setBlockBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.bounds.setMin(minX, minY, minZ).setMax(maxX, maxY, maxZ);
    }

    @Override
    @NotNull
    public AABBdc getBounds() {
        return this.bounds;
    }

    @Override
    @NotNull
    public AABBd getBoundsRaw() {
        return this.bounds;
    }

    @Override
    public float getBrightness(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return source.getBrightness(tilePos, this.block.emission);
    }

    @Override
    public int getLightmapCoord(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return source.getLightmapCoord(tilePos, this.block.emission);
    }

    @Override
    public float getAmbientOcclusionStrength(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return this.isSolidRender() ? 1.0f : 0.0f;
    }

    @Override
    @NotNull
    public AABBdc getSelectionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return this.getBoundsFromState(source, tilePos).translate(tilePos.x(), tilePos.y(), tilePos.z(), new AABBd());
    }

    @Override
    @Nullable
    public BoundingVolume getBoundingVolume(@NotNull World world, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    public void getCollisionAABBs(@NotNull World world, @NotNull TilePosc tilePos, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull AABBdc> aabbList) {
        this.addIntersectingBoundingBox(aabb, this.getCollisionAABB(world, tilePos), aabbList);
    }

    protected void addIntersectingBoundingBox(@NotNull AABBdc sourceAABB, @Nullable AABBdc aabbToAdd, @NotNull @NotNull List<@NotNull AABBdc> aabbList) {
        if (aabbToAdd != null && sourceAABB.intersectsAABB((AABBd)aabbToAdd)) {
            aabbList.add(aabbToAdd);
        }
    }

    @Override
    public boolean collidesWithEntity(@NotNull Entity entity, @NotNull World world, @NotNull TilePosc tilePos) {
        return true;
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return this.getBoundsFromState(source, tilePos).translate(tilePos.x(), tilePos.y(), tilePos.z(), new AABBd());
    }

    @Override
    public boolean isSolidRender() {
        return true;
    }

    @Override
    public boolean blocksLight() {
        return false;
    }

    @Override
    public boolean canCollideCheck(int data, boolean shouldCollideWithFluids) {
        return this.isCollidable();
    }

    @Override
    public boolean isCollidable() {
        return true;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
    }

    @Override
    public int tickDelay() {
        return 10;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
    }

    @Override
    public void onDestroyedByPlayer(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, int data, @NotNull Player player, @Nullable Item item) {
    }

    @Override
    public float getStrength(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Player player) {
        if (this.block.blockHardness < 0.0f) {
            return 0.0f;
        }
        if (!player.canHarvestBlock(this.block)) {
            return 1.0f / this.block.blockHardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(this.block) / this.block.blockHardness / 30.0f;
    }

    @Override
    public boolean getImmovable() {
        return this.block.immovable;
    }

    @Override
    public float getBlastResistance(@Nullable Entity entity) {
        return this.block.blastResistance / 5.0f;
    }

    @Override
    @Nullable
    public HitResult collisionRayTrace(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Vector3dc start, @NotNull Vector3dc end, boolean useSelectionAABB) {
        @NotNull AABBdc bounds = useSelectionAABB ? this.getSelectionAABB(world, tilePos).translate(-tilePos.x(), -tilePos.y(), -tilePos.z(), new AABBd()) : this.getBoundsFromState(world, tilePos);
        Vector3d startInBlock = start.add(-tilePos.x(), -tilePos.y(), -tilePos.z(), new Vector3d());
        Vector3d endInBlock = end.add(-tilePos.x(), -tilePos.y(), -tilePos.z(), new Vector3d());
        @Nullable Vector3d minVX = MathHelper.vecClipX(startInBlock, endInBlock, bounds.minX(), new Vector3d());
        @Nullable Vector3d maxVX = MathHelper.vecClipX(startInBlock, endInBlock, bounds.maxX(), new Vector3d());
        @Nullable Vector3d minVY = MathHelper.vecClipY(startInBlock, endInBlock, bounds.minY(), new Vector3d());
        @Nullable Vector3d maxVY = MathHelper.vecClipY(startInBlock, endInBlock, bounds.maxY(), new Vector3d());
        @Nullable Vector3d minVZ = MathHelper.vecClipZ(startInBlock, endInBlock, bounds.minZ(), new Vector3d());
        @Nullable Vector3d maxVZ = MathHelper.vecClipZ(startInBlock, endInBlock, bounds.maxZ(), new Vector3d());
        if (!this.isVecInsideYZBounds(bounds, minVX)) {
            minVX = null;
        }
        if (!this.isVecInsideYZBounds(bounds, maxVX)) {
            maxVX = null;
        }
        if (!this.isVecInsideXZBounds(bounds, minVY)) {
            minVY = null;
        }
        if (!this.isVecInsideXZBounds(bounds, maxVY)) {
            maxVY = null;
        }
        if (!this.isVecInsideXYBounds(bounds, minVZ)) {
            minVZ = null;
        }
        if (!this.isVecInsideXYBounds(bounds, maxVZ)) {
            maxVZ = null;
        }
        Vector3d clip = null;
        if (minVX != null) {
            clip = minVX;
        }
        if (maxVX != null && (clip == null || startInBlock.distanceSquared(maxVX) < startInBlock.distanceSquared(clip))) {
            clip = maxVX;
        }
        if (minVY != null && (clip == null || startInBlock.distanceSquared(minVY) < startInBlock.distanceSquared(clip))) {
            clip = minVY;
        }
        if (maxVY != null && (clip == null || startInBlock.distanceSquared(maxVY) < startInBlock.distanceSquared(clip))) {
            clip = maxVY;
        }
        if (minVZ != null && (clip == null || startInBlock.distanceSquared(minVZ) < startInBlock.distanceSquared(clip))) {
            clip = minVZ;
        }
        if (maxVZ != null && (clip == null || startInBlock.distanceSquared(maxVZ) < startInBlock.distanceSquared(clip))) {
            clip = maxVZ;
        }
        if (clip == null) {
            return null;
        }
        @NotNull Side side = clip == minVX ? Side.WEST : (clip == maxVX ? Side.EAST : (clip == minVY ? Side.BOTTOM : (clip == maxVY ? Side.TOP : (clip == minVZ ? Side.NORTH : Side.SOUTH))));
        return new HitResult.Tile(tilePos, side, clip.add(tilePos.x(), tilePos.y(), tilePos.z()));
    }

    private boolean isVecInsideYZBounds(@NotNull AABBdc bounds, @Nullable Vector3dc v) {
        if (v == null) {
            return false;
        }
        return v.y() >= bounds.minY() && v.y() <= bounds.maxY() && v.z() >= bounds.minZ() && v.z() <= bounds.maxZ();
    }

    private boolean isVecInsideXZBounds(@NotNull AABBdc bounds, @Nullable Vector3dc v) {
        if (v == null) {
            return false;
        }
        return v.x() >= bounds.minX() && v.x() <= bounds.maxX() && v.z() >= bounds.minZ() && v.z() <= bounds.maxZ();
    }

    private boolean isVecInsideXYBounds(@NotNull AABBdc bounds, @Nullable Vector3dc v) {
        if (v == null) {
            return false;
        }
        return v.x() >= bounds.minX() && v.x() <= bounds.maxX() && v.y() >= bounds.minY() && v.y() <= bounds.maxY();
    }

    @Override
    public void onDestroyedByExplosion(@NotNull World world, @NotNull TilePosc tilePos) {
    }

    @Override
    public boolean canPlaceOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.canPlaceAt(world, tilePos);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return world.canPlaceInsideBlock(tilePos);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        return false;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
    }

    @Override
    public void onEntityWalkedOn(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity walker) {
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
    }

    @Override
    public void onEntityInside(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity entity, @NotNull Vector3d velocityDirection) {
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return this.getBounds();
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return false;
    }

    @Override
    public boolean isSignalSource() {
        return false;
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity entity) {
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return false;
    }

    @Override
    public void onHarvest(@NotNull World world, @NotNull Player player, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity) {
        player.addStat(Objects.requireNonNull(this.block.getStat("stat_mined")), 1);
        @Nullable ItemStack heldItemStack = player.inventory.getCurrentItem();
        Item heldItem = heldItemStack != null ? heldItemStack.getItem() : null;
        if (heldItem != null) {
            if (heldItem.isSilkTouch() && player.canHarvestBlock(this.block)) {
                this.dropWithCause(world, EnumDropCause.SILK_TOUCH, tilePos, data, tileEntity, player);
                return;
            }
            if (heldItem instanceof ItemToolShears) {
                ItemToolShears heldShears = (ItemToolShears)heldItem;
                if (this.block.hasTag(BlockTags.SHEARS_DO_SILK_TOUCH) || this.block.hasTag(BlockTags.MINEABLE_BY_SHEARS)) {
                    this.dropWithCause(world, EnumDropCause.SILK_TOUCH, tilePos, data, tileEntity, player);
                    heldShears.onBlockSheared(heldItemStack, player);
                    return;
                }
            }
        }
        if (player.canHarvestBlock(this.block)) {
            this.dropWithCause(world, EnumDropCause.PROPER_TOOL, tilePos, data, tileEntity, player);
        } else {
            this.dropWithCause(world, EnumDropCause.IMPROPER_TOOL, tilePos, data, tileEntity, player);
        }
    }

    @Override
    public void dropWithCause(@NotNull World world, @NotNull EnumDropCause dropCause, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity, @Nullable Player player) {
        if (world.isClientSide) {
            return;
        }
        @NotNull ItemStack @Nullable [] drops = this.getBreakResult(world, dropCause, tilePos, data, tileEntity);
        if (drops == null) {
            return;
        }
        for (ItemStack drop : drops) {
            if (this.block.hasTag(BlockTags.INSTANT_PICKUP) && player != null) {
                player.inventory.insertItem(drop, true);
                if (drop.stackSize <= 0) continue;
            }
            if (EntityItem.enableItemClumping) {
                world.dropItem(tilePos, drop.copy());
                continue;
            }
            for (int i = 0; i < drop.stackSize; ++i) {
                ItemStack singleDrop = drop.copy();
                singleDrop.stackSize = 1;
                world.dropItem(tilePos, singleDrop);
            }
        }
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return FullSupport.INSTANCE;
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        return true;
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        this.onPlacedOnSide(world, tilePos, side, xHit, yHit);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
    }

    @Override
    @NotNull
    public String getLanguageKey(int data) {
        return this.block.getKey();
    }

    @Override
    public void triggerEvent(@NotNull World world, @NotNull TilePosc tilePos, int index, int data) {
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.material.getPushReaction();
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return 0;
    }

    @Override
    public boolean isClimbable(@NotNull World world, @NotNull TilePosc tilePos) {
        return false;
    }

    @Override
    public boolean isEquivalent(@NotNull World world, @NotNull TilePosc thisPos, @NotNull TilePosc thatPos) {
        @Nullable Block<?> bBlock = world.getBlockType(thatPos);
        int thisMeta = world.getBlockData(thisPos);
        int otherMeta = world.getBlockData(thatPos);
        return this.block == bBlock && thisMeta == otherMeta;
    }

    @Override
    @NotNull
    public Side getAttachedSide(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return Side.NONE;
    }

    @Override
    @NotNull
    public Item asItem() {
        return this.block.asItem();
    }

    @Override
    @NotNull
    public ItemStack getDefaultStack() {
        return this.block.getDefaultStack();
    }
}

