/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicFence
extends BlockLogic
implements IPaintable {
    public BlockLogicFence(@NotNull Block<?> block) {
        super(block, Materials.WOOD);
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (side.isVertical()) {
            return PartialSupport.INSTANCE.center();
        }
        return PartialSupport.INSTANCE;
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return MathHelper.aabbExpand(super.getBoundsFromState(source, tilePos), 0.0, 0.5, 0.0, new AABBd());
    }

    @Override
    public void getCollisionAABBs(@NotNull World world, @NotNull TilePosc tilePos, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull AABBdc> aabbList) {
        boolean connectEast = this.canConnectTo(world, tilePos, Side.EAST);
        boolean connectWest = this.canConnectTo(world, tilePos, Side.WEST);
        boolean connectSouth = this.canConnectTo(world, tilePos, Side.SOUTH);
        boolean connectNorth = this.canConnectTo(world, tilePos, Side.NORTH);
        double thickness = 0.125;
        if (connectEast) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.375, 0.0, 0.375, 1.0, 1.5, 0.625).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
        if (connectWest) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.0, 0.0, 0.375, 0.625, 1.5, 0.625).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
        if (connectSouth) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.375, 0.0, 0.375, 0.625, 1.5, 1.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
        if (connectNorth) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.375, 0.0, 0.0, 0.625, 1.5, 0.625).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
        if (!(connectEast || connectWest || connectSouth || connectNorth)) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.375, 0.0, 0.375, 0.625, 1.5, 0.625).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        boolean connectXPos = this.canConnectTo(source, tilePos, Side.EAST);
        boolean connectXNeg = this.canConnectTo(source, tilePos, Side.WEST);
        boolean connectZPos = this.canConnectTo(source, tilePos, Side.SOUTH);
        boolean connectZNeg = this.canConnectTo(source, tilePos, Side.NORTH);
        return new AABBd(connectXNeg ? 0.0f : 0.375f, 0.0, connectZNeg ? 0.0f : 0.375f, 1.0f - (connectXPos ? 0.0f : 0.375f), 1.0, 1.0f - (connectZPos ? 0.0f : 0.375f));
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    public boolean canConnectTo(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        TilePos queryPos = new TilePos();
        @NotNull Block<?> b = source.getBlockType(tilePos.add(side.getDirection(), queryPos));
        return Blocks.hasTag(b, BlockTags.FENCES_CONNECT) || b.getAttachedSide(source, tilePos.add(side.getDirection(), queryPos)) == side.getOpposite();
    }

    @Deprecated
    public final boolean canConnectTo(@NotNull WorldSource worldSource, int x, int y, int z, @NotNull Side side) {
        return this.canConnectTo(worldSource, new TilePos(x, y, z), side);
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        world.setBlockType(tilePos, Blocks.FENCE_PLANKS_OAK_PAINTED);
        Blocks.FENCE_PLANKS_OAK_PAINTED.getLogic().setColor(world, tilePos, color);
    }
}

