/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStatue
extends Item {
    @NotNull
    protected final Block<?> statueBlockBottom;
    @NotNull
    protected final Block<?> statueBlockTop;

    public ItemStatue(@NotNull String name, @NotNull String namespaceId, int id, @NotNull Block<?> statueBlockBottom, @NotNull Block<?> statueBlockTop) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
        this.statueBlockBottom = statueBlockBottom;
        this.statueBlockTop = statueBlockTop;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
        }
        if (!this.statueBlockBottom.canPlaceAt(world, blockPos)) {
            return false;
        }
        world.noNeighborUpdate = true;
        world.setBlockTypeDataNotify(blockPos, this.statueBlockBottom, MathHelper.floor((double)((player.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        world.setBlockTypeDataNotify(blockPos.up(new TilePos()), this.statueBlockTop, MathHelper.floor((double)((player.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockPos, this.statueBlockBottom);
        world.notifyBlocksOfNeighborChange(blockPos.up(new TilePos()), this.statueBlockTop);
        world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.statueBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.statueBlockBottom.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
        this.statueBlockTop.onPlacedByMob(world, blockPos.up(new TilePos()), side, player, xHit, yHit);
        selfStack.consumeItem(player);
        return true;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(direction, new TilePos());
        }
        if (!this.statueBlockBottom.canPlaceAt(world, blockPos)) {
            return;
        }
        world.noNeighborUpdate = true;
        world.setBlockTypeNotify(blockPos, this.statueBlockBottom);
        world.setBlockTypeNotify(blockPos.up(new TilePos()), this.statueBlockTop);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockPos, this.statueBlockBottom);
        world.notifyBlocksOfNeighborChange(blockPos.up(new TilePos()), this.statueBlockTop);
        world.playBlockSoundEffect(null, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.statueBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.statueBlockBottom.onPlacedOnSide(world, blockPos, direction.getSide(), 0.5, 0.5);
        this.statueBlockTop.onPlacedOnSide(world, blockPos.up(new TilePos()), direction.getSide(), 0.5, 0.5);
        selfStack.consumeItem(null);
    }
}

