#version 410 core
out vec4 FragColor;

in vec4 Color;
in vec2 TexCoord;
in vec2 Lightmap;

uniform float uAlphaTest;
uniform vec4 uColor;

uniform sampler2D colortex;
uniform sampler2D lighttex;

void main() {
    FragColor = texture(colortex, TexCoord) * texture(lighttex, Lightmap) * Color * uColor;
    if (FragColor.a < uAlphaTest) {
        discard;
    }
}