/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.toasts;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.toasts.IToastable;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;

public class GuiElementToastsHud
extends Gui {
    private static final int TOAST_WIDTH = 160;
    private static final int TOAST_HEIGHT = 32;
    private static final int MAX_SHOWN_ENTRIES = 5;
    private final List<IToastable> overflowEntries = new ArrayList<IToastable>();
    private final List<ToastEntry> activeEntries = new ArrayList<ToastEntry>();
    private final Minecraft mc;

    public GuiElementToastsHud(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public boolean isDisplayingToast(IToastable toast) {
        for (ToastEntry entry : this.activeEntries) {
            if (!entry.toast.isEquivalentToast(toast)) continue;
            return true;
        }
        return false;
    }

    public void addToast(IToastable toast) {
        if (this.activeEntries.size() >= 5) {
            this.overflowEntries.add(toast);
            return;
        }
        this.activeEntries.add(new ToastEntry(toast, System.currentTimeMillis()));
        toast.onToastStart();
        this.sortList();
    }

    public void endToast(IToastable toast) {
        for (int i = 0; i < this.activeEntries.size(); ++i) {
            ToastEntry entry = this.activeEntries.get(i);
            if (!entry.toast.isEquivalentToast(toast)) continue;
            this.activeEntries.remove(i);
            entry.toast.onToastEnd();
            this.sortList();
            return;
        }
    }

    protected void sortList() {
        this.activeEntries.sort(ToastEntry.TOAST_SORTER);
    }

    private void updateScale() {
        GL41.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
        GL41.glClear(256);
        GLRenderer.projectionM4f().identity().ortho(0.0f, (float)this.mc.resolution.getExactScaledWidthScreenCoords(), (float)this.mc.resolution.getExactScaledHeightScreenCoords(), 0.0f, 1000.0f, 3000.0f);
        GLRenderer.viewM4f().identity().translate(0.0f, 0.0f, -2000.0f);
        GLRenderer.modelM4f().identity();
    }

    public void render(float partialTick) {
        if (Minecraft.hasPaidCheckTime > 0L) {
            GLRenderer.disableState(State.DEPTH_TEST);
            GLRenderer.setDepthMask(false);
            Lighting.disable();
            String s = I18n.getInstance().translateKeyAndFormat("gui.achievement.label.unlicensed.1", Global.VERSION);
            String s1 = I18n.getInstance().translateKey("gui.achievement.label.unlicensed.2");
            String s2 = I18n.getInstance().translateKey("gui.achievement.label.unlicensed.3");
            this.drawStringShadow(this.mc.font, s, 2, 2, 0xFFFFFF);
            this.drawStringShadow(this.mc.font, s1, 2, 11, 0xFFFFFF);
            this.drawStringShadow(this.mc.font, s2, 2, 20, 0xFFFFFF);
            GLRenderer.setDepthMask(true);
            GLRenderer.enableState(State.DEPTH_TEST);
        }
        if (!this.overflowEntries.isEmpty()) {
            while (this.activeEntries.size() < 5 && !this.overflowEntries.isEmpty()) {
                IToastable toast = this.overflowEntries.get(0);
                this.overflowEntries.remove(0);
                this.activeEntries.add(new ToastEntry(toast, System.currentTimeMillis() + 1L));
                toast.onToastStart();
                this.sortList();
            }
        }
        ArrayList<ToastEntry> entriesCopy = new ArrayList<ToastEntry>(this.activeEntries);
        for (ToastEntry entry : entriesCopy) {
            long duration = System.currentTimeMillis() - entry.startTime;
            double animProgress = entry.toast.getAnimationProgress(duration);
            if (!(animProgress < 0.0) && !(animProgress > 1.0)) continue;
            this.endToast(entry.toast);
        }
        if (this.activeEntries.isEmpty() || this.mc.thePlayer == null) {
            return;
        }
        this.updateScale();
        GLRenderer.disableState(State.DEPTH_TEST);
        GLRenderer.setDepthMask(false);
        int yOff = 0;
        GLRenderer.enableState(State.BLEND);
        for (ToastEntry entry : this.activeEntries) {
            long duration = System.currentTimeMillis() - entry.startTime;
            double animProgress = entry.toast.getAnimationProgress(duration);
            double hideAmount = animProgress * 2.0;
            if (hideAmount > 1.0) {
                hideAmount = 2.0 - hideAmount;
            }
            hideAmount *= 4.0;
            if ((hideAmount = 1.0 - hideAmount) < 0.0) {
                hideAmount = 0.0;
            }
            hideAmount *= hideAmount;
            hideAmount *= hideAmount;
            int toastLeft = this.mc.resolution.getScaledWidthScreenCoords() - 160;
            int toastTop = (int)(-hideAmount * 32.0);
            if (toastTop < 0) {
                Scissor.enable(toastLeft, yOff, 160, 32);
            }
            this.renderToast(entry.toast, duration, toastLeft, toastTop + yOff);
            Scissor.disable();
            yOff += 32 + toastTop;
        }
        GLRenderer.disableState(State.BLEND);
        Lighting.disable();
        GLRenderer.globalSetLightEnabled(false);
        GLRenderer.disableState(State.DEPTH_TEST);
    }

    protected void renderToast(IToastable toast, long duration, int x, int y) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.globalSetLightEnabled(false);
        this.drawGuiIcon(x, y, 160, 32, TextureRegistry.getTexture(toast.getTexture(duration)));
        if (toast.messageOnly(duration)) {
            this.drawStringConstrained(this.mc.font, toast.getMessage(duration), x + 30, y + 7, 120, toast.messageColor(duration));
        } else {
            this.drawStringNoShadow(this.mc.font, toast.getTitle(duration), x + 30, y + 7, toast.titleColor(duration));
            this.drawStringNoShadow(this.mc.font, toast.getMessage(duration), x + 30, y + 18, toast.messageColor(duration));
        }
        GLRenderer.setDepthMask(true);
        Lighting.enableInventoryLight();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.DEPTH_TEST);
        ItemStack icon = toast.getIcon(duration);
        if (icon != null) {
            ItemModelDispatcher.getInstance().getDispatch(icon).renderGui(GLRenderer.getTessellator(), null, icon, x + 8, y + 8, LightmapHelper.getLightmapCoord(15, 15), 1.0f);
        }
        GLRenderer.disableState(State.DEPTH_TEST);
    }

    record ToastEntry(@NotNull IToastable toast, long startTime) {
        public static final Comparator<ToastEntry> TOAST_SORTER = (o1, o2) -> (int)(o1.startTime - o2.startTime);
    }
}

