/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ScaledResolution;
import net.minecraft.client.discord.RichPresenceHandlerThread;
import net.minecraft.client.enums.MusicFrequency;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.hud.component.HudComponents;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.OptionBoolean;
import net.minecraft.client.option.OptionColor;
import net.minecraft.client.option.OptionEnum;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.option.OptionFont;
import net.minecraft.client.option.OptionGuiScale;
import net.minecraft.client.option.OptionImmersiveMode;
import net.minecraft.client.option.OptionInteger;
import net.minecraft.client.option.OptionRange;
import net.minecraft.client.option.OptionString;
import net.minecraft.client.option.OptionTooltip;
import net.minecraft.client.option.OptionVolume;
import net.minecraft.client.option.enums.CloudQuality;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.option.enums.LeavesQuality;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.option.enums.ParticlesQuality;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.option.enums.TextOutlineQuality;
import net.minecraft.client.option.enums.TextureAnimation;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.Fonts;
import net.minecraft.client.world.chunk.provider.SelectedProvider;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ChatVisibility;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.slf4j.Logger;

public final class GameSettings {
    @NotNull
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private static final @NotNull Map<@NotNull String, @NotNull String> savedValues = new Object2ObjectOpenHashMap<String, String>();
    @NotNull
    private static final @NotNull Map<@NotNull String, @NotNull Option<?>> registeredOptions = new Object2ObjectOpenHashMap();
    @NotNull
    private static final @NotNull Map<@NotNull String, @NotNull KeyBinding> registeredKeys = new Object2ObjectOpenHashMap<String, KeyBinding>();
    @NotNull
    private static final @NotNull List<@NotNull Option<?>> allOptions = new ObjectArrayList();
    @NotNull
    private static final @NotNull List<@NotNull KeyBinding> allKeys = new ObjectArrayList<KeyBinding>();
    @NotNull
    public static final OptionInteger WINDOW_WIDTH = GameSettings.register(new OptionInteger("windowWidth", 854));
    @NotNull
    public static final OptionInteger WINDOW_HEIGHT = GameSettings.register(new OptionInteger("windowHeight", 480));
    @NotNull
    public static final OptionVolume MASTER_VOLUME = GameSettings.register(new OptionVolume("sound.master", 1.0f, SoundCategory.GUI_SOUNDS));
    @NotNull
    public static final OptionVolume MUSIC_VOLUME = GameSettings.register(new OptionVolume("sound.music", 1.0f, SoundCategory.MUSIC));
    @NotNull
    public static final OptionVolume WORLD_SOUNDS_VOLUME = GameSettings.register(new OptionVolume("sound.world", 1.0f, SoundCategory.WORLD_SOUNDS));
    @NotNull
    public static final OptionVolume ENTITY_SOUNDS_VOLUME = GameSettings.register(new OptionVolume("sound.entity", 1.0f, SoundCategory.ENTITY_SOUNDS));
    @NotNull
    public static final OptionVolume CAVE_SOUNDS_VOLUME = GameSettings.register(new OptionVolume("sound.cave", 1.0f, SoundCategory.CAVE_SOUNDS));
    @NotNull
    public static final OptionVolume GUI_SOUNDS_VOLUME = GameSettings.register(new OptionVolume("sound.gui", 1.0f, SoundCategory.GUI_SOUNDS));
    @NotNull
    public static final OptionVolume WEATHER_SOUNDS_VOLUME = GameSettings.register(new OptionVolume("sound.weather", 1.0f, SoundCategory.WEATHER_SOUNDS));
    @NotNull
    public static final OptionBoolean PLAY_TITLE_SCREEN_MUSIC = GameSettings.register(new OptionBoolean("playTitleScreenMusic", false));
    @NotNull
    public static final OptionFloat FOV = GameSettings.register((OptionFloat)new OptionFloat("fov", 0.40140846f).withDisplayStringProvider((mc, i18n, option) -> {
        if (((Float)option.value).floatValue() == 0.0f) {
            return i18n.translateKey("options.fov.min");
        }
        if (((Float)option.value).floatValue() == 1.0f) {
            return i18n.translateKey("options.fov.max");
        }
        return (int)(((Float)option.value).floatValue() * 100.0f + 30.0f) + "\u00b0";
    }));
    @NotNull
    public static final OptionFloat MOUSE_SENSITIVITY = GameSettings.register((OptionFloat)new OptionFloat("mouseSensitivity", 0.5f).withDisplayStringProvider((mc, i18n, option) -> {
        if (((Float)option.value).floatValue() == 0.0f) {
            return i18n.translateKey("options.mouseSensitivity.min");
        }
        if (((Float)option.value).floatValue() == 1.0f) {
            return i18n.translateKey("options.mouseSensitivity.max");
        }
        return (int)(((Float)option.value).floatValue() * 200.0f) + "%";
    }));
    @NotNull
    public static final OptionFloat SCREEN_PADDING = GameSettings.register((OptionFloat)new OptionFloat("screenPadding", 0.0f).withDisplayStringProvider((mc, i18n, option) -> {
        int percent = (int)(((Float)option.value).floatValue() * 100.0f);
        return percent + "%";
    }));
    @NotNull
    public static final OptionFloat GAMMA = GameSettings.register((OptionFloat)new OptionFloat("gamma", 0.5f).withDisplayStringProvider((mc, i18n, option) -> {
        int percent = (int)(((Float)option.value).floatValue() * 200.0f);
        return percent + "%";
    }));
    @NotNull
    public static final OptionFloat BRIGHTNESS = GameSettings.register((OptionFloat)new OptionFloat("brightness", 0.5f).withDisplayStringProvider((mc, i18n, option) -> {
        int percent = (int)(((Float)option.value).floatValue() * 200.0f);
        if (percent == 0) {
            return i18n.translateKey("options.brightness.min");
        }
        if (percent == 100) {
            return i18n.translateKey("options.brightness.default");
        }
        if (percent == 200) {
            return i18n.translateKey("options.brightness.max");
        }
        return percent + "%";
    }));
    @NotNull
    public static final OptionFloat FXAA = GameSettings.register(new OptionFloat("fxaa", 0.0f));
    @NotNull
    public static final OptionFloat CONTROLLER_SENSITIVITY = GameSettings.register(new OptionFloat("controllerSensitivity", 0.5f));
    @NotNull
    public static final OptionFloat CONTROLLER_MENU_SENSITIVITY = GameSettings.register(new OptionFloat("controllerMenuSensitivity", 0.5f));
    @NotNull
    public static final OptionFloat CONTROLLER_DEADZONE_LEFT = GameSettings.register(new OptionFloat("controllerDeadzoneL", 0.25f));
    @NotNull
    public static final OptionFloat CONTROLLER_DEADZONE_RIGHT = GameSettings.register(new OptionFloat("controllerDeadzoneR", 0.25f));
    @NotNull
    public static final OptionFloat BLOCK_OUTLINE_WIDTH = GameSettings.register(new OptionFloat("blockOutlineWidth", 0.25f));
    @NotNull
    public static final OptionFloat FLIGHT_SPEED = GameSettings.register(new OptionFloat("flightSpeed", 0.5f));
    @NotNull
    public static final OptionFloat FLIGHT_SMOOTHNESS = GameSettings.register(new OptionFloat("flightSmoothness", 0.5f));
    @NotNull
    public static final OptionBoolean INVERT_MOUSE = GameSettings.register(new OptionBoolean("invertYMouse", false));
    @NotNull
    public static final OptionBoolean RAW_MOUSE_INPUT = GameSettings.register((OptionBoolean)new OptionBoolean("rawMouseInput", false).addOnChangeCallback((mc, option) -> mc.mouseInput.setRawInput((Boolean)option.value)));
    @NotNull
    public static final OptionBoolean VIEW_BOBBING = GameSettings.register(new OptionBoolean("bobView", true));
    @NotNull
    public static final OptionBoolean TRANSPARENCY_DEPTH_CHECK = GameSettings.register(new OptionBoolean("transparencyDepthCheck", true));
    @NotNull
    public static final OptionEnum<ParticlesQuality> PARTICLES_QUALITY = GameSettings.register(new OptionEnum<ParticlesQuality>("particleQuality", ParticlesQuality.class, ParticlesQuality.ALL));
    @NotNull
    public static final OptionRange PARTICLES_CAP = GameSettings.register(new OptionRange("particleCap", 4000, 500, 15000));
    @NotNull
    public static final OptionFloat PARTICLE_RENDER_DISTANCE = GameSettings.register((OptionFloat)new OptionFloat("particleRenderDistance", 1.0f).withDisplayStringProvider((mc, i18n, option) -> {
        int percent = MathHelper.round(((Float)option.value).floatValue() * 100.0f);
        if (percent == 100) {
            return i18n.translateKey("options.particleRenderDistance.default");
        }
        return percent + "%";
    }));
    @NotNull
    public static final OptionRange CHUNK_REBUILDS_PER_FRAME = GameSettings.register(new OptionRange("chunkRebuilds", 6, 2, 12));
    @NotNull
    public static final OptionBoolean FRUSTUM_CULLING = GameSettings.register(new OptionBoolean("frustumCulling", true));
    @NotNull
    public static final OptionBoolean ENTITY_SHADOWS = GameSettings.register(new OptionBoolean("entityShadows", true));
    @NotNull
    public static final OptionEnum<TextOutlineQuality> TEXT_OUTLINE_QUALITY = GameSettings.register(new OptionEnum<TextOutlineQuality>("textOutlineQuality", TextOutlineQuality.class, TextOutlineQuality.FANCY));
    @NotNull
    public static final OptionEnum<CloudQuality> CLOUD_QUALITY = GameSettings.register(new OptionEnum<CloudQuality>("cloudQuality", CloudQuality.class, CloudQuality.FANCY));
    @NotNull
    public static final OptionEnum<LeavesQuality> LEAVES_QUALITY = GameSettings.register((OptionEnum)new OptionEnum<LeavesQuality>("leavesQuality", LeavesQuality.class, LeavesQuality.FANCY).addOnChangeCallback((mc, option) -> mc.renderGlobal.allChanged()));
    @NotNull
    public static final OptionBoolean TREE_SHADOWS = GameSettings.register((OptionBoolean)new OptionBoolean("treeShadows", true).addOnChangeCallback((mc, option) -> mc.renderGlobal.allChanged()));
    @NotNull
    public static final OptionBoolean CONNECTED_GLASS = GameSettings.register((OptionBoolean)new OptionBoolean("connectedGlass", false).addOnChangeCallback((mc, option) -> mc.renderGlobal.allChanged()));
    @NotNull
    public static final OptionBoolean AMBIENT_OCCLUSION = GameSettings.register((OptionBoolean)new OptionBoolean("ambientOcclusion", true).addOnChangeCallback((mc, option) -> mc.renderGlobal.allChanged()));
    @NotNull
    public static final OptionBoolean ITEMS_3D = GameSettings.register(new OptionBoolean("3Ditems", false));
    @NotNull
    public static final OptionBoolean SMOOTH_CAMERA = GameSettings.register(new OptionBoolean("smoothCamera", false));
    @NotNull
    public static final OptionBoolean LOCK_CAMERA = GameSettings.register(new OptionBoolean("lockCamera", false));
    @NotNull
    public static final OptionBoolean BIOME_WATER = GameSettings.register((OptionBoolean)new OptionBoolean("biomeWater", true).addOnChangeCallback((mc, option) -> {
        mc.textureManager.updateDynamicTextures(false);
        mc.renderGlobal.allChanged();
    }));
    @NotNull
    public static final OptionBoolean VIGNETTE = GameSettings.register(new OptionBoolean("vignette", true));
    @NotNull
    public static final OptionBoolean SHOW_PLAYER_LIST = GameSettings.register(new OptionBoolean("showPlayerList", false));
    @NotNull
    public static final OptionBoolean SLIME_PARTICLES = GameSettings.register(new OptionBoolean("slimeParticles", true));
    @NotNull
    public static final OptionString SHADER_OVERRIDE = GameSettings.register(new OptionString("shaderOverride", ""));
    @NotNull
    public static final OptionBoolean AUTO_HIT = GameSettings.register(new OptionBoolean("autoHit", true));
    @NotNull
    public static final OptionBoolean EASY_BRIDGE = GameSettings.register(new OptionBoolean("easyBridge", true));
    @NotNull
    public static final OptionBoolean FOOD_HEALTH_REGEN_OVERLAY = GameSettings.register(new OptionBoolean("foodHealthRegenOverlay", true));
    @NotNull
    public static final OptionBoolean FPS_IN_OVERLAY = GameSettings.register(new OptionBoolean("fpsInOverlay", false));
    @NotNull
    public static final OptionBoolean VERSION_IN_OVERLAY = GameSettings.register(new OptionBoolean("versionInOverlay", false));
    @NotNull
    public static final OptionBoolean CONTROLLER_SWAP_SHOULDER_BUTTONS = GameSettings.register(new OptionBoolean("controllerSwapShoulderButtons", false));
    @NotNull
    public static final OptionBoolean CONTROLLER_SWAP_AB = GameSettings.register(new OptionBoolean("controllerSwapAB", false));
    @NotNull
    public static final OptionBoolean CONTROLLER_SWAP_XY = GameSettings.register(new OptionBoolean("controllerSwapXY", false));
    @NotNull
    public static final OptionBoolean CLOUDS = GameSettings.register(new OptionBoolean("clouds", true));
    @NotNull
    public static final OptionFloat CLOUD_HEIGHT = GameSettings.register((OptionFloat)new OptionFloat("cloudHeight", 0.0f).withDisplayStringProvider((mc, i18n, option) -> {
        int percent = (int)(((Float)option.value).floatValue() * 100.0f + 100.0f);
        if (percent == 100) {
            return i18n.translateKey("options.cloudHeight.default");
        }
        return percent + "%";
    }));
    @NotNull
    public static final OptionFloat ENTITY_RENDER_DISTANCE = GameSettings.register((OptionFloat)new OptionFloat("entityRenderDistance", 1.0f).withDisplayStringProvider((mc, i18n, option) -> {
        int percent = MathHelper.round(((Float)option.value).floatValue() * 100.0f);
        if (percent == 100) {
            return i18n.translateKey("options.entityRenderDistance.default");
        }
        return percent + "%";
    }));
    @NotNull
    public static final OptionBoolean ARMOR_DURABILITY_OVERLAY = GameSettings.register(new OptionBoolean("armorDurabilityOverlay", false));
    @NotNull
    public static final OptionBoolean ARMOR_PROTECTION_OVERLAY = GameSettings.register(new OptionBoolean("armorProtectionOverlay", true));
    @NotNull
    public static final OptionBoolean HELD_ITEM_COUNT_OVERLAY = GameSettings.register(new OptionBoolean("heldItemCountOverlay", false));
    @NotNull
    public static final OptionBoolean PAUSE_ON_LOST_FOCUS = GameSettings.register(new OptionBoolean("pauseOnLostFocus", true));
    @NotNull
    public static final OptionBoolean SHOW_DEBUG_SCREEN = GameSettings.register(new OptionBoolean("showDebugScreen", false));
    @NotNull
    public static final OptionBoolean SHOW_FRAME_TIMES = GameSettings.register(new OptionBoolean("showFrameTimes", false));
    @NotNull
    public static final OptionBoolean SHOW_ITEM_DEBUG_INFO = GameSettings.register(new OptionBoolean("showItemDebugInfo", false));
    @NotNull
    public static final OptionBoolean SHOW_CHUNK_BORDERS = GameSettings.register(new OptionBoolean("showChunkBorders", false));
    @NotNull
    public static final OptionBoolean SHOW_COLLISION_BOXES = GameSettings.register(new OptionBoolean("showCollisionBoxes", false));
    @NotNull
    public static final OptionBoolean SWAP_CRAFTING_BUTTONS = GameSettings.register(new OptionBoolean("swapCraftingButtons", false));
    @NotNull
    public static final OptionBoolean FORCE_ONSCREEN_KEYBOARD = GameSettings.register(new OptionBoolean("forceOnscreenKeyboard", false));
    @NotNull
    public static final OptionEnum<PlacementMode> PLACEMENT_MODE = GameSettings.register((OptionEnum)new OptionEnum<PlacementMode>("placementMode", PlacementMode.class, PlacementMode.DEFAULT).setIsSlider(false).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.syncPlacementMode();
        }
    }));
    @NotNull
    public static final OptionBoolean DISCORD_RICH_PRESENCE = GameSettings.register((OptionBoolean)new OptionBoolean("discordRichPresence", false).addOnChangeCallback((mc, option) -> {
        if (((Boolean)option.value).booleanValue() && mc.rpcThread == null) {
            mc.rpcThread = new RichPresenceHandlerThread(mc);
            mc.rpcThread.setName("Discord RPC Thread");
            mc.rpcThread.start();
        }
    }));
    @NotNull
    public static final OptionImmersiveMode IMMERSIVE_MODE = GameSettings.register(new OptionImmersiveMode());
    @NotNull
    public static final OptionColor GUI_BACKGROUND_COLOR = GameSettings.register(new OptionColor("guiBackgroundColor", new Color().setARGB(-1072689136)));
    @NotNull
    public static final OptionEnum<Difficulty> DIFFICULTY = GameSettings.register((OptionEnum)new OptionEnum<Difficulty>("difficulty", Difficulty.class, Difficulty.NORMAL).addOnChangeCallback((mc, option) -> {
        if (mc.currentWorld != null) {
            mc.currentWorld.setDifficulty((Difficulty)((Object)((Object)option.value)), false);
        }
    }));
    @NotNull
    public static final OptionInteger THIRD_PERSON_VIEW = GameSettings.register(new OptionInteger("thirdPersonView", 0));
    @NotNull
    public static final OptionRange RENDER_DISTANCE = GameSettings.register((OptionRange)new OptionRange("renderDistance", 12, 2, 32).addOnChangeCallback((mc, option) -> {
        if (mc.currentScreen instanceof ScreenOptions) {
            ScreenOptions.queueReload = true;
        } else {
            mc.renderGlobal.allChanged();
        }
    }));
    @NotNull
    public static final OptionBoolean ENABLE_VSYNC = GameSettings.register((OptionBoolean)new OptionBoolean("enableVsync", false).addOnChangeCallback((mc, option) -> mc.gameWindow.setVsync((Boolean)option.value)));
    @NotNull
    public static final OptionEnum<ChatVisibility> chatVisibility = GameSettings.register(new OptionEnum<ChatVisibility>("chatVisibility", ChatVisibility.class, ChatVisibility.SHOW_ALL));
    @NotNull
    public static final OptionRange CUSTOM_FPS_LIMIT = GameSettings.register((OptionRange)new OptionRange("customFpsLimit", 165, 301).withDisplayStringProvider((mc, i18n, option) -> {
        int value = (Integer)option.value;
        int maxValue = 300;
        if (((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue()) {
            return String.valueOf(mc.gameWindow.getFrequency());
        }
        if (value > maxValue) {
            option.set(maxValue);
        }
        if (value < 15) {
            option.set(0);
            return i18n.translateKey("options.customFpsLimit.unlimited");
        }
        return option.toOptionsString();
    }));
    @NotNull
    public static final OptionGuiScale GUI_SCALE = GameSettings.register((OptionGuiScale)((Option)new OptionGuiScale("guiScale", 0).addOnChangeCallback((mc, option) -> {
        int max = ScaledResolution.getMaxScale(mc.gameWindow.getWidthScreenCoords(), mc.gameWindow.getHeightScreenCoords());
        option.value = ((Integer)option.value + max) % max;
        mc.resolution.setScale((Integer)option.value);
        if (mc.currentScreen != null) {
            mc.currentScreen.opened(mc.resolution.getScaledWidthScreenCoords(), mc.resolution.getScaledHeightScreenCoords());
        }
    })).withDisplayStringProvider((mc, i18n, option) -> {
        if ((Integer)option.value == 0) {
            return i18n.translateKey("options.guiScale.auto");
        }
        return String.valueOf(option.value) + "x";
    }));
    @NotNull
    public static final OptionInteger OVERLAY_MODE = GameSettings.register(new OptionInteger("overlayMode", 0));
    @NotNull
    public static final OptionInteger ROTATION_OVERLAY_MODE = GameSettings.register(new OptionInteger("rotationOverlayMode", 0));
    @NotNull
    public static final OptionEnum<TextureAnimation> TEXTURE_ANIMATIONS = GameSettings.register((OptionEnum)new OptionEnum<TextureAnimation>("animations", TextureAnimation.class, TextureAnimation.CUSTOM).addOnChangeCallback((mc, option) -> {
        mc.textureManager.refreshTexturesAndDisplayErrors();
        mc.textureManager.updateDynamicTextures(false);
        mc.renderGlobal.allChanged();
    }));
    @NotNull
    public static final OptionBoolean CUSTOM_TEXTURE_ANIMATIONS = GameSettings.register((OptionBoolean)new OptionBoolean("customAnimations", true).addOnChangeCallback((mc, option) -> {
        mc.textureManager.refreshTexturesAndDisplayErrors();
        mc.textureManager.updateDynamicTextures(false);
        mc.renderGlobal.allChanged();
    }));
    @NotNull
    public static final OptionInteger PLAYER_LIST_POSITION = GameSettings.register(new OptionInteger("playerListPosition", 2));
    @NotNull
    public static final OptionBoolean HELD_ITEM_TOOLTIPS = GameSettings.register(new OptionBoolean("heldItemTooltips", true));
    @NotNull
    public static final OptionFloat COLOR_CORRECTION = GameSettings.register(new OptionFloat("colorCorrection", 0.5f));
    @NotNull
    public static final OptionBoolean SNEAK_TOGGLE = GameSettings.register(new OptionBoolean("sneakToggle", false));
    @NotNull
    public static final OptionFloat AUTOSAVE_TIMER = GameSettings.register((OptionFloat)((Option)new OptionFloat("autosaveTimer", 0.041666668f).addOnChangeCallback((mc, option) -> {
        int max = 24;
        option.value = Float.valueOf((((Float)option.value).floatValue() + (float)max) % (float)max);
    })).withDisplayStringProvider((mc, i18n, option) -> {
        int timer = (int)(((Float)option.value).floatValue() * 24.0f);
        if (timer == 0) {
            return i18n.translateKey("options.autosaveTimer.off");
        }
        return timer * 5 + " seconds";
    }));
    @NotNull
    public static final OptionBoolean ENABLE_ITEM_DRAGGING = GameSettings.register(new OptionBoolean("enableItemDragging", true));
    @NotNull
    public static final OptionRange BLOOM = GameSettings.register((OptionRange)new OptionRange("bloom", 0, 3).withDisplayStringProvider((mc, i18n, option) -> {
        if ((Integer)option.value == 0) {
            return i18n.translateKey("options.off");
        }
        if ((Integer)option.value == 1) {
            return i18n.translateKey("options.bloom.low");
        }
        if ((Integer)option.value == 2) {
            return i18n.translateKey("options.bloom.high");
        }
        return option.toOptionsString();
    }));
    @NotNull
    public static final OptionEnum<RenderScale> RENDER_SCALE = GameSettings.register(new OptionEnum<RenderScale>("renderScale", RenderScale.class, RenderScale.SCALE_100));
    @NotNull
    public static final OptionBoolean HEAT_HAZE = GameSettings.register(new OptionBoolean("heatHaze", false));
    @NotNull
    public static final OptionBoolean ALPHA_MENU = GameSettings.register(new OptionBoolean("old", false));
    @NotNull
    public static final OptionBoolean ENABLE_ITEM_CLUMPING = GameSettings.register(new OptionBoolean("enableItemClumping", true));
    @NotNull
    public static final OptionEnum<DescriptionPromptEnum> ITEM_DESCRIPTIONS = GameSettings.register(new OptionEnum<DescriptionPromptEnum>("itemDescriptions", DescriptionPromptEnum.class, DescriptionPromptEnum.PROMPT));
    @NotNull
    public static final OptionBoolean TURN_WITH_VEHICLE = GameSettings.register(new OptionBoolean("turnWithVehicle", true));
    @NotNull
    public static final OptionBoolean DISABLE_CRASH_HANDLER = GameSettings.register(new OptionBoolean("disableCrashHandler", false));
    @NotNull
    public static final OptionEnum<SelectedProvider> CHUNK_PROVIDER = GameSettings.register(new OptionEnum<SelectedProvider>("enableThreadedChunkProvider", SelectedProvider.class, SelectedProvider.THREADED));
    @NotNull
    public static final OptionBoolean MUSIC_TOASTS = GameSettings.register(new OptionBoolean("musicToasts", true));
    @NotNull
    public static final OptionEnum<MusicFrequency> MUSIC_FREQUENCY = GameSettings.register((OptionEnum)new OptionEnum<MusicFrequency>("musicFrequency", MusicFrequency.class, MusicFrequency.DEFAULT).addOnChangeCallback((mc, option) -> mc.sndManager.resetMusicTicks()));
    @NotNull
    public static final OptionBoolean ENABLE_DEV_RESOURCE_LOADING = GameSettings.register(new OptionBoolean("enableDevResourceLoading", false));
    @NotNull
    public static final OptionBoolean DOWNLOAD_SOUNDFILES = GameSettings.register(new OptionBoolean("downloadSoundfiles", true));
    @NotNull
    public static final OptionBoolean ALLOW_SOUND_OVERRIDES = GameSettings.register(new OptionBoolean("allowSoundOverrides", false));
    @NotNull
    public static final OptionBoolean LOAD_ALL_SOUNDS = GameSettings.register(new OptionBoolean("loadAllSounds", false));
    @NotNull
    public static final OptionBoolean OVERLAY_SHOW_COORDS = GameSettings.register(new OptionBoolean("overlayShowCoords", true));
    @NotNull
    public static final OptionBoolean OVERLAY_SHOW_DIRECTION = GameSettings.register(new OptionBoolean("overlayShowDirection", true));
    @NotNull
    public static final OptionBoolean OVERLAY_SHOW_TIME = GameSettings.register(new OptionBoolean("overlayShowTime", true));
    @NotNull
    public static final OptionBoolean OVERLAY_SHOW_SEASON = GameSettings.register(new OptionBoolean("overlayShowSeason", true));
    @NotNull
    public static final OptionBoolean OVERLAY_SHOW_WEATHER = GameSettings.register(new OptionBoolean("overlayShowWeather", true));
    @NotNull
    public static final OptionBoolean OVERLAY_SHOW_BIOME = GameSettings.register(new OptionBoolean("overlayShowBiome", true));
    @NotNull
    public static final @NotNull OptionBoolean @NotNull [] OVERLAY_ELEMENTS = new OptionBoolean[]{OVERLAY_SHOW_COORDS, OVERLAY_SHOW_DIRECTION, OVERLAY_SHOW_TIME, OVERLAY_SHOW_SEASON, OVERLAY_SHOW_WEATHER, OVERLAY_SHOW_BIOME};
    @NotNull
    public static final OptionString LAST_SERVER = GameSettings.register(new OptionString("lastServer", ""));
    @NotNull
    public static final OptionString SKIN = GameSettings.register(new OptionString("skin", "Default"));
    @NotNull
    public static final OptionString SELECTED_CONTROLLER = GameSettings.register(new OptionString("selectedController", ""));
    @NotNull
    public static final OptionString LANGUAGE = GameSettings.register((OptionString)new OptionString("language", "en_US").addOnChangeCallback((mc, option) -> {
        if (mc.currentScreen != null) {
            mc.currentScreen.opened(mc.resolution.getScaledWidthScreenCoords(), mc.resolution.getScaledHeightScreenCoords());
        }
    }));
    @NotNull
    public static final OptionRange MIPMAP_LEVELS = GameSettings.register((OptionRange)new OptionRange("mipmapLevels", 0, 5).addOnChangeCallback((mc, option) -> mc.textureManager.refreshTexturesAndDisplayErrors()));
    @NotNull
    public static final OptionEnum<MipmapType> MIPMAP_TYPE = GameSettings.register((OptionEnum)new OptionEnum<MipmapType>("mipmapType", MipmapType.class, MipmapType.SMOOTH).addOnChangeCallback((mc, option) -> mc.textureManager.refreshTexturesAndDisplayErrors()));
    @NotNull
    public static final OptionBoolean FOV_MODIFICATION = GameSettings.register(new OptionBoolean("fov.modification", true));
    @NotNull
    public static final OptionBoolean SCREEN_MOTION_EFFECTS = GameSettings.register(new OptionBoolean("screen.motion.effects", true));
    @NotNull
    public static final OptionBoolean FULLSCREEN = GameSettings.register((OptionBoolean)new OptionBoolean("fullscreen", Minecraft.isClientASteamDeck()).addOnChangeCallback((mc, option) -> mc.gameWindow.updateWindowState()));
    @NotNull
    public static final OptionBoolean BORDERLESS_FULLSCREEN = GameSettings.register((OptionBoolean)new OptionBoolean("borderlessFullscreen", true).addOnChangeCallback((mc, option) -> {
        if (((Boolean)GameSettings.FULLSCREEN.value).booleanValue()) {
            mc.gameWindow.updateWindowState();
        }
    }));
    @NotNull
    public static final OptionBoolean START_IN_FULLSCREEN = GameSettings.register(new OptionBoolean("startInFullscreen", true));
    @NotNull
    public static final OptionTooltip TOOLTIP_STYLE = GameSettings.register((OptionTooltip)new OptionTooltip("tooltipStyle", "default").withDisplayStringProvider((mc, i18n, option) -> {
        TooltipElement.Style style = TooltipElement.styleMap.get(option.value);
        if (style != null) {
            return i18n.translateKey(style.translationKey);
        }
        return "Unknown";
    }));
    @NotNull
    public static final OptionFont FONT = GameSettings.register((OptionFont)new OptionFont("font", Fonts.DEFAULT).withDisplayStringProvider((mc, i18n, option) -> i18n.translateKey("options.font." + ((Font)option.value).getKey())));
    @NotNull
    public static final OptionEnum<LightmapStyle> LIGHTMAP_STYLE = GameSettings.register((OptionEnum)new OptionEnum<LightmapStyle>("lightmapStyle", LightmapStyle.class, LightmapStyle.GRAY).withDisplayStringProvider((mc, i18n, option) -> i18n.translateKey(((LightmapStyle)((Object)((Object)option.value))).getTranslationKey())));
    @NotNull
    public static final OptionBoolean CUSTOM_LIGHTMAP = GameSettings.register((OptionBoolean)new OptionBoolean("customLightmap", true).addOnChangeCallback((mc, option) -> mc.worldRenderer.lightmapHelper.setup()));
    @NotNull
    public static final OptionBoolean FOG = GameSettings.register(new OptionBoolean("fog", true));
    @NotNull
    public static final OptionBoolean HIDE_UNDISCOVERED_ITEMS = GameSettings.register(new OptionBoolean("hideUndiscoveredItems", true));
    @NotNull
    public static final OptionBoolean MUTE_ON_LOST_FOCUS = GameSettings.register(new OptionBoolean("muteOnLostFocus", false));
    @NotNull
    public static final OptionBoolean AURORA = GameSettings.register(new OptionBoolean("aurora", true));
    @NotNull
    public static final OptionBoolean MOB_VARIANTS = GameSettings.register(new OptionBoolean("mobVariants", true));
    @NotNull
    public static final OptionEnum<Colorblindness> COLORBLINDNESS_FIX = GameSettings.register(new OptionEnum<Colorblindness>("colorblindnessFix", Colorblindness.class, Colorblindness.NONE));
    @NotNull
    public static final OptionBoolean SUBTITLES = GameSettings.register(new OptionBoolean("subtitles", false));
    @NotNull
    public static final OptionBoolean DEVELOPER_MODE = GameSettings.register(new OptionBoolean("developerMode", false));
    @NotNull
    public static final OptionBoolean VIEW_SUPPORT_MODE = GameSettings.register(new OptionBoolean("viewSupportMode", false));
    @NotNull
    public static final OptionBoolean ENABLE_HOLIDAY_TEXTURES = GameSettings.register((OptionBoolean)new OptionBoolean("enableHolidayTextures", true).addOnChangeCallback((mc, option) -> {
        mc.textureManager.refreshTexturesAndDisplayErrors();
        mc.renderGlobal.allChanged();
    }));
    @NotNull
    public static final OptionBoolean DYNAMIC_CURSOR = GameSettings.register(new OptionBoolean("dynamicCursor", true));
    @NotNull
    public static final OptionBoolean DEV_MODELS = GameSettings.register(new OptionBoolean("devModels", true));
    @NotNull
    public static final OptionBoolean DO_JCE_CHECK = GameSettings.register(new OptionBoolean("doJCECheck", true));
    @NotNull
    public static final OptionString UUID_SERVER = GameSettings.register(new OptionString("uuidServer", "https://api.minecraftservices.com/minecraft/profile/lookup/name/%s"));
    @NotNull
    public static final OptionBoolean PLAYER_LEFT_HANDED = GameSettings.register((OptionBoolean)new OptionBoolean("player.left.handed", false).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setLeftHand((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionBoolean PLAYER_CAPE = GameSettings.register((OptionBoolean)new OptionBoolean("player.cape", true).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setCape((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionBoolean PLAYER_HAT = GameSettings.register((OptionBoolean)new OptionBoolean("player.hat", true).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setHat((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionBoolean PLAYER_JACKET = GameSettings.register((OptionBoolean)new OptionBoolean("player.jacket", true).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setJacket((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionBoolean PLAYER_SLEEVE_LEFT = GameSettings.register((OptionBoolean)new OptionBoolean("player.sleeve.left", true).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setSleeveLeft((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionBoolean PLAYER_SLEEVE_RIGHT = GameSettings.register((OptionBoolean)new OptionBoolean("player.sleeve.right", true).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setSleeveRight((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionBoolean PLAYER_PANT_LEFT = GameSettings.register((OptionBoolean)new OptionBoolean("player.pant.left", true).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setPantLeft((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionBoolean PLAYER_PANT_RIGHT = GameSettings.register((OptionBoolean)new OptionBoolean("player.pant.right", true).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setPantRight((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionBoolean PLAYER_DEV_MODEL = GameSettings.register((OptionBoolean)new OptionBoolean("player.devmodel", true).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setDevModelEnabled((Boolean)option.value);
        }
    }));
    @NotNull
    public static final OptionEnum<Player.PlayerConfig.HurtSound> PLAYER_HURT_SOUND = GameSettings.register((OptionEnum)new OptionEnum<Player.PlayerConfig.HurtSound>("player.hurtsound", Player.PlayerConfig.HurtSound.class, Player.PlayerConfig.HurtSound.MASCULINE).addOnChangeCallback((mc, option) -> {
        if (mc.thePlayer != null) {
            mc.thePlayer.playerConfig.setHurtSound((Player.PlayerConfig.HurtSound)((Object)((Object)option.value)));
        }
    }));
    @NotNull
    public static final KeyBinding KEY_ATTACK = GameSettings.register(new KeyBinding("key.attack").setDefault(InputDevice.mouse, 0));
    @NotNull
    public static final KeyBinding KEY_INTERACT = GameSettings.register(new KeyBinding("key.interact").setDefault(InputDevice.mouse, 1));
    @NotNull
    public static final KeyBinding KEY_PICK_BLOCK = GameSettings.register(new KeyBinding("key.pickBlock").setDefault(InputDevice.mouse, 2));
    @NotNull
    public static final KeyBinding KEY_SORT_INVENTORY = GameSettings.register(new KeyBinding("key.sortInventory").setDefault(InputDevice.mouse, 2));
    @NotNull
    public static final KeyBinding KEY_FORWARD = GameSettings.register(new KeyBinding("key.forward").setDefault(InputDevice.keyboard, Keyboard.KEY_W));
    @NotNull
    public static final KeyBinding KEY_LEFT = GameSettings.register(new KeyBinding("key.left").setDefault(InputDevice.keyboard, Keyboard.KEY_A));
    @NotNull
    public static final KeyBinding KEY_BACK = GameSettings.register(new KeyBinding("key.back").setDefault(InputDevice.keyboard, Keyboard.KEY_S));
    @NotNull
    public static final KeyBinding KEY_RIGHT = GameSettings.register(new KeyBinding("key.right").setDefault(InputDevice.keyboard, Keyboard.KEY_D));
    @NotNull
    public static final KeyBinding KEY_JUMP = GameSettings.register(new KeyBinding("key.jump").setDefault(InputDevice.keyboard, Keyboard.KEY_SPACE));
    @NotNull
    public static final KeyBinding KEY_INVENTORY = GameSettings.register(new KeyBinding("key.inventory").setDefault(InputDevice.keyboard, Keyboard.KEY_E));
    @NotNull
    public static final KeyBinding KEY_DROP = GameSettings.register(new KeyBinding("key.drop").setDefault(InputDevice.keyboard, Keyboard.KEY_Q));
    @NotNull
    public static final KeyBinding KEY_CHAT = GameSettings.register(new KeyBinding("key.chat").setDefault(InputDevice.keyboard, Keyboard.KEY_T));
    @NotNull
    public static final KeyBinding KEY_COMMAND = GameSettings.register(new KeyBinding("key.command").setDefault(InputDevice.keyboard, Keyboard.KEY_SLASH));
    @NotNull
    public static final KeyBinding KEY_TOGGLE_FOG = GameSettings.register(new KeyBinding("key.fog"));
    @NotNull
    public static final KeyBinding KEY_TOGGLE_GAMMA = GameSettings.register(new KeyBinding("key.gamma"));
    @NotNull
    public static final KeyBinding KEY_SNEAK = GameSettings.register(new KeyBinding("key.sneak").setDefault(InputDevice.keyboard, Keyboard.KEY_LSHIFT));
    @NotNull
    public static final KeyBinding KEY_FLY = GameSettings.register(new KeyBinding("key.fly").setDefault(InputDevice.keyboard, Keyboard.KEY_LCONTROL));
    @NotNull
    public static final KeyBinding KEY_GUIDEBOOK = GameSettings.register(new KeyBinding("key.guidebook").setDefault(InputDevice.keyboard, Keyboard.KEY_R));
    @NotNull
    public static final KeyBinding KEY_DESCRIPTION = GameSettings.register(new KeyBinding("key.description").setDefault(InputDevice.keyboard, Keyboard.KEY_LCONTROL));
    @NotNull
    public static final KeyBinding KEY_SHOW_RECIPE = GameSettings.register(new KeyBinding("key.showRecipe").setDefault(InputDevice.keyboard, Keyboard.KEY_R));
    @NotNull
    public static final KeyBinding KEY_SHOW_USAGE = GameSettings.register(new KeyBinding("key.showUsage").setDefault(InputDevice.keyboard, Keyboard.KEY_U));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_LEFT = GameSettings.register(new KeyBinding("key.hotbar.left").setDefault(InputDevice.keyboard, Keyboard.KEY_COMMA));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_RIGHT = GameSettings.register(new KeyBinding("key.hotbar.right").setDefault(InputDevice.keyboard, Keyboard.KEY_PERIOD));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SWITCH = GameSettings.register(new KeyBinding("key.hotbar.switch").setDefault(InputDevice.keyboard, Keyboard.KEY_TAB));
    @NotNull
    public static final KeyBinding KEY_HIDE_GUI = GameSettings.register(new KeyBinding("key.immersiveMode").setDefault(InputDevice.keyboard, Keyboard.KEY_F1));
    @NotNull
    public static final KeyBinding KEY_SCREENSHOT = GameSettings.register(new KeyBinding("key.screenshot").setDefault(InputDevice.keyboard, Keyboard.KEY_F2));
    @NotNull
    public static final KeyBinding KEY_TOGGLE_DEBUG = GameSettings.register(new KeyBinding("key.toggleDebug").setDefault(InputDevice.keyboard, Keyboard.KEY_F3));
    @NotNull
    public static final KeyBinding KEY_TOGGLE_OVERLAY = GameSettings.register(new KeyBinding("key.toggleOverlay").setDefault(InputDevice.keyboard, Keyboard.KEY_F4));
    @NotNull
    public static final KeyBinding KEY_SWITCH_PERSPECTIVE = GameSettings.register(new KeyBinding("key.switchPerspective").setDefault(InputDevice.keyboard, Keyboard.KEY_F5));
    @NotNull
    public static final KeyBinding KEY_CINEMATIC_CAMERA = GameSettings.register(new KeyBinding("key.cinematicCamera").setDefault(InputDevice.keyboard, Keyboard.KEY_F8));
    @NotNull
    public static final KeyBinding KEY_FULL_SCREEN = GameSettings.register(new KeyBinding("key.fullscreen").setDefault(InputDevice.keyboard, Keyboard.KEY_F11));
    @NotNull
    public static final KeyBinding KEY_RELEASE_CURSOR = GameSettings.register(new KeyBinding("key.debug.releasecursor").setDefault(InputDevice.keyboard, Keyboard.KEY_F12));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_1 = GameSettings.register(new KeyBinding("key.hotbar.1").setDefault(InputDevice.keyboard, Keyboard.KEY_1));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_2 = GameSettings.register(new KeyBinding("key.hotbar.2").setDefault(InputDevice.keyboard, Keyboard.KEY_2));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_3 = GameSettings.register(new KeyBinding("key.hotbar.3").setDefault(InputDevice.keyboard, Keyboard.KEY_3));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_4 = GameSettings.register(new KeyBinding("key.hotbar.4").setDefault(InputDevice.keyboard, Keyboard.KEY_4));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_5 = GameSettings.register(new KeyBinding("key.hotbar.5").setDefault(InputDevice.keyboard, Keyboard.KEY_5));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_6 = GameSettings.register(new KeyBinding("key.hotbar.6").setDefault(InputDevice.keyboard, Keyboard.KEY_6));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_7 = GameSettings.register(new KeyBinding("key.hotbar.7").setDefault(InputDevice.keyboard, Keyboard.KEY_7));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_8 = GameSettings.register(new KeyBinding("key.hotbar.8").setDefault(InputDevice.keyboard, Keyboard.KEY_8));
    @NotNull
    public static final KeyBinding KEY_HOT_BAR_SLOT_9 = GameSettings.register(new KeyBinding("key.hotbar.9").setDefault(InputDevice.keyboard, Keyboard.KEY_9));
    @NotNull
    public static final KeyBinding KEY_LOOK_LEFT = GameSettings.register(new KeyBinding("key.look.left").setDefault(InputDevice.keyboard, Keyboard.KEY_LEFT));
    @NotNull
    public static final KeyBinding KEY_LOOK_RIGHT = GameSettings.register(new KeyBinding("key.look.right").setDefault(InputDevice.keyboard, Keyboard.KEY_RIGHT));
    @NotNull
    public static final KeyBinding KEY_LOOK_UP = GameSettings.register(new KeyBinding("key.look.up").setDefault(InputDevice.keyboard, Keyboard.KEY_UP));
    @NotNull
    public static final KeyBinding KEY_LOOK_DOWN = GameSettings.register(new KeyBinding("key.look.down").setDefault(InputDevice.keyboard, Keyboard.KEY_DOWN));
    @NotNull
    public static final KeyBinding KEY_CENTER_VIEW = GameSettings.register(new KeyBinding("key.look.center").setDefault(InputDevice.keyboard, Keyboard.KEY_END));
    @NotNull
    public static final KeyBinding KEY_ZOOM = GameSettings.register(new KeyBinding("key.zoom").setDefault(InputDevice.keyboard, Keyboard.KEY_C));
    @NotNull
    public static final KeyBinding KEY_PLAYER_LIST = GameSettings.register(new KeyBinding("key.playerList").setDefault(InputDevice.keyboard, Keyboard.KEY_L));
    @NotNull
    public static final KeyBinding KEY_PHOTO_MODE = GameSettings.register(new KeyBinding("key.photoMode").setDefault(InputDevice.keyboard, Keyboard.KEY_P));
    @NotNull
    public static final KeyBinding KEY_LOCK_ROTATION = GameSettings.register(new KeyBinding("key.lockRotation").setDefault(InputDevice.keyboard, Keyboard.KEY_Z));
    @NotNull
    public static final KeyBinding KEY_AUTO_WALK = GameSettings.register(new KeyBinding("key.autoWalk"));
    @NotNull
    public static final KeyBinding KEY_EASY_BRIDGE = GameSettings.register(new KeyBinding("key.easyBridge"));
    @NotNull
    public static final KeyBinding KEY_SPRINT = GameSettings.register(new KeyBinding("key.sprint"));
    @NotNull
    public static final KeyBinding KEY_OPEN_ACHIEVEMENTS = GameSettings.register(new KeyBinding("key.openAchievements"));
    @NotNull
    public static final KeyBinding KEY_OPEN_STATISTICS = GameSettings.register(new KeyBinding("key.openStatistics"));
    @NotNull
    public static final KeyBinding KEY_SHOW_CONSOLE = GameSettings.register(new KeyBinding("key.showConsole").setDefault(InputDevice.keyboard, Keyboard.KEY_GRAVE));
    @NotNull
    public static final List<KeyBinding> DEBUG_KEYS = new ArrayList<KeyBinding>();
    @NotNull
    public static final KeyBinding KEY_RELOAD = GameSettings.register(new KeyBinding("key.debug.reload").setDefault(InputDevice.keyboard, Keyboard.KEY_R));
    @NotNull
    public static final KeyBinding KEY_SWITCH_GAMEMODE = GameSettings.register(new KeyBinding("key.debug.gamemode").setDefault(InputDevice.keyboard, Keyboard.KEY_N));
    @NotNull
    public static final KeyBinding KEY_DUMP_TEXTURES = GameSettings.register(new KeyBinding("key.debug.dumptextures").setDefault(InputDevice.keyboard, Keyboard.KEY_D));
    @NotNull
    public static final KeyBinding KEY_FULLBRIGHT = GameSettings.register(new KeyBinding("key.debug.fullbright").setDefault(InputDevice.keyboard, Keyboard.KEY_F));
    @NotNull
    public static final KeyBinding KEY_LIGHTMAPS = GameSettings.register(new KeyBinding("key.debug.lightmap").setDefault(InputDevice.keyboard, Keyboard.KEY_L));
    @NotNull
    public static final KeyBinding KEY_COLLISION_BOXES = GameSettings.register(new KeyBinding("key.debug.collision").setDefault(InputDevice.keyboard, Keyboard.KEY_B));
    @NotNull
    public static final KeyBinding KEY_CHUNK_BORDERS = GameSettings.register(new KeyBinding("key.debug.chunkborders").setDefault(InputDevice.keyboard, Keyboard.KEY_G));
    @NotNull
    public static final KeyBinding KEY_CLEAR_CHAT = GameSettings.register(new KeyBinding("key.debug.clearchat").setDefault(InputDevice.keyboard, Keyboard.KEY_C));
    @NotNull
    public static final KeyBinding KEY_PAUSE_LOST_FOCUS = GameSettings.register(new KeyBinding("key.debug.pauseFocus").setDefault(InputDevice.keyboard, Keyboard.KEY_P));
    @NotNull
    public static final KeyBinding KEY_TOGGLE_ITEM_INFO = GameSettings.register(new KeyBinding("key.debug.iteminfo").setDefault(InputDevice.keyboard, Keyboard.KEY_H));
    @NotNull
    public static final KeyBinding KEY_RELOAD_CHUNKS = GameSettings.register(new KeyBinding("key.debug.reloadchunks").setDefault(InputDevice.keyboard, Keyboard.KEY_A));
    @NotNull
    public static final KeyBinding KEY_SMOOTH_LIGHTING = GameSettings.register(new KeyBinding("key.debug.smoothlighting").setDefault(InputDevice.keyboard, Keyboard.KEY_S));
    @NotNull
    public static final KeyBinding KEY_SHOW_SHORTCUTS = GameSettings.register(new KeyBinding("key.debug.shortcuts").setDefault(InputDevice.keyboard, Keyboard.KEY_Q));
    @NotNull
    public static final KeyBinding KEY_TOGGLE_TEXTURE_ATLAS = GameSettings.register(new KeyBinding("key.debug.textureAtlas"));
    @NotNull
    public static final KeyBinding KEY_LOAD_CHUNKS_QUICKLY = GameSettings.register(new KeyBinding("key.debug.loadChunksQuickly"));
    private static File optionsFile;

    @NotNull
    public static @NotNull Collection<@NotNull Option<?>> getAllOptions() {
        return allOptions;
    }

    @Nullable
    public static Option<?> getOption(@NotNull String id) {
        return registeredOptions.get(id);
    }

    @NotNull
    public static @NotNull Collection<@NotNull KeyBinding> getAllKeys() {
        return allKeys;
    }

    @Nullable
    public static KeyBinding getKeyBinding(@NotNull String id) {
        return registeredKeys.get(id);
    }

    @NotNull
    public static <T extends Option<E>, E> T register(@NotNull T option) {
        if (registeredOptions.containsKey(option.id)) {
            throw new IllegalArgumentException("Option with name '" + option.id + "' is already registered!");
        }
        registeredOptions.put(option.id, option);
        allOptions.add(option);
        if (savedValues.containsKey(option.id)) {
            option.fromOptionsString(savedValues.get(option.id));
        }
        return option;
    }

    @NotNull
    public static KeyBinding register(@NotNull KeyBinding keyBinding) {
        if (registeredKeys.containsKey(keyBinding.getId())) {
            throw new IllegalArgumentException("Keybinding with name '" + keyBinding.getId() + "' is already registered!");
        }
        registeredKeys.put(keyBinding.getId(), keyBinding);
        allKeys.add(keyBinding);
        if (savedValues.containsKey("key_" + keyBinding.getId())) {
            keyBinding.fromOptionsString(savedValues.get("key_" + keyBinding.getId()));
        }
        return keyBinding;
    }

    public static void init(@NotNull File mcDirectory) {
        optionsFile = new File(mcDirectory, "options.txt");
        HudComponents.DEFAULT_LAYOUT = HudComponents.INSTANCE.toSettingsString();
        GameSettings.loadOptions();
        GameSettings.saveOptions();
    }

    public static void loadOptions() {
        if (optionsFile == null || !optionsFile.exists()) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(optionsFile));
            br.lines().forEach(line -> {
                int i = line.indexOf(58);
                String key = line.substring(0, i);
                String value = line.substring(i + 1);
                savedValues.put(key, value);
            });
            br.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load options", e);
        }
        try {
            for (Map.Entry<String, String> entry : savedValues.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key.equals("hudLayout")) {
                    HudComponents.INSTANCE.fromSettingsString(value);
                    continue;
                }
                Option<?> option = GameSettings.getOption(key);
                if (option != null) {
                    option.fromOptionsString(value);
                    continue;
                }
                KeyBinding keyBinding = GameSettings.getKeyBinding(key.replaceFirst("key_", ""));
                if (keyBinding == null) continue;
                keyBinding.fromOptionsString(value);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load options", e);
        }
    }

    public static void saveOptions() {
        for (Option<?> option : allOptions) {
            savedValues.put(option.id, option.toOptionsString());
        }
        for (KeyBinding keyBind : allKeys) {
            savedValues.put("key_" + keyBind.getId(), keyBind.toOptionsString());
        }
        savedValues.put("hudLayout", HudComponents.INSTANCE.toSettingsString());
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(optionsFile));
            ArrayList<String> keys2 = new ArrayList<String>(savedValues.keySet());
            keys2.sort(String::compareTo);
            for (String key : keys2) {
                printwriter.print(key);
                printwriter.print(":");
                printwriter.println(savedValues.get(key));
            }
            printwriter.close();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save options", exception);
        }
    }

    static {
        DEBUG_KEYS.add(KEY_SHOW_SHORTCUTS);
        DEBUG_KEYS.add(KEY_RELOAD);
        DEBUG_KEYS.add(KEY_SWITCH_GAMEMODE);
        DEBUG_KEYS.add(KEY_DUMP_TEXTURES);
        DEBUG_KEYS.add(KEY_FULLBRIGHT);
        DEBUG_KEYS.add(KEY_LIGHTMAPS);
        DEBUG_KEYS.add(KEY_COLLISION_BOXES);
        DEBUG_KEYS.add(KEY_CHUNK_BORDERS);
        DEBUG_KEYS.add(KEY_CLEAR_CHAT);
        DEBUG_KEYS.add(KEY_PAUSE_LOST_FOCUS);
        DEBUG_KEYS.add(KEY_TOGGLE_ITEM_INFO);
        DEBUG_KEYS.add(KEY_RELOAD_CHUNKS);
        DEBUG_KEYS.add(KEY_SMOOTH_LIGHTING);
    }
}

