/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.util.helper.Buffer;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class LightmapHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static LightmapHelper instance = null;
    public final Minecraft mc;
    public final WorldRenderer worldRenderer;
    public int lightmapTexture = 0;
    private final int[] lightmapData = new int[256];
    public BufferedImage customLightmap;
    private float prevSkyDarken;
    public float skyDarkenSmooth;

    public LightmapHelper(Minecraft mc, WorldRenderer worldRenderer) {
        instance = this;
        this.mc = mc;
        this.worldRenderer = worldRenderer;
        Arrays.fill(this.lightmapData, -1);
        this.setLightmapTextureData(this.lightmapData);
        this.enableLightmapRendering();
    }

    public void setup() {
        WorldClient world = this.mc.currentWorld;
        if (((Boolean)GameSettings.CUSTOM_LIGHTMAP.value).booleanValue() && world != null) {
            int dimension = world.dimension.id;
            String path = "/assets/minecraft/textures/environment/lightmap" + dimension + ".png";
            LOGGER.info("Attempting to load custom lightmap '{}'", (Object)path);
            this.customLightmap = this.mc.textureManager.getImage(path);
            if (this.customLightmap == Textures.missingTexture) {
                this.customLightmap = null;
            }
            if (this.customLightmap != null) {
                LOGGER.info("Loaded custom lightmap!");
            } else {
                LOGGER.info("No custom lightmap found.");
            }
        } else {
            this.customLightmap = null;
        }
    }

    public void tick() {
        WorldClient world = this.mc.currentWorld;
        if (world == null) {
            return;
        }
        this.prevSkyDarken = this.skyDarkenSmooth;
        float skyDarken = world.skyDarken;
        this.skyDarkenSmooth = Math.abs(this.skyDarkenSmooth - skyDarken) > 1.5f ? (this.prevSkyDarken = skyDarken) : MathHelper.lerp(skyDarken, this.skyDarkenSmooth, 0.99f);
    }

    public void update(float partialTicks) {
        WorldClient world = this.mc.currentWorld;
        if (world == null) {
            return;
        }
        if (this.mc.fullbright) {
            Arrays.fill(this.lightmapData, -1);
        } else if (((Boolean)GameSettings.CUSTOM_LIGHTMAP.value).booleanValue() && this.customLightmap != null) {
            this.generateCustomLightmap(world);
        } else {
            LightmapStyle lightmapStyle = (LightmapStyle)((Object)GameSettings.LIGHTMAP_STYLE.value);
            if (lightmapStyle == LightmapStyle.COLORIZED) {
                this.generateColorizedLightmap(world, partialTicks);
            } else if (lightmapStyle == LightmapStyle.GRAY) {
                this.generateGrayLightmap(world, partialTicks);
            }
        }
        OpenGLHelper.checkError("pre generate lightmap");
        this.setLightmapTextureData(this.lightmapData);
        OpenGLHelper.checkError("generate lightmap");
    }

    public void disableLightmapRendering() {
    }

    public void enableLightmapRendering() {
        GL41.glActiveTexture(33985);
        GL41.glBindTexture(3553, LightmapHelper.instance.lightmapTexture);
        GL41.glActiveTexture(33984);
    }

    public void generateGrayLightmap(World world, float partialTicks) {
        boolean smooth = (Boolean)GameSettings.AMBIENT_OCCLUSION.value;
        for (int i = 0; i < 256; ++i) {
            int color;
            float brightness;
            int skyLightLevel = i / 16;
            int blockLightLevel = i & 0xF;
            if (smooth) {
                float skyDarken = this.prevSkyDarken + (this.skyDarkenSmooth - this.prevSkyDarken) * partialTicks;
                if (this.mc.currentScreen instanceof ScreenPhotoMode) {
                    skyDarken = world.skyDarken;
                }
                float modifiedSkylight = Math.max(0.0f, (float)skyLightLevel - skyDarken);
                float light = Math.max((float)blockLightLevel, modifiedSkylight);
                brightness = MathHelper.getInterpolate(world.worldType.getBrightnessRamp(), light);
            } else {
                int modifiedSkylight = Math.max(0, skyLightLevel - world.skyDarken);
                int light = Math.max(blockLightLevel, modifiedSkylight);
                brightness = world.worldType.getBrightnessRamp()[light];
            }
            brightness = this.applyGamma(brightness, ((Float)GameSettings.BRIGHTNESS.value).floatValue() - 0.5f);
            brightness = MathHelper.clamp(brightness, 0.0f, 1.0f);
            int brightnessI = (int)(brightness * 255.0f);
            this.lightmapData[i] = color = 0xFF000000 | brightnessI << 16 | brightnessI << 8 | brightnessI;
        }
    }

    public void generateColorizedLightmap(World world, float partialTicks) {
        float ambientBrightness = world.getAmbientBrightness(partialTicks);
        float brightness = ((Float)GameSettings.BRIGHTNESS.value).floatValue() - 0.5f;
        for (int i = 0; i < 256; ++i) {
            float skyLight = this.getBrightnessRemoveMinLight(world, i / 16) * (ambientBrightness * 0.95f + 0.05f);
            float blockLight = this.getBrightnessRemoveMinLight(world, i % 16) * 1.5f;
            if (world.lightningFlicker > 0) {
                skyLight = this.getBrightnessRemoveMinLight(world, i / 16);
            }
            float skyRed = skyLight * (ambientBrightness * 0.65f + 0.35f);
            float skyGreen = skyLight * (ambientBrightness * 0.65f + 0.35f);
            float skyBlue = skyLight;
            float torchRed = blockLight;
            float torchGreen = blockLight * ((blockLight * 0.6f + 0.4f) * 0.6f + 0.4f);
            float torchBlue = blockLight * (blockLight * blockLight * 0.6f + 0.4f);
            float red = skyRed + torchRed;
            float green = skyGreen + torchGreen;
            float blue = skyBlue + torchBlue;
            red = red * 0.96f + 0.03f;
            green = green * 0.96f + 0.03f;
            blue = blue * 0.96f + 0.03f;
            red = MathHelper.clamp(red, 0.0f, 1.0f);
            green = MathHelper.clamp(green, 0.0f, 1.0f);
            blue = MathHelper.clamp(blue, 0.0f, 1.0f);
            red = this.applyGamma(red, brightness) * 0.96f + 0.03f;
            green = this.applyGamma(green, brightness) * 0.96f + 0.03f;
            blue = this.applyGamma(blue, brightness) * 0.96f + 0.03f;
            red = MathHelper.clamp(red, 0.0f, 1.0f);
            green = MathHelper.clamp(green, 0.0f, 1.0f);
            blue = MathHelper.clamp(blue, 0.0f, 1.0f);
            this.lightmapData[i] = Color.floatToIntARGB(1.0f, red, green, blue);
        }
    }

    public void generateCustomLightmap(World world) {
        float ambientBrightness = (world.getAmbientBrightness(1.0f) - 0.2f) / 0.8f;
        float brightness = ((Float)GameSettings.BRIGHTNESS.value).floatValue();
        int skylightX = MathHelper.floor_float(ambientBrightness * (float)(this.customLightmap.getWidth() - 2));
        for (int i = 0; i < 256; ++i) {
            int blockLightIndex = i % 16;
            int skyLightIndex = i / 16;
            int torchColor = this.customLightmap.getRGB(0, 16 + blockLightIndex);
            int skyColor = this.customLightmap.getRGB(skylightX, skyLightIndex);
            float torchRed = (float)(torchColor >> 16 & 0xFF) / 255.0f;
            float torchGreen = (float)(torchColor >> 8 & 0xFF) / 255.0f;
            float torchBlue = (float)(torchColor >> 0 & 0xFF) / 255.0f;
            float skyRed = (float)(skyColor >> 16 & 0xFF) / 255.0f;
            float skyGreen = (float)(skyColor >> 8 & 0xFF) / 255.0f;
            float skyBlue = (float)(skyColor >> 0 & 0xFF) / 255.0f;
            float red = skyRed + torchRed;
            float green = skyGreen + torchGreen;
            float blue = skyBlue + torchBlue;
            red = MathHelper.clamp(red, 0.0f, 1.0f);
            green = MathHelper.clamp(green, 0.0f, 1.0f);
            blue = MathHelper.clamp(blue, 0.0f, 1.0f);
            red = this.applyGamma(red, brightness);
            green = this.applyGamma(green, brightness);
            blue = this.applyGamma(blue, brightness);
            red = MathHelper.clamp(red, 0.0f, 1.0f);
            green = MathHelper.clamp(green, 0.0f, 1.0f);
            blue = MathHelper.clamp(blue, 0.0f, 1.0f);
            this.lightmapData[i] = Color.floatToIntARGB(1.0f, red, green, blue);
        }
    }

    public void setLightmapTextureData(int[] data) {
        OpenGLHelper.checkError("pre set lightmap data");
        Buffer.checkBufferSize(1024);
        ByteBuffer buffer = Buffer.buffer;
        buffer.clear();
        for (int i = 0; i < data.length; ++i) {
            int color = data[i];
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            buffer.put((byte)r);
            buffer.put((byte)g);
            buffer.put((byte)b);
            buffer.put((byte)a);
        }
        buffer.position(0);
        buffer.limit(1024);
        if (this.lightmapTexture == 0) {
            this.lightmapTexture = GLAllocation.generateTexture();
            GL41.glBindTexture(3553, this.lightmapTexture);
            GL41.glTexImage2D(3553, 0, 6408, 16, 16, 0, 6408, 5121, 0L);
        }
        GL41.glBindTexture(3553, this.lightmapTexture);
        GL41.glTexSubImage2D(3553, 0, 0, 0, 16, 16, 6408, 5121, buffer);
        GL41.glTexParameteri(3553, 10241, 9729);
        GL41.glTexParameteri(3553, 10240, 9729);
        GL41.glTexParameteri(3553, 10242, 33071);
        GL41.glTexParameteri(3553, 10243, 33071);
        OpenGLHelper.checkError("set lightmap data");
    }

    public float applyGamma(float color, float gamma) {
        float color2 = 1.0f - color;
        color2 = 1.0f - color2 * color2 * color2 * color2;
        return color * (1.0f - gamma) + color2 * gamma;
    }

    public float getBrightnessRemoveMinLight(World world, int i) {
        float brightness = world.worldType.getBrightnessRamp()[i];
        float min = 0.05f;
        return (brightness - min) / (1.0f - min);
    }

    public static int getLightmapCoord(int skylight, int blocklight) {
        return skylight << 20 | blocklight << 4;
    }

    public static int getLightmapCoord(float skylight, float blocklight) {
        return LightmapHelper.getLightmapCoord((int)(15.0f * skylight), (int)(15.0f * blocklight));
    }

    public static int getOverbrightLightmapCoord(int skylight) {
        return LightmapHelper.getLightmapCoord(skylight, 15);
    }

    public static int max(int lightmapCoord1, int lightmapCoord2) {
        int sky1 = lightmapCoord1 >> 16;
        int sky2 = lightmapCoord2 >> 16;
        int block1 = lightmapCoord1 & 0xFFFF;
        int block2 = lightmapCoord2 & 0xFFFF;
        return Math.max(sky1, sky2) << 16 | Math.max(block1, block2);
    }

    public static int avg(int lmc0, int lmc1) {
        int sky0 = lmc0 >> 16;
        int sky1 = lmc1 >> 16;
        int block0 = lmc0 & 0xFFFF;
        int block1 = lmc1 & 0xFFFF;
        int sky = sky0 + sky1 >> 1;
        int block = block0 + block1 >> 1;
        return sky << 16 | block;
    }

    public static int avg(int lmc0, int lmc1, int lmc2, int lmc3) {
        return LightmapHelper.avg(LightmapHelper.avg(lmc0, lmc1), LightmapHelper.avg(lmc2, lmc3));
    }

    public static int setBlocklightValue(int lightmapCoord, int blocklight) {
        return lightmapCoord & 0xFFFF0000 | blocklight << 4;
    }

    public static int getBlockLightFromCoord(int lightmapCoord) {
        return (lightmapCoord & 0xFFFF) >> 4;
    }

    public static int setSkylightValue(int lightmapCoord, int skylight) {
        return lightmapCoord & 0xFFFF | skylight << 20;
    }

    public static int getSkyLightFromCoord(int lightmapCoord) {
        return (lightmapCoord & 0xFFFF0000) >> 20;
    }
}

