/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.primitives.AABBdc;

public class BlockModelFluid<T extends BlockLogicFluid>
extends BlockModelStandard<T> {
    public BlockModelFluid(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        tessellator.setColor1i(((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(worldSource, tilePos, 0));
        TilePos queryPos = new TilePos();
        int x = tilePos.x();
        int y = tilePos.y();
        int z = tilePos.z();
        AABBdc bounds = this.block.getBoundsFromState(worldSource, tilePos);
        boolean renderTop = this.shouldSideBeRendered(worldSource, bounds, tilePos.up(queryPos), Side.TOP);
        boolean flag1 = this.shouldSideBeRendered(worldSource, bounds, tilePos.down(queryPos), Side.BOTTOM);
        boolean[] sideRenderFlags = new boolean[]{this.shouldSideBeRendered(worldSource, bounds, tilePos.north(queryPos), Side.NORTH), this.shouldSideBeRendered(worldSource, bounds, tilePos.south(queryPos), Side.SOUTH), this.shouldSideBeRendered(worldSource, bounds, tilePos.west(queryPos), Side.WEST), this.shouldSideBeRendered(worldSource, bounds, tilePos.east(queryPos), Side.EAST)};
        if (!(renderTop || flag1 || sideRenderFlags[0] || sideRenderFlags[1] || sideRenderFlags[2] || sideRenderFlags[3])) {
            return false;
        }
        boolean didRender = false;
        float yOff = 0.001f;
        int meta = worldSource.getBlockData(tilePos);
        float h = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, tilePos);
        float hs = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, tilePos.add(0, 0, 1, queryPos));
        float hes = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, tilePos.add(1, 0, 1, queryPos));
        float he = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, tilePos.add(1, 0, 0, queryPos));
        if (BlockModelFluid.renderBlocks.renderAllFaces || renderTop) {
            didRender = true;
            IconCoordinate tex = this.getBlockTextureFromSideAndMetadata(Side.TOP, meta);
            float rotation = (float)((BlockLogicFluid)this.block.getLogic()).getSlopeAngle(worldSource, tilePos);
            if (rotation > -999.0f) {
                tex = this.getBlockTextureFromSideAndMetadata(Side.NORTH, meta);
            } else {
                rotation = 0.0f;
            }
            int light = this.block.getLightmapCoord(worldSource, tilePos);
            int lightUp = this.block.getLightmapCoord(worldSource, tilePos.up(queryPos));
            tessellator.setLightmapCoord1i(LightmapHelper.max(light, lightUp));
            if (tex.namespaceId.toString().contains("_flowing")) {
                float cos = Math.cos(-rotation + 1.5707964f);
                float sin = Math.sin(-rotation + 1.5707964f);
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                tessellator.addVertexWithUV(x, (float)y + h, z, tex.getSubIconU(-0.25 * (double)cos - -0.25 * (double)sin + 0.5), tex.getSubIconV(-0.25 * (double)sin + -0.25 * (double)cos + 0.5));
                tessellator.addVertexWithUV(x, (float)y + hs, z + 1, tex.getSubIconU(-0.25 * (double)cos - 0.25 * (double)sin + 0.5), tex.getSubIconV(-0.25 * (double)sin + 0.25 * (double)cos + 0.5));
                tessellator.addVertexWithUV(x + 1, (float)y + hes, z + 1, tex.getSubIconU(0.25 * (double)cos - 0.25 * (double)sin + 0.5), tex.getSubIconV(0.25 * (double)sin + 0.25 * (double)cos + 0.5));
                tessellator.addVertexWithUV(x + 1, (float)y + he, z, tex.getSubIconU(0.25 * (double)cos - -0.25 * (double)sin + 0.5), tex.getSubIconV(0.25 * (double)sin + -0.25 * (double)cos + 0.5));
            } else {
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                tessellator.addVertexWithUV(x, (float)y + h, z, tex.getIconUMin(), tex.getIconVMax());
                tessellator.addVertexWithUV(x, (float)y + hs, z + 1, tex.getIconUMax(), tex.getIconVMax());
                tessellator.addVertexWithUV(x + 1, (float)y + hes, z + 1, tex.getIconUMax(), tex.getIconVMin());
                tessellator.addVertexWithUV(x + 1, (float)y + he, z, tex.getIconUMin(), tex.getIconVMin());
            }
        }
        if (BlockModelFluid.renderBlocks.renderAllFaces || flag1) {
            tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos.down(queryPos)));
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderBottomFace(tessellator, bounds, x, (float)y + 0.001f, z, this.getBlockTextureFromSideAndMetadata(Side.TOP, 0));
            didRender = true;
        }
        TilePos posB = new TilePos(0, 0, 0);
        for (int side = 0; side < 4; ++side) {
            float z1;
            float x2;
            float x1;
            float f15;
            float f13;
            posB.set(x, y, z);
            switch (side) {
                case 0: {
                    posB.set(x, y, z - 1);
                    break;
                }
                case 1: {
                    posB.set(x, y, z + 1);
                    break;
                }
                case 2: {
                    posB.set(x - 1, y, z);
                    break;
                }
                case 3: {
                    posB.set(x + 1, y, z);
                }
            }
            IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.getSideById(side + 2), meta);
            if (!BlockModelFluid.renderBlocks.renderAllFaces && !sideRenderFlags[side]) continue;
            float z2 = switch (side) {
                case 0 -> {
                    f13 = h;
                    f15 = he;
                    x1 = (float)x + 1.0E-4f;
                    x2 = (float)(x + 1) - 1.0E-4f;
                    z1 = (float)z + 1.0E-4f;
                    yield (float)z + 1.0E-4f;
                }
                case 1 -> {
                    f13 = hes;
                    f15 = hs;
                    x1 = (float)(x + 1) - 1.0E-4f;
                    x2 = (float)x + 1.0E-4f;
                    z1 = (float)(z + 1) - 1.0E-4f;
                    yield (float)(z + 1) - 0.001f;
                }
                case 2 -> {
                    f13 = hs;
                    f15 = h;
                    x1 = (float)x + 1.0E-4f;
                    x2 = (float)x + 1.0E-4f;
                    z1 = (float)(z + 1) - 1.0E-4f;
                    yield (float)z + 1.0E-4f;
                }
                default -> {
                    f13 = he;
                    f15 = hes;
                    x1 = (float)(x + 1) - 1.0E-4f;
                    x2 = (float)(x + 1) - 1.0E-4f;
                    z1 = (float)z + 1.0E-4f;
                    yield (float)(z + 1) - 1.0E-4f;
                }
            };
            didRender = true;
            double u1 = texture.getSubIconU(0.0);
            double u2 = texture.getSubIconU(0.5);
            double v1 = texture.getSubIconV(0.5f - f13 / 2.0f);
            double v2 = texture.getSubIconV(0.5f - f15 / 2.0f);
            double v3 = texture.getSubIconV(0.5);
            tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, posB));
            switch (side) {
                case 0: {
                    tessellator.setNormal(0.0f, 0.0f, -1.0f);
                    break;
                }
                case 1: {
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    break;
                }
                case 2: {
                    tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                    break;
                }
                case 3: {
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                }
            }
            tessellator.addVertexWithUV(x1, (float)y + f13, z1, u1, v1);
            tessellator.addVertexWithUV(x2, (float)y + f15, z2, u2, v2);
            tessellator.addVertexWithUV(x2, y, z2, u2, v3);
            tessellator.addVertexWithUV(x1, y, z1, u1, v3);
        }
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        return didRender;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @NotNull Side side) {
        Material material = source.getBlockMaterial(tilePos);
        if (material == this.block.getMaterial()) {
            return false;
        }
        if (material == Materials.ICE) {
            return true;
        }
        if (side == Side.TOP) {
            return true;
        }
        return super.shouldSideBeRendered(source, bounds, tilePos, side);
    }
}

