/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.LeavesQuality;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public class BlockModelLeaves<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected final IconCoordinate fancyLeavesTexture;
    protected final boolean canBeRetro;
    protected final IconCoordinate retroLeaves = TextureRegistry.getTexture("minecraft:block/leaves/oak_retro");
    protected final IconCoordinate retroLeavesFancy = TextureRegistry.getTexture("minecraft:block/leaves/oak_retro_fancy");

    public BlockModelLeaves(Block<T> block, String leavesTex) {
        this(block, leavesTex, false);
    }

    public BlockModelLeaves(Block<T> block, String leavesTex, boolean canBeRetro) {
        super(block);
        this.setAllTextures(leavesTex);
        this.fancyLeavesTexture = TextureRegistry.getTexture(leavesTex + "_fancy");
        this.canBeRetro = canBeRetro;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        boolean invTint = BlockModelLeaves.renderBlocks.useInventoryTint;
        BlockModelLeaves.renderBlocks.useInventoryTint = !this.canBeRetro || !this.isRetro();
        super.renderStandalone(tessellator, metadata, lightmapCoord);
        BlockModelLeaves.renderBlocks.useInventoryTint = invTint;
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        if (this.canBeRetro && this.isRetro()) {
            return renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsFromState(worldSource, tilePos), tilePos, 1.0f, 1.0f, 1.0f);
        }
        return super.render(tessellator, worldSource, tilePos);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        if (this.canBeRetro && this.isRetro()) {
            return GameSettings.LEAVES_QUALITY.value != LeavesQuality.FAST ? this.retroLeavesFancy : this.retroLeaves;
        }
        return GameSettings.LEAVES_QUALITY.value != LeavesQuality.FAST ? this.fancyLeavesTexture : super.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (GameSettings.LEAVES_QUALITY.value == LeavesQuality.FANCY && source.getBlockType(tilePos) == this.block) {
            return false;
        }
        return super.shouldSideBeRendered(source, bounds, tilePos, side);
    }
}

