/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicBasket;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericBasket<T extends BlockLogicBasket>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel fill = BlockModelDispatcher.loadDataModel("minecraft:block/basket_fill").asModel();

    public BlockModelGenericBasket(@NotNull Block<T> block) {
        super(block, BlockModelDispatcher.loadDataModel("minecraft:block/basket"));
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        boolean rendered = super.renderAttached(tessellator, worldSource, tilePos, cullFaces, overrideTexture);
        int height = ((BlockLogicBasket)this.block.getLogic()).getFillLevel(worldSource, tilePos);
        if (height > 0) {
            rendered |= this.fill.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, (float)height / 16.0f, 0.0, false, cullFaces, overrideTexture);
        }
        return rendered;
    }
}

