/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLeaves;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicLeavesCherryFlowering;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericLeavesCacao<T extends BlockLogic>
extends BlockModelGenericLeaves<T> {
    @NotNull
    public StaticBlockModel[] overlays = new StaticBlockModel[4];

    public BlockModelGenericLeavesCacao(@NotNull Block<T> block) {
        super(block, "minecraft:block/leaves/cacao");
        for (int i = 0; i < this.overlays.length; ++i) {
            this.overlays[i] = BlockModelDispatcher.loadDataModel("minecraft:block/leaves/cacao_overlay_stage" + i).asModel();
        }
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        super.renderStandalone(tessellator, metadata, lightmapCoord);
        this.overlays[this.overlays.length - 1].renderStandalone(this, tessellator, 0.0, 0.0, 0.0, metadata, lightmapCoord, (BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block));
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        boolean didRender = super.renderAttached(tessellator, worldSource, tilePos, cullFaces, overrideTexture);
        int growthRate = BlockLogicLeavesCherryFlowering.getGrowthRate(worldSource.getBlockData(tilePos));
        if (growthRate > 0) {
            didRender |= this.overlays[Math.min(growthRate - 1, 3)].renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        }
        return didRender;
    }
}

