/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class EntityRendererSprite<T extends Entity>
extends EntityRenderer<T> {
    private final IconCoordinate itemIconIndex;
    private float scale = 1.0f;
    private boolean fullBright = false;

    public EntityRendererSprite(Item item) {
        this(((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).getIcon(null, item.getDefaultStack()));
    }

    public EntityRendererSprite(IconCoordinate i) {
        this.itemIconIndex = i;
    }

    public EntityRendererSprite<T> setFullBright() {
        this.fullBright = true;
        return this;
    }

    public EntityRendererSprite<T> setScale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        if (this.fullBright) {
            GLRenderer.globalSetLightEnabled(false);
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLRenderer.setLightmapCoord1i(LightmapHelper.getLightmapCoord(15, 15));
        }
        GLRenderer.modelM4f().scale(0.5f * this.scale, 0.5f * this.scale, 0.5f * this.scale);
        this.itemIconIndex.parentAtlas.bind();
        float f2 = (float)this.itemIconIndex.getIconUMin();
        float f3 = (float)this.itemIconIndex.getIconUMax();
        float f4 = (float)this.itemIconIndex.getIconVMin();
        float f5 = (float)this.itemIconIndex.getIconVMax();
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.25f;
        GLRenderer.modelM4f().rotateY(Math.toRadians(180.0f - this.renderDispatcher.viewLerpYaw));
        GLRenderer.modelM4f().rotateX(Math.toRadians(-this.renderDispatcher.viewLerpPitch));
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertexWithUV(0.0f - f7, 0.0f - f8, 0.0, f2, f5);
        tessellator.addVertexWithUV(f6 - f7, 0.0f - f8, 0.0, f3, f5);
        tessellator.addVertexWithUV(f6 - f7, 1.0f - f8, 0.0, f3, f4);
        tessellator.addVertexWithUV(0.0f - f7, 1.0f - f8, 0.0, f2, f4);
        tessellator.draw();
        GLRenderer.popFrame();
        if (this.fullBright) {
            GLRenderer.globalSetLightEnabled(true);
        }
    }
}

