/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class ParticleBlockBreaking
extends Particle {
    private final Block<?> block;
    private final Side side;
    @NotNull
    private final TilePos initPos = new TilePos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public ParticleBlockBreaking(World world, double x, double y, double z, double xa, double ya, double za, Block<?> block, Side side, int meta) {
        super(world, x, y, z, xa, ya, za);
        this.side = side;
        this.block = block;
        this.tex = ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).getParticleTexture(this.side, meta);
        this.gravity = block.blockParticleGravity;
        this.bCol = 0.6f;
        this.gCol = 0.6f;
        this.rCol = 0.6f;
        this.size /= 2.0f;
    }

    public ParticleBlockBreaking init(@NotNull TilePosc tilePos) {
        this.initPos.set(tilePos);
        int meta = this.world.getBlockData(tilePos);
        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(this.block);
        int index = model.particleColorIndex(this.world, tilePos, this.side, meta);
        if (index >= 0) {
            int col = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(this.world, tilePos, index);
            this.rCol *= (float)(col >> 16 & 0xFF) / 255.0f;
            this.gCol *= (float)(col >> 8 & 0xFF) / 255.0f;
            this.bCol *= (float)(col & 0xFF) / 255.0f;
        }
        return this;
    }

    @Override
    public void render(@NotNull TessellatorParticle t, float partialTick) {
        if (this.tex == null) {
            return;
        }
        t.setLightmapCoord1i(this.getLightmap(partialTick));
        t.setColorOpaque3f(this.rCol, this.gCol, this.bCol);
        t.addParticle(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick), this.size * 0.1f, this.tex.getIconUMin() + this.tex.getIconUSize() * (double)this.uo / 4.0, this.tex.getIconVMin() + this.tex.getIconVSize() * (double)this.uo / 4.0, this.tex.getIconUSize() * 0.25, this.tex.getIconVSize() * 0.25);
    }

    @Override
    public int calcLightmap(float partialTick) {
        int skylight;
        int blocklight;
        if (Global.accessor.isFullbrightEnabled()) {
            return 0xF0000F;
        }
        TilePos blockPos = new TilePos(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick));
        if (this.world.getBlockLitInteriorSurface(blockPos) || blockPos.equals(this.initPos)) {
            TilePos queryPos = new TilePos();
            int bU = this.world.getSavedLightValue(LightLayer.Block, blockPos.up(queryPos));
            int bW = this.world.getSavedLightValue(LightLayer.Block, blockPos.west(queryPos));
            int bE = this.world.getSavedLightValue(LightLayer.Block, blockPos.east(queryPos));
            int bS = this.world.getSavedLightValue(LightLayer.Block, blockPos.south(queryPos));
            int bN = this.world.getSavedLightValue(LightLayer.Block, blockPos.north(queryPos));
            if (bW > bU) {
                bU = bW;
            }
            if (bE > bU) {
                bU = bE;
            }
            if (bS > bU) {
                bU = bS;
            }
            if (bN > bU) {
                bU = bN;
            }
            blocklight = bU;
            int sU = this.world.getSavedLightValue(LightLayer.Sky, blockPos.up(queryPos));
            int sW = this.world.getSavedLightValue(LightLayer.Sky, blockPos.west(queryPos));
            int sE = this.world.getSavedLightValue(LightLayer.Sky, blockPos.east(queryPos));
            int sS = this.world.getSavedLightValue(LightLayer.Sky, blockPos.south(queryPos));
            int sN = this.world.getSavedLightValue(LightLayer.Sky, blockPos.north(queryPos));
            if (sW > sU) {
                sU = sW;
            }
            if (sE > sU) {
                sU = sE;
            }
            if (sS > sU) {
                sU = sS;
            }
            if (sN > sU) {
                sU = sN;
            }
            skylight = sU;
        } else {
            skylight = this.world.getSavedLightValue(LightLayer.Sky, blockPos);
            blocklight = this.world.getSavedLightValue(LightLayer.Block, blockPos);
        }
        return this.world.getLightmapCoord(skylight, blocklight);
    }
}

