/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleItemBreaking
extends Particle {
    public ParticleItemBreaking(World world, double x, double y, double z, Item item) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.tex = ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).getIcon(null, item.getDefaultStack());
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.gravity = Blocks.BLOCK_SNOW.blockParticleGravity;
        this.size /= 2.0f;
    }

    @Override
    public void render(@NotNull TessellatorParticle t, float partialTick) {
        if (this.tex == null) {
            return;
        }
        t.setLightmapCoord1i(this.getLightmap(partialTick));
        t.setColorOpaque3f(this.rCol, this.gCol, this.bCol);
        t.addParticle(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick), this.size * 0.1f, this.tex.getIconUMin() + this.tex.getIconUSize() * (double)this.uo / 4.0, this.tex.getIconVMin() + this.tex.getIconVSize() * (double)this.uo / 4.0, this.tex.getIconUSize() * 0.25, this.tex.getIconVSize() * 0.25);
    }
}

