/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleNote
extends Particle {
    private final float oSize;

    public ParticleNote(World world, double x, double y, double z, double xa, double ya, double za, int data) {
        this(world, x, y, z, xa, ya, za, data, 2.0f);
    }

    public ParticleNote(World world, double x, double y, double z, double xa, double ya, double za, int data, float scale) {
        super(world, x, y, z, xa, ya, za);
        this.xd *= 0.01;
        this.yd *= 0.01;
        this.zd *= 0.01;
        this.yd += 0.2;
        this.rCol = MathHelper.sin(((float)data / 24.0f + 0.0f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.gCol = MathHelper.sin(((float)data / 24.0f + 0.33333334f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.bCol = MathHelper.sin(((float)data / 24.0f + 0.6666667f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.size *= 0.75f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = 6;
        this.noPhysics = false;
        this.tex = TextureRegistry.getTexture("minecraft:particle/note");
    }

    @Override
    public void render(@NotNull TessellatorParticle t, float partialTick) {
        float l = ((float)this.age + partialTick) / (float)this.lifetime * 32.0f;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        this.size = this.oSize * l;
        super.render(t, partialTick);
    }

    @Override
    public void tick() {
        this.cachedLightmapCoord = this.calcLightmap(1.0f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.66;
        this.yd *= 0.66;
        this.zd *= 0.66;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

