/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ParticlePickupAnimation
extends Particle {
    private final Entity item;
    private final Entity target;
    private int life = 0;
    private final int lifeTime;
    private final float yOffs;

    public ParticlePickupAnimation(World world, Entity item, Entity target, float scale) {
        super(world, item.x, item.y, item.z, item.xd, item.yd, item.zd);
        this.item = item;
        this.target = target;
        this.lifeTime = 3;
        this.yOffs = scale;
    }

    @Override
    public void renderLit(@NotNull TessellatorGeneral t, float partialTick, double xOff, double yOff, double zOff) {
        float time = ((float)this.life + partialTick) / (float)this.lifeTime;
        time *= time;
        double xo = this.item.x;
        double yo = this.item.y;
        double zo = this.item.z;
        double xt = this.target.xo + (this.target.x - this.target.xo) * (double)partialTick;
        double yt = this.target.yo + (this.target.y - this.target.yo) * (double)partialTick + (double)this.yOffs;
        double zt = this.target.zo + (this.target.z - this.target.zo) * (double)partialTick;
        double xx = xo + (xt - xo) * (double)time;
        double yy = yo + (yt - yo) * (double)time;
        double zz = zo + (zt - zo) * (double)time;
        TilePos tilePos = new TilePos(xx, yy, zz);
        GLRenderer.setLightmapCoord1i(this.item.world.getLightmapCoord(tilePos, 0));
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        EntityRendererDispatcher.instance.renderEntityWithPosYaw(t, this.item, (float)(xx -= xOff), (float)(yy -= yOff), (float)(zz -= zOff), this.item.yRot, partialTick);
    }

    @Override
    public void tick() {
        this.cachedLightmapCoord = this.calcLightmap(1.0f);
        ++this.life;
        if (this.life == this.lifeTime) {
            this.remove();
        }
    }

    @Override
    public int getParticleTexture() {
        return 1;
    }
}

