/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.terrain.ChunkRendererMultiDraw;
import net.minecraft.client.render.terrain.RegionBuffer;
import net.minecraft.client.render.terrain.RenderList;
import net.minecraft.client.render.terrain.RenderRegion;
import net.minecraft.client.render.terrain.TerrainRenderer;
import net.minecraft.client.render.terrain.VertexBuffer;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexConfigStandard;
import net.minecraft.client.render.tessellator.TessellatorTerrainImpl;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class TerrainRendererMultiDraw
extends TerrainRenderer {
    public final int VERTEX_BUFFER_INITIAL_CAPACITY = 0x4000000;
    public final int RENDER_LIST_INITIAL_CAPACITY = 4096;
    public final int REGION_SIZE = 9;
    public final int MAX_RENDER_PASSES = 2;
    public VertexBuffer vertexBuffer;
    public RegionBuffer regionBuffer;
    private VertexConfig<?> terrainVertexConfig;
    int[] drawCalls = new int[this.MAX_RENDER_PASSES];
    private double renderPosX;
    private double renderPosY;
    private double renderPosZ;
    private double prevSortX;
    private double prevSortY;
    private double prevSortZ;

    public TerrainRendererMultiDraw(Minecraft minecraft) {
        super(minecraft);
        Objects.requireNonNull(this);
        this.vertexBuffer = new VertexBuffer(0x4000000L);
        this.regionBuffer = new RegionBuffer(this.REGION_SIZE);
    }

    @Override
    public void renderSolidTerrain(float partialTicks) {
        Arrays.fill(this.drawCalls, 0);
        ICamera camera = this.mc.activeCamera;
        this.renderPosX = camera.getX(partialTicks);
        this.renderPosY = camera.getY(partialTicks);
        this.renderPosZ = camera.getZ(partialTicks);
        double dX = this.renderPosX - this.prevSortX;
        double dY = this.renderPosY - this.prevSortY;
        double dZ = this.renderPosZ - this.prevSortZ;
        if (dX * dX + dY * dY + dZ * dZ > 64.0) {
            this.prevSortX = this.renderPosX;
            this.prevSortY = this.renderPosY;
            this.prevSortZ = this.renderPosZ;
            int x = MathHelper.floor(this.renderPosX);
            int y = MathHelper.floor(this.renderPosY);
            int z = MathHelper.floor(this.renderPosZ);
            this.mc.renderGlobal.resortChunks(x, y, z);
        }
        if (this.terrainVertexConfig == null) {
            return;
        }
        this.terrainVertexConfig.enable(this.vertexBuffer.getVao(), this.vertexBuffer.getVbo());
        List<RenderRegion> regions = this.regionBuffer.getAllRegions();
        for (int i = 0; i < regions.size(); ++i) {
            RenderRegion region = regions.get(i);
            RenderList renderList = region.renderLists[0];
            if (renderList == null || renderList.size() <= 0) continue;
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate((float)((double)(region.posX << this.REGION_SIZE) - this.renderPosX), (float)(-this.renderPosY), (float)((double)(region.posZ << this.REGION_SIZE) - this.renderPosZ));
            GLRenderer.globalSetUniforms(Shaders.TERRAIN);
            renderList.draw();
            this.drawCalls[0] = this.drawCalls[0] + 1;
            GLRenderer.popFrame();
        }
        this.terrainVertexConfig.disable();
    }

    public void renderAllLists(int renderPass) {
        List<RenderRegion> regions = this.regionBuffer.getAllRegions();
        for (int i = 0; i < regions.size(); ++i) {
            RenderRegion region = regions.get(i);
            RenderList renderList = region.renderLists[renderPass];
            if (renderList == null || renderList.size() <= 0) continue;
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate((float)((double)(region.posX << this.REGION_SIZE) - this.renderPosX), (float)(-this.renderPosY), (float)((double)(region.posZ << this.REGION_SIZE) - this.renderPosZ));
            GLRenderer.globalSetUniforms(Shaders.TERRAIN);
            renderList.draw();
            int n = renderPass;
            this.drawCalls[n] = this.drawCalls[n] + 1;
            GLRenderer.popFrame();
        }
    }

    @Override
    public void renderTranslucentTerrain(float partialTicks) {
        if (this.terrainVertexConfig == null) {
            return;
        }
        this.terrainVertexConfig.enable(this.vertexBuffer.getVao(), this.vertexBuffer.getVbo());
        if (((Boolean)GameSettings.TRANSPARENCY_DEPTH_CHECK.value).booleanValue()) {
            GLRenderer.setColorMask(false, false, false, false);
        }
        this.renderAllLists(1);
        if (((Boolean)GameSettings.TRANSPARENCY_DEPTH_CHECK.value).booleanValue()) {
            GLRenderer.setColorMask(true, true, true, true);
            if (this.drawCalls[1] > 0) {
                this.renderAllLists(1);
            }
        }
        this.terrainVertexConfig.disable();
    }

    public void chunkRendered(ChunkRendererMultiDraw chunkRenderer, TessellatorTerrainImpl tessellator, int renderPass) {
        VertexBuffer.Entry entry;
        tessellator.drawing = false;
        VertexConfig config = tessellator.data.config;
        if (this.terrainVertexConfig == null) {
            this.terrainVertexConfig = config.copy();
        } else if (!this.terrainVertexConfig.equals(tessellator.data.config)) {
            List<RenderRegion> allRegions = this.regionBuffer.getAllRegions();
            for (int i = 0; i < allRegions.size(); ++i) {
                RenderRegion region = allRegions.get(i);
                if (region.hasRenderData()) {
                    VertexConfigStandard.compareThrow(tessellator.data.config, this.terrainVertexConfig);
                }
                this.regionBuffer.remove(region);
                --i;
            }
            this.terrainVertexConfig = config.copy();
        }
        RenderList renderList = this.getOrCreateRenderList(chunkRenderer, renderPass);
        chunkRenderer.renderListEntries[renderPass] = entry = renderList.add(tessellator.data, chunkRenderer.visible);
    }

    public void chunkVisibilityChanged(ChunkRendererMultiDraw chunkRenderer) {
        RenderRegion region = this.getRenderRegionAtBlockPos(chunkRenderer.posX, chunkRenderer.posZ);
        for (int renderPass = 0; renderPass < this.MAX_RENDER_PASSES; ++renderPass) {
            VertexBuffer.Entry entry = chunkRenderer.renderListEntries[renderPass];
            if (entry == null) continue;
            RenderList renderList = region.renderLists[renderPass];
            if (renderList == null) {
                throw new NullPointerException("Region " + String.valueOf(region) + " does not have a render list for render pass " + renderPass + "!");
            }
            renderList.setVisible(entry, chunkRenderer.visible);
        }
    }

    public void chunkDeleted(ChunkRendererMultiDraw chunkRenderer) {
        RenderRegion region = this.getRenderRegionAtBlockPos(chunkRenderer.posX, chunkRenderer.posZ);
        for (int renderPass = 0; renderPass < this.MAX_RENDER_PASSES; ++renderPass) {
            VertexBuffer.Entry entry = chunkRenderer.renderListEntries[renderPass];
            if (entry == null) continue;
            RenderList renderList = region.renderLists[renderPass];
            if (renderList == null) {
                throw new NullPointerException("Region " + String.valueOf(region) + " does not have a render list for render pass " + renderPass + "!");
            }
            renderList.remove(entry);
            chunkRenderer.renderListEntries[renderPass] = null;
        }
    }

    public RenderList getOrCreateRenderList(ChunkRendererMultiDraw chunkRenderer, int renderPass) {
        return this.getOrCreateRenderList(chunkRenderer.posX, chunkRenderer.posZ, renderPass);
    }

    public RenderList getOrCreateRenderList(int posX, int posZ, int renderPass) {
        RenderRegion region = this.regionBuffer.getRegionAtBlockPos(posX, posZ);
        RenderList renderList = region.renderLists[renderPass];
        if (renderList == null) {
            region.renderLists[renderPass] = renderList = new RenderList(this.vertexBuffer, this.RENDER_LIST_INITIAL_CAPACITY);
        }
        return renderList;
    }

    @Override
    public ChunkRenderer createChunkRenderer(World world, List<TileEntity> globalRenderableTileEntities, int x, int y, int z, int size) {
        return new ChunkRendererMultiDraw(this, world, globalRenderableTileEntities, x, y, z, size);
    }

    public RenderRegion getRenderRegionAtBlockPos(int blockX, int blockZ) {
        return this.regionBuffer.getRegionAtBlockPos(blockX, blockZ);
    }

    public int getTotalDrawCalls() {
        int totalDrawCalls = 0;
        for (int i = 0; i < this.drawCalls.length; ++i) {
            totalDrawCalls += this.drawCalls[i];
        }
        return totalDrawCalls;
    }
}

