/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityFlowerJar;

public class TileEntityRendererFlowerJar
extends TileEntityRenderer<TileEntityFlowerJar> {
    @Override
    public void doRender(TessellatorGeneral tessellator, TileEntityFlowerJar tileEntity, double x, double y, double z, float renderPartialTicks) {
        GLRenderer.pushFrame();
        Block<?> block = Blocks.getBlock(tileEntity.flowerInPot);
        if (block != null) {
            GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
            TextureRegistry.worldAtlas.bind();
            float scaleValue = 0.75f;
            GLRenderer.modelM4f().scale(scaleValue, scaleValue, scaleValue);
            GLRenderer.modelM4f().translate(0.66f, 0.75f, 0.66f);
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            Lighting.disable();
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderStandalone(tessellator, tileEntity.flowerData, tileEntity.worldObj.getLightmapCoord(tileEntity.x, tileEntity.y, tileEntity.z, 0));
            Lighting.enableLight();
            GLRenderer.disableState(State.BLEND);
        }
        GLRenderer.popFrame();
    }
}

