/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.client.util.helper.FileOpener;
import org.lwjgl.opengl.GL41;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public class ScreenShot {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public static String saveScreenshot(File mcDir, int width, int height) {
        try {
            File destFile;
            File screenshotsDir = new File(mcDir, "screenshots");
            screenshotsDir.mkdir();
            String dateString = dateFormat.format(new Date());
            int id = 1;
            while ((destFile = new File(screenshotsDir, dateString + (String)(id != 1 ? "_" + id : "") + ".png")).exists()) {
                ++id;
            }
            ByteBuffer buffer1 = MemoryUtil.memCalloc(width * height * 3);
            ByteBuffer buffer2 = MemoryUtil.memCalloc(width * height * 3);
            GL41.glPixelStorei(3333, 1);
            GL41.glPixelStorei(3317, 1);
            GL41.glReadPixels(0, 0, width, height, 6407, 5121, buffer1);
            for (int y = 0; y < height; ++y) {
                int index = y * width * 3;
                buffer2.put(index, buffer1, height * width * 3 - (y + 1) * width * 3, width * 3);
            }
            STBImageWrite.stbi_write_png(destFile.getAbsolutePath(), width, height, 3, buffer2, width * 3);
            MemoryUtil.memFree(buffer1);
            MemoryUtil.memFree(buffer2);
            try {
                boolean copiedImage = FileOpener.toClipboard(destFile.getAbsolutePath());
                if (copiedImage) {
                    return "Saved screenshot as " + destFile.getName() + " and copied to clipboard.";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Saved screenshot as " + destFile.getName();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save screenshot!", exception);
            return "Failed to save: " + String.valueOf(exception);
        }
    }
}

