/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Option<T> {
    private static final @NotNull None<?> NONE = Option.none();

    public static <T> @NotNull None<@NotNull T> none() {
        return NONE;
    }

    public static <T> @NotNull Some<@NotNull T> some(@NotNull T value) {
        return new Some<T>(Objects.requireNonNull(value));
    }

    public abstract boolean isSome();

    public abstract boolean isSomeAnd(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> var1);

    public abstract boolean isNone();

    public abstract boolean isNoneOr(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> var1);

    @NotNull
    public abstract T expect(@NotNull String var1) throws UnwrapError;

    @NotNull
    public abstract T unwrap() throws UnwrapError;

    @NotNull
    public abstract T unwrapOr(@NotNull T var1);

    @NotNull
    public abstract T unwrapOrElse(@NotNull @NotNull Supplier<@NotNull T> var1);

    @NotNull
    public abstract <U> @NotNull Option<@NotNull U> map(@NotNull @NotNull Function<@NotNull T, @NotNull U> var1);

    @NotNull
    public abstract @NotNull Option<@NotNull T> inspect(@NotNull Consumer<T> var1);

    @NotNull
    public abstract <U> U mapOr(@NotNull U var1, @NotNull @NotNull Function<@NotNull T, @NotNull U> var2);

    @NotNull
    public abstract <U> U mapOrElse(@NotNull @NotNull Supplier<@NotNull U> var1, @NotNull @NotNull Function<@NotNull T, @NotNull U> var2);

    @NotNull
    public abstract <U> @NotNull Option<@NotNull U> and(@NotNull @NotNull Option<@NotNull U> var1);

    @NotNull
    public abstract <U> @NotNull Option<@NotNull U> andThen(@NotNull @NotNull Function<@NotNull T, @NotNull Option<@NotNull U>> var1);

    @NotNull
    public abstract @NotNull Option<@NotNull T> filter(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> var1);

    @NotNull
    public abstract @NotNull Option<@NotNull T> or(@NotNull @NotNull Option<@NotNull T> var1);

    @NotNull
    public abstract @NotNull Option<@NotNull T> orElse(@NotNull @NotNull Supplier<@NotNull Option<@NotNull T>> var1);

    @NotNull
    public abstract @NotNull Option<@NotNull T> xor(@NotNull @NotNull Option<@NotNull T> var1);

    public static final class None<T>
    extends Option<T> {
        private None() {
        }

        @Override
        public boolean isSome() {
            return false;
        }

        @Override
        public boolean isSomeAnd(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> f) {
            return false;
        }

        @Override
        public boolean isNone() {
            return true;
        }

        @Override
        public boolean isNoneOr(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> f) {
            return true;
        }

        @Override
        @NotNull
        public T expect(@NotNull String msg) throws UnwrapError {
            throw new UnwrapError(msg);
        }

        @Override
        @NotNull
        public T unwrap() throws UnwrapError {
            throw new UnwrapError("Called `Option::unwrap()` on a `None` value");
        }

        @Override
        @NotNull
        public T unwrapOr(@NotNull T or) {
            return or;
        }

        @Override
        @NotNull
        public T unwrapOrElse(@NotNull @NotNull Supplier<@NotNull T> f) {
            return f.get();
        }

        @Override
        @NotNull
        public <U> @NotNull Option<@NotNull U> map(@NotNull @NotNull Function<@NotNull T, @NotNull U> f) {
            return Option.none();
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> inspect(@NotNull Consumer<T> f) {
            return this;
        }

        @Override
        @NotNull
        public <U> U mapOr(@NotNull U or, @NotNull @NotNull Function<@NotNull T, @NotNull U> f) {
            return or;
        }

        @Override
        @NotNull
        public <U> U mapOrElse(@NotNull @NotNull Supplier<@NotNull U> orElse, @NotNull @NotNull Function<@NotNull T, @NotNull U> f) {
            return orElse.get();
        }

        @Override
        @NotNull
        public <U> @NotNull Option<@NotNull U> and(@NotNull @NotNull Option<@NotNull U> optb) {
            return Option.none();
        }

        @Override
        @NotNull
        public <U> @NotNull Option<@NotNull U> andThen(@NotNull @NotNull Function<@NotNull T, @NotNull Option<@NotNull U>> f) {
            return Option.none();
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> filter(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> predicate) {
            return this;
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> or(@NotNull @NotNull Option<@NotNull T> optb) {
            return optb;
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> orElse(@NotNull @NotNull Supplier<@NotNull Option<@NotNull T>> f) {
            return f.get();
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> xor(@NotNull @NotNull Option<@NotNull T> optb) {
            return optb;
        }

        public boolean equals(@Nullable Object obj) {
            Option opt;
            return obj instanceof Option && (opt = (Option)obj).isNone();
        }

        @NotNull
        public String toString() {
            return "Option.None";
        }
    }

    public static final class Some<T>
    extends Option<T> {
        @NotNull
        private final T value;

        private Some(@NotNull T value) {
            this.value = value;
        }

        @NotNull
        public T get() {
            return this.value;
        }

        @Override
        public boolean isSome() {
            return true;
        }

        @Override
        public boolean isSomeAnd(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> f) {
            return f.apply(this.value);
        }

        @Override
        public boolean isNone() {
            return false;
        }

        @Override
        public boolean isNoneOr(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> f) {
            return f.apply(this.value);
        }

        @Override
        @NotNull
        public T expect(@NotNull String msg) {
            return this.value;
        }

        @Override
        @NotNull
        public T unwrap() {
            return this.value;
        }

        @Override
        @NotNull
        public T unwrapOr(@NotNull T or) {
            return this.value;
        }

        @Override
        @NotNull
        public T unwrapOrElse(@NotNull @NotNull Supplier<@NotNull T> f) {
            return this.value;
        }

        @Override
        @NotNull
        public <U> @NotNull Option<@NotNull U> map(@NotNull @NotNull Function<@NotNull T, @NotNull U> f) {
            return Option.some(f.apply(this.value));
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> inspect(@NotNull Consumer<T> f) {
            f.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public <U> U mapOr(@NotNull U or, @NotNull @NotNull Function<@NotNull T, @NotNull U> f) {
            return f.apply(this.value);
        }

        @Override
        @NotNull
        public <U> U mapOrElse(@NotNull @NotNull Supplier<@NotNull U> orElse, @NotNull @NotNull Function<@NotNull T, @NotNull U> f) {
            return f.apply(this.value);
        }

        @Override
        @NotNull
        public <U> @NotNull Option<@NotNull U> and(@NotNull @NotNull Option<@NotNull U> optb) {
            return optb;
        }

        @Override
        @NotNull
        public <U> @NotNull Option<@NotNull U> andThen(@NotNull @NotNull Function<@NotNull T, @NotNull Option<@NotNull U>> f) {
            return f.apply(this.value);
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> filter(@NotNull @NotNull Function<@NotNull T, @NotNull Boolean> predicate) {
            if (predicate.apply(this.value).booleanValue()) {
                return this;
            }
            return Option.none();
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> or(@NotNull @NotNull Option<@NotNull T> optb) {
            return this;
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> orElse(@NotNull @NotNull Supplier<@NotNull Option<@NotNull T>> f) {
            return this;
        }

        @Override
        @NotNull
        public @NotNull Option<@NotNull T> xor(@NotNull @NotNull Option<@NotNull T> optb) {
            if (optb.isSome()) {
                return Option.none();
            }
            return this;
        }

        public boolean equals(@Nullable Object obj) {
            Some opt;
            return obj instanceof Some && this.value.equals((opt = (Some)obj).get());
        }

        @NotNull
        public String toString() {
            return "Option.Some(" + String.valueOf(this.value) + ")";
        }
    }

    public static final class UnwrapError
    extends Error {
        public UnwrapError(@NotNull String msg) {
            super(msg);
        }
    }
}

