/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.SeasonManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkCache
implements WorldSource {
    @NotNull
    private final ChunkPos origin;
    @NotNull
    private final @NotNull Chunk @NotNull [] @NotNull [] chunkArray;
    @NotNull
    private final World world;
    private final int widthX;
    private final int widthZ;

    public ChunkCache(@NotNull World world, @NotNull TilePos min, @NotNull TilePos max, boolean priority) {
        this.world = world;
        this.origin = new ChunkPos(min);
        @NotNull ChunkPos chunkMax = new ChunkPos(max);
        this.widthX = chunkMax.x - this.origin.x + 1;
        this.widthZ = chunkMax.z - this.origin.z + 1;
        this.chunkArray = new Chunk[this.widthX][this.widthZ];
        for (int x = 0; x < this.widthX; ++x) {
            for (int z = 0; z < this.widthZ; ++z) {
                this.chunkArray[x][z] = this.world.getChunk(new ChunkPos(x + this.origin.x, z + this.origin.z), priority);
            }
        }
    }

    @Deprecated
    public ChunkCache(@NotNull World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this(world, new TilePos(minX, minY, minZ), new TilePos(maxX, maxY, maxZ), true);
    }

    public boolean allLoaded() {
        for (int x = 0; x < this.widthX; ++x) {
            for (int z = 0; z < this.widthZ; ++z) {
                if (this.world.isChunkLoaded(new ChunkPos(x + this.origin.x, z + this.origin.z))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getHeightBlocks() {
        return this.world.getHeightBlocks();
    }

    @Override
    @NotNull
    public Block<?> getBlockType(@NotNull TilePosc tilePos) {
        if (tilePos.y() < 0 || tilePos.y() >= this.getHeightBlocks()) {
            return Blocks.AIR;
        }
        @NotNull ChunkPos cachePos = new ChunkPos(tilePos).sub(this.origin.x, this.origin.z, new ChunkPos());
        if (cachePos.x < 0 || cachePos.x >= this.chunkArray.length || cachePos.z < 0 || cachePos.z >= this.chunkArray[cachePos.x].length) {
            return Blocks.AIR;
        }
        @NotNull Chunk chunk = this.chunkArray[cachePos.x][cachePos.z];
        return chunk.getBlock(new ChunkTilePos(tilePos));
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(@NotNull TilePosc tilePos) {
        @NotNull ChunkPos cachePos = new ChunkPos(tilePos).sub(this.origin.x, this.origin.z, new ChunkPos());
        return this.chunkArray[cachePos.x][cachePos.z].getTileEntity(new ChunkTilePos(tilePos));
    }

    public boolean getBlockLitInteriorSurface(@NotNull TilePosc tilePos) {
        if (!tilePos.inBounds(this)) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this.world, tilePos);
    }

    @Deprecated
    public boolean getBlockLitInteriorSurface(int x, int y, int z) {
        return this.getBlockLitInteriorSurface(new TilePos(x, y, z));
    }

    @Override
    public float getBrightness(@NotNull TilePosc tilePos, int lightEmission) {
        int lightValue = this.getBlockLightValue(tilePos);
        return this.world.getWorldType().getBrightnessRamp()[Math.max(lightValue, lightEmission)];
    }

    @Override
    public int getLightmapCoord(@NotNull TilePosc tilePos, int lightEmission) {
        int skyLight = this.world.getSavedLightValue(LightLayer.Sky, tilePos);
        int blockLight = Math.max(this.world.getSavedLightValue(LightLayer.Block, tilePos), lightEmission);
        TilePos queryPos = new TilePos();
        if (this.getBlockLitInteriorSurface(tilePos)) {
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, tilePos.up(queryPos)));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, tilePos.down(queryPos)));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, tilePos.east(queryPos)));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, tilePos.west(queryPos)));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, tilePos.south(queryPos)));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, tilePos.north(queryPos)));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, tilePos.up(queryPos)));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, tilePos.down(queryPos)));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, tilePos.east(queryPos)));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, tilePos.west(queryPos)));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, tilePos.south(queryPos)));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, tilePos.north(queryPos)));
        }
        return this.getLightmapCoord(skyLight, blockLight);
    }

    @Override
    public int getLightmapCoord(int skyLight, int blockLight) {
        return this.world.getLightmapCoord(skyLight, blockLight);
    }

    @Override
    public float getLightBrightness(@NotNull TilePosc tilePos) {
        return this.world.worldType.getBrightnessRamp()[this.getBlockLightValue(tilePos)];
    }

    public int getBlockLightValue(@NotNull TilePosc tilePos) {
        return this.getBlockLightValue_do(tilePos, true);
    }

    @Deprecated
    public int getLightValue(int x, int y, int z) {
        return this.getBlockLightValue(new TilePos(x, y, z));
    }

    @Deprecated
    private int getBlockLightValue_do(@NotNull TilePosc tilePos, boolean first) {
        if (tilePos.x() < -32000000 || tilePos.z() < -32000000 || tilePos.x() >= 32000000 || tilePos.z() > 32000000) {
            return 15;
        }
        if (first) {
            TilePos queryPos = new TilePos();
            if (this.getBlockLitInteriorSurface(tilePos)) {
                int lightUp = this.getBlockLightValue_do(tilePos.up(queryPos), false);
                int lightEast = this.getBlockLightValue_do(tilePos.east(queryPos), false);
                int lightWest = this.getBlockLightValue_do(tilePos.west(queryPos), false);
                int lightSouth = this.getBlockLightValue_do(tilePos.south(queryPos), false);
                int lightNorth = this.getBlockLightValue_do(tilePos.north(queryPos), false);
                return Math.max(lightUp, Math.max(lightEast, Math.max(lightWest, Math.max(lightSouth, lightNorth))));
            }
        }
        if (tilePos.y() < 0) {
            return 0;
        }
        if (tilePos.y() >= this.getHeightBlocks()) {
            int brightness = 15 - this.world.skyDarken;
            if (brightness < 0) {
                brightness = 0;
            }
            return brightness;
        }
        @NotNull ChunkPos cachePos = new ChunkPos(tilePos).sub(this.origin.x, this.origin.z, new ChunkPos());
        return this.chunkArray[cachePos.x][cachePos.z].getRawBrightness(new ChunkTilePos(tilePos), this.world.skyDarken);
    }

    @Override
    public int getBlockData(@NotNull TilePosc tilePos) {
        if (tilePos.y() < 0 || tilePos.y() >= this.getHeightBlocks()) {
            return 0;
        }
        @NotNull ChunkPos cachePos = new ChunkPos(tilePos).sub(this.origin.x, this.origin.z, new ChunkPos());
        return this.chunkArray[cachePos.x][cachePos.z].getBlockData(new ChunkTilePos(tilePos));
    }

    @Override
    @NotNull
    public Material getBlockMaterial(@NotNull TilePosc tilePos) {
        return this.getBlockType(tilePos).getMaterial();
    }

    @Override
    public boolean isBlockOpaqueCube(@NotNull TilePosc tilePos) {
        return this.getBlockType(tilePos).isSolidRender();
    }

    @Override
    public boolean isBlockNormalCube(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlockType(tilePos);
        return block.getMaterial().isSolidBlocking() && block.renderAsNormalBlockOnCondition(this, tilePos);
    }

    @Override
    public double getBlockTemperature(@NotNull TilePosc tilePos) {
        return this.world.getBlockTemperature(tilePos);
    }

    @Override
    public double getBlockHumidity(@NotNull TilePosc tilePos) {
        return this.world.getBlockHumidity(tilePos);
    }

    @Override
    public double getBlockVariety(@NotNull TilePosc tilePos) {
        return this.world.getBlockVariety(tilePos);
    }

    @Override
    @NotNull
    public SeasonManager getSeasonManager() {
        return this.world.getSeasonManager();
    }

    @Override
    @NotNull
    public Biome getBlockBiome(@NotNull TilePosc tilePos) {
        return this.world.getBlockBiome(tilePos);
    }

    @Override
    public int getSavedLightValue(@NotNull LightLayer lightLayer, @NotNull TilePosc tilePos) {
        return this.world.getSavedLightValue(lightLayer, tilePos);
    }

    @Override
    public boolean isRetro() {
        return this.world.isRetro();
    }
}

