/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import net.minecraft.core.world.noise.Noise3D;
import net.minecraft.core.world.noise.operator.Emboss2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class Emboss3D<T extends Noise3D>
extends Emboss2D<T>
implements Noise3D {
    @NotNull
    private final Vector2d range = new Vector2d();

    public Emboss3D(@NotNull T noise) {
        super(noise);
    }

    @Override
    @NotNull
    public Vector2dc getRange3D() {
        @NotNull Vector2dc noiseRange = ((Noise3D)this.noise).getRange3D();
        this.range.set(noiseRange.x() - noiseRange.y(), noiseRange.y() - noiseRange.x());
        return this.range;
    }

    @Override
    public double getValue(double x, double y, double z) {
        return ((Noise3D)this.noise).getValue(x, y, z) - ((Noise3D)this.noise).getValue(x + 1.0, y + 1.0, z + 1.0);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * ySize * zSize) {
            out = new double[xSize * ySize * zSize];
        }
        double @NotNull [] valuesA = ((Noise3D)this.noise).addRegion(null, x, y, z, xSize, ySize, zSize, xScale, yScale, zScale, amplitude);
        double @NotNull [] valuesB = ((Noise3D)this.noise).addRegion(null, x + 1.0, y + 1.0, z + 1.0, xSize, ySize, zSize, xScale, yScale, zScale, amplitude);
        for (int i = 0; i < out.length; ++i) {
            int n = i;
            out[n] = out[n] + (valuesA[i] - valuesB[i]);
        }
        return out;
    }
}

